@extends('layouts.master')

@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
        <h6 class="m-0 table__top__txt">Edit Income Item</h6>
    </div>
    <div class="card-body">
        <form action="{{ route('income-item.update', $incomeItem) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="name">Name</label>
                <input type="text" name="name" class="form-control" value="{{ $incomeItem->name }}" required>
            </div>
            <div class="form-group">
                <label for="description">Description</label>
                <textarea name="description" class="form-control">{{ $incomeItem->description }}</textarea>
            </div>
            <div class="form-group">
                <label for="income_head_id">Income Head</label>
                <select name="income_head_id" class="form-control">
                    @foreach ($incomeHeads as $incomeHead)
                        <option value="{{ $incomeHead->id }}" {{ $incomeItem->income_head_id == $incomeHead->id ? 'selected' : '' }}>{{ $incomeHead->name }}</option>
                    @endforeach
                </select>
            </div>
            <button type="submit" class="btn btn-success">Update</button>
        </form>
    </div>
</div>
@endsection
