@extends('layouts.master')

@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
        <h6 class="m-0 table__top__txt">Income Item List</h6>
        <div class="m-0 float-right">
            @can('accounting.income-item.create')
                <a href="{{route('income-item.create')}}" class="btn btn-sm btn-light-blue">Add New</a>
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Head</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($items as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->name }}</td>
                                <td>{{ $item->description }}</td>
                                <td>{{ $item->incomeHead->name }}</td>
                                <td>
                                    <a href="{{ route('income-item.edit', $item) }}" class="btn btn-sm btn-soft-info"><i class="fa fa-edit"></i></a>
                                    <form action="{{ route('income-item.destroy', $item) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
