@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-xl-12 col-xxl-10 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Income List</h6>
                <div class="m-0 float-right">
                    @can('accounting.income.create')
                        <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Head</th>
                                    <th>Invoice No</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Note</th>
                                    <th>Attachment</th>
                                    {{-- <th>Payment method</th> --}}
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @forelse($incomes as $income)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>
                                            {{  $incomeHeads[$income->accounting_head_id] ?? 'N/A' }}
                                        </td>
                                        <td>{{ $income->invoice_no ?? '' }}</td>
                                        <td>{{ $income->amount ?? '' }}</td>
                                        <td>{{ view_date_format($income->income_date) ?? 'N/A' }}</td>
                                        <td>{{ $income->description ?? 'N/A' }}</td>
                                        <td>
                                            @if ($income->attachment)
                                                <a class="btn btn-sm btn-info" href="{{ asset($income->attachment) }}" target="_blank">Attachment</a>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        {{-- <td>{{ $income->payment_method ?? "N/A"}}</td> --}}
                                        <td class="d-flex justify-content-start">
                                            @can('accounting.income.edit')
                                                <button class="btn btn-sm btn-soft-info edit-category-btn mr-1" data-toggle="modal"
                                                data-target="#dataEditModal" data-id="{{ $income->id }}"
                                                data-accounting_head_id="{{ $income->accounting_head_id }}" data-amount="{{ $income->amount }}"
                                                data-income_date="{{ view_date_format($income->income_date) }}" data-description="{{ $income->description }}"
                                                data-invoice_no="{{ $income->invoice_no }}" data-attachment="{{ $income->attachment ? asset($income->attachment) : '' }}"
                                                data-payment_method="{{ $income->payment_method }}"
                                                ><i class="fas fa-edit"></i></button>
                                            @endcan
                                            <a href="{{ route('income.print', $income->id) }}" target="_blank" class="btn btn-soft-secondary btn__export mr-1">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            @can('accounting.income.delete')
                                                <form action="{{ route('income.destroy', $income->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">No data found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- create Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="{{ route('income.store') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Income</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <div class="form-group">
                        <label for="accounting_head_id">Income Head <span class="text-danger">*</span></label>
                        {{ generateDropdown($incomeHeads, 'name="accounting_head_id" class="form-control form-control-sm" id="accounting_head_id" required', old('accounting_head_id'), '--Secect Head--' ) }}
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount">Amount <span class="text-danger">*</span></label>
                                <input type="number" name="amount" min="0" class="form-control form-control-sm" id="amount" placeholder="Enter amount" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="income_date">Income Date <span class="text-danger">*</span></label>
                                <input type="text" name="income_date" class="form-control form-control-sm income_date date3601" id="date1" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        {{-- <div class="col-md-6">
                            <div class="form-group">
                                <label for="invoice_no">Invoice No</label>
                                <input type="text" name="invoice_no" class="form-control form-control-sm invoice_no" id="invoice_no" placeholder="Enter Invoice No">
                            </div>
                        </div> --}}
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="attachment">Attachment</label> <span id="attachment-link"></span>
                                <input type="file" name="attachment" class="form-control form-control-sm" id="attachment">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description">Note</label>
                        <textarea name="description" cols="30" rows="2" class="form-control form-control-sm  description" id="description" placeholder="Enter Note"></textarea>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm2' method="POST" action="{{ route('income.update') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel2">Edit Income </h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <div class="form-group">
                        <label for="accounting_head_id_edit">Income Head <span class="text-danger">*</span></label>
                        {{ generateDropdown($incomeHeads, 'name="accounting_head_id" class="form-control form-control-sm" id="accounting_head__edit" required', old('accounting_head_id'), '--Secect Head--' ) }}
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount_edit">Amount <span class="text-danger">*</span></label>
                                <input type="number" name="amount" min="0" class="form-control form-control-sm" id="amount_edit" placeholder="Enter amount" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="income_date_edit">Income Date <span class="text-danger">*</span></label>
                                <input type="text" name="income_date" class="form-control form-control-sm income_date date3603" id="income_date_edit" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        {{-- <div class="col-md-6">
                            <div class="form-group">
                                <label for="invoice_no_edit">Invoice No</label>
                                <input type="text" name="invoice_no" class="form-control form-control-sm invoice_no" id="invoice_no_edit" placeholder="Enter Invoice No">
                            </div>
                        </div> --}}
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="attachment_edit">Attachment</label> <span id="attachment-link"></span>
                                <input type="file" name="attachment" class="form-control form-control-sm" id="attachment_edit">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description_edit">Note</label>
                        <textarea name="description" cols="30" rows="2" class="form-control form-control-sm  description" id="description_edit" placeholder="Enter Note"></textarea>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary submitBtn">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
@endsection
@section('scripts')
<script>
    $(document).ready(function () {
        const today = new Date();
        $('.date3601').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        }).datepicker('setDate', today);
        $('.date3603').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
            todayHighlight: true,
        })
        $('#dataEditModal').on('hidden.bs.modal', function () {
            // Reset the form inside the modal
            $(this).find('form')[0].reset();
            // Optionally, reset specific fields manually (in case you're setting them dynamically)
            $(this).find('.form-control').val('');
            $(this).find('.form-control-sm').val('');
        });

        $('#dataEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var accounting_head_id = button.data('accounting_head_id')
            var amount = button.data('amount')
            var income_date = button.data('income_date')
            var description = button.data('description')
            var invoice_no = button.data('invoice_no')
            var id = button.data('id')
            var modal = $(this)
            if (!modal.find('#amount_edit').val()) {
                modal.find('#amount_edit').val(amount)
            }
            if (!modal.find('#income_date_edit').val()) {
                modal.find('#income_date_edit').val(income_date)
            }
            if (!modal.find("#accounting_head__edit").val()) {
                modal.find("#accounting_head__edit option[value=" + accounting_head_id + "]").prop("selected", true);
            }
            if (!modal.find('#invoice_no_edit').val()) {
                modal.find('#invoice_no_edit').val(invoice_no)
            }
            if (!modal.find('#description_edit').val()) {
                modal.find('#description_edit').val(description)
            }
            if (!modal.find('#id').val()) {
                modal.find('#id').val(id)
            }
        });
    });
</script>
@endsection
