@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-body card__head">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link {{ $tab === 'search' ? 'active' : '' }}" data-toggle="tab" href="#search-tab">Search By ID</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ $tab === 'filter' ? 'active' : '' }}" data-toggle="tab" href="#filter-tab">Search by Class</a>
            </li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <div id="search-tab" class="tab-pane {{ $tab === 'search' ? 'show active' : '' }}">
                <form method="POST" action="{{ route('student_discount.search') }}" class="row">
                    <input type="hidden" name="tab" value="search">
                    @csrf
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        @component('components.search_student', ['student_name' => $student_name ?? '', 'student_id_no' => $student_id_no ?? ''])
                        @endcomponent
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            <div id="filter-tab" class="tab-pane fade {{ $tab === 'filter' ? 'show active' : '' }}">
                <form method="POST" action="{{ route('student_discount.search') }}" class="row">
                    @csrf
                    <input type="hidden" name="tab" value="filter">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id"', $student_class_id, "Class") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section') }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Shift") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, "Group") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@if (isset($students))
<div class="card mt-4">
    <div class="row">
        <div class="col-md-12">
            @csrf
            @if (!empty($students))
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                            <tr>
                                <th>Roll</th>
                                <th>ID No</th>
                                <th>Student Name</th>
                                <th>Class</th>
                                <th>Discount Type</th>
                                <th>Amount/Percentage</th>
                                <th>Note</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($students as $student)
                            @php
                                $selectedDiscountType = $student->studentDiscount?->discount_type ?? '';
                            @endphp
                                <tr>
                                    <td>{{ $student->class_roll ?? '' }}</td>
                                    <td>
                                        {{ $student->student_id_no }}
                                        <input type="hidden" name="student_id" value="{{$student->id}}">
                                        <input type="hidden" name="class_id" value="{{$student->student_class_id}}">
                                    </td>
                                    <td>{{ $student->first_name }} {{ $student->last_name }}</td>
                                    <td>{{ $student->studentClass->class_name ?? '' }}</td>
                                    <td>
                                        <select name="discount_type" class="form-control form-control-sm" id="discount_type">
                                            <option value="fixedamount" {{ $selectedDiscountType == 'fixedamount' ? 'selected' : '' }}>Fixed Amount</option>
                                            <option value="percentage" {{ $selectedDiscountType == 'percentage' ? 'selected' : '' }}>Percentage(%)</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="number" name="amount"
                                            value="{{array_key_exists($student->id,$previous_discount) ? $previous_discount[$student->id]: ''}}"
                                            class="form-control form-control-sm">
                                    </td>
                                    <td>
                                        <input type="text" name="note" class="form-control form-control-sm"
                                        value="{{array_key_exists($student->id,$previous_discount_note) ? $previous_discount_note[$student->id]: ''}}" >
                                    </td>
                                    <td>
                                        @can('accounting.fees-discount.create')
                                            <button class="btn btn-sm btn-info save-discount" title="Save">Save</button>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endif
@stop

@section('scripts')
    <script>
        $('.save-discount').on('click', function() {

            var button = $(this);
            var originalButtonText = button.text();

            // Set the loading state
            button.text('Saving...').prop('disabled', true);

            var row = $(this).closest('tr');
            var studentId = row.find('input[name="student_id"]').val();
            var class_id = row.find('input[name="class_id"]').val();
            var discountType = row.find('select[name="discount_type"]').val();
            var amount = parseFloat(row.find('input[name="amount"]').val() || 0);
            var note = row.find('input[name="note"]').val();

            if(amount<=0){
                return toastr.error("Please give a amount!", 'Error');
            }
            $.ajax({
                url: '{{ route("student_discount.store") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    student_id: studentId,
                    class_id: class_id,
                    discount_type: discountType,
                    amount: amount,
                    note: note
                },
                success: function(response) {
                    // Handle success response
                    toastr.success("Discount saved successfully!", 'Success');
                },
                error: function(xhr) {
                    // Handle error response
                    toastr.error("Error saving discount!", 'Error');
                },
                complete: function() {
                    // Revert the button back to its original state
                    button.text(originalButtonText).prop('disabled', false);
                }
            });
        });

        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){

                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }

    </script>
@endsection
