@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-body card__head">
        <form method="POST" action="{{ route('student_discount.search') }}" class="row">
            @csrf
            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                @component('components.search_student', ['student_name' => $student_name ?? '', 'student_id_no' => $student_id_no ?? ''])
                @endcomponent
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Select Shift") }}
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id"', $student_class_id, "Select Class") }}
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($sections, 'class="form-control section_id" id="section_id" name="section_id"', $section_id) }}
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, "Select Group") }}
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                <button type="submit" class="btn btn-info ">Search</button>
            </div>
        </form>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
        <h5>Fees Discount</h5>
        @can('accounting.fees-discount.create')
            <a href="{{route('student_discount.create')}}" class="btn btn-success mb-2" >Create Fees Discount</a>
        @endcan
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <form method="POST" action="{{ route('marks.store') }}" class="form-inline">
                    @csrf
                    @if (!empty($students))


                    @endif
                </form>
            </div>
        </div>
    </div>
</div>
@stop
@section('scripts')
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;

                    let option = '<option value="">--Select Section--</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }
    </script>
@endsection
