@extends('layouts.master')
@section('content')

    <div class="row">
        <div class="col-xl-12 col-xxl-12 m-auto">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif


            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Admission Fees</h6>
                    <div class="m-0 float-right">
                        @can('academic.subjects-list.create')
                            <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal" data-target="#AdmissionFeeStoreModal">Add
                                New</button>
                        @endcan
                        
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table data-table">
                                <thead class="thead-light">
                                <tr>
                                    <th>Class Name</th>
                                    <th>Admission Fee</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Admission Fees create Modal -->
    <div class="modal fade" id="AdmissionFeeStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('admission-fee.store') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Admission Fee </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>

                        <div class="form-group">
                            <label for="student_class_id" class="form-label">Student Class  <span class="text-danger">*</span></label>
                            {{ generateDropdown($studentClasses, 'class="form-control" name="student_class_id" required', old('student_class_id'), 'Select Option') }}
                        </div>

                        <div class="form-group">
                            <label for="admission_fee" class="form-label">Admission Fee <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="admission_fee"  name="admission_fee" min="0" value="{{ old('admission_fee') }}" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Admission Fees edit Modal -->
    <div class="modal fade" id="AdmissionFeeEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('admission-fee.update') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Admission Fee </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">

                        <div class="form-group">
                            <label for="student_class_id_edit" class="form-label">Student Class  <span class="text-danger">*</span></label>
                            {{ generateDropdown($studentClasses, 'class="form-control" id="student_class_id_edit" name="student_class_id" required', old('student_class_id'), 'Select Option') }}
                        </div>
                        <div class="form-group">
                            <label for="admission_fee_edit" class="form-label">Admission Fee <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="admission_fee_edit"  name="admission_fee" min="0"  required>
                        </div>

                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@stop

@section('scripts')
<script type="text/javascript">
   $(function () {
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('admission-fee.index') }}",
            columns: [
                {data: 'class_name', name: 'class_name'},
                {data: 'admission_fee', name: 'admission_fee'}, // ✅ works now
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        let editButton = `
                            <button class="btn btn-sm btn-soft-info mr-1 edit-btn"
                                data-id="${row.id}"
                                data-student-class="${row.student_class_id}"
                                data-admission-fee="${row.admission_fee}"
                                data-toggle="modal"
                                data-target="#AdmissionFeeEditModal">
                                <i class="fas fa-edit"></i>
                            </button>
                        `;          
                        let deleteUrlTemplate = "{{ route('admission-fee.destroy', ':id') }}";
                        let deleteButton = `
                            <a href="${deleteUrlTemplate.replace(':id', row.id)}"
                            class="btn btn-sm btn-soft-danger mr-1 delete-btn"
                            data-toggle="tooltip"
                            title="Delete">
                            <i class="fas fa-trash"></i>
                            </a>
                        `;



                        return '<div class="d-flex justify-content-center">' + editButton + deleteButton + '</div>';
                        
                    }
                }
            ]
        });
    });
</script>


<script type="text/javascript">
    // Confirmation before delete
        $(document).on('click', '.delete-btn', function(e) {
            e.preventDefault(); // prevent default link

            var link = $(this).attr('href');

            if (confirm('Are you sure you want to delete this Admission Fee?')) {
                window.location.href = link; // go to delete URL
            }
        });



        // Save active tab on click
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });

        // Load active tab on page reload
        $(document).ready(function () {
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });

        $('#AdmissionFeeEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var class_id = button.data('student-class')
            var admission_fee = button.data('admission-fee')
            var status = button.data('status')
            var id = button.data('id')
            console.log(admission_fee);
            var modal = $(this)
            modal.find('#id').val(id)
            modal.find('#admission_fee_edit').val(admission_fee)
            modal.find("#student_class_id_edit option[value=" + class_id + "]").prop("selected", true);
        })
    </script>
@endsection
