@extends('layouts.master')
@section('content')
    <style>
        body {
            font-family: sans-serif;
        }

        p {
            margin-top: 0;
            margin-bottom: 10px;
        }

        .invoice_header .content h2 {
            margin-top: 0;
            margin-bottom: 12px;
            font-size: 21px;
            font-weight: 700;
        }

        .invoice_header .content p {
            margin-bottom: 5px;
            font-weight: 300;
            color: #5a5a5a;
            font-size: 15px;
        }

        .invoice_header {
            display: flex;
        }

        .invoice_header .img {
            width: 25%;
        }

        .invoice_header .img img {
            width: 160px;
            height: 114px;
        }

        .invoice_header .content {
            color: black;
            width: 75%;
        }

        .invoice_footer .title_message {
            text-align: center;
            margin-top: 0;
            font-family: cursive;
            color: black;
            margin-bottom: 7px;
            font-size: 13px;
        }

        .invoice_footer .powerby {
            color: #747474;
            font-size: 12px;
            font-weight: 300;
            text-align: center;
            background: #eee;
            margin-top: 12px;
            padding: 5px;
            line-height: 1;
        }

        .invoice_footer .powerby span {
            color: black;
            letter-spacing: .5px;
            font-weight: bold;
        }

        .invoice_content {
            width: 100%;
            max-width: 210mm;
            margin: 0px auto 2.5em;
            padding: 20px;
            border: 1px dotted #ccc;
            background-color: #fff;
        }

        .invoice_body {
            padding: 15px 0;
        }

        .invoice_body .head {
            padding: 15px;
            border: 1px solid #ededed;
            display: flex;
            margin-bottom: 8px;
            background-color: #f5f5f5b8;
        }

        .invoice_body .head .left {
            width: 50%;
            text-align: left;
            color: black;
        }

        .invoice_body .head .right p,
        .invoice_body .head .left p {
            margin-bottom: 7px;
            margin-top: 0;
            font-size: 15px;
        }

        .invoice_body .head .right {
            width: 50%;
            text-align: right;
            color: black;
        }

        .invoice_body .head .right span {
            font-weight: 700;
            font-size: 28px;
            color: green;
        }

        .invoice_body .body table thead {
            background: #e1e1e1;
        }

        .invoice_body .body table thead th:first-child {
            border-radius: 0 !important;
        }

        .invoice_body .body table thead th:nth-child(3),
        .invoice_body .body table tbody td:nth-child(3) {
            text-align: center;
        }

        .invoice_body .body table thead th:nth-child(4),
        .invoice_body .body table tbody td:nth-child(4) {
            text-align: center;
        }

        .invoice_body .body table thead th:last-child {
            border-radius: 0 !important;
            text-align: right;
        }

        .invoice_body .body table thead tr th {
            border: none;
            padding: 6px 10px;
            color: black;
            line-height: 1;
        }

        .invoice_body .body table {
            margin-bottom: 8px;
        }

        .invoice_body .body table tbody tr td {
            border-top: none;
            padding: 8px;
            color: black;
            border-bottom: 1px solid #e9e9e9;
        }

        .invoice_body .foot {
            display: flex;
        }

        .invoice_body .foot .prepared_by {
            width: 35%;
            text-align: center;
            margin-top: 50px !important;
        }

        .invoice_body .foot .prepared_by .name {
            border-top: 1px solid;
            color: black;
        }

        .invoice_body .foot .content {
            width: 65%;
            text-align: right;
            color: black;
            padding-right: 10px;
        }

        .invoice_body .foot .content p {
            margin-bottom: 6px;
            font-size: 14px;
            color: #4a4a4a;
        }

        @media print {
            .invoice_content {
                margin: 0;
                border: none;
                background-color: #fff;
            }

            #invoice {
                padding: 20px;
            }

            @page {
                size: A5;
                margin: 0;
            }

            body {
                margin: 0;
            }
        }
    </style>
    @if (isset($applicant) && !empty($applicant))

        @php
            $get_branch_info = get_branch_info();
            $logo = get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('default/default.png');
            $principal_signature = get_setting_value(Settings::PRINCIPAL_SIGNATURE) ? asset(get_setting_value(Settings::PRINCIPAL_SIGNATURE)) : '';
        @endphp
        
        <div class="card p-1 invoice">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                <button class="btn btn-success btn-sm" onclick="closeWindow()">Back</button>
                <button class="btn btn-success btn-sm" onclick="printInv()">Print</button>
            </div>
            <div class="card-body mt-4 invoice_content">
                <div class="invoice_header">
                    <div class="img">
                        <img src="{{ asset($logo) }}" alt="Logo">
                    </div>
                    <div class="content">
                        <h2>{{get_setting_value(Settings::SCHOOL_NAME)}}</h2>
                        <p>{{$get_branch_info->address}}</p>
                        <p>Contact: {{$get_branch_info->contact_info}}</p>
                        <p>Email: {{get_setting_value(Settings::SCHOOL_EMAIL)}}</p>
                    </div>
                </div>
                <div class="invoice_body">
                    <div class="head">
                        <div class="left">
                            <p><b>Name: {{ $applicant->first_name ?? '' }} {{ $applicant->last_name ?? '' }}</b>
                            </p>
                            <p>Form ID: {{ $applicant->form_id ?? '' }}</p>
                            <p>Class: {{ $applicant->studentClass->class_name ?? '' }} {{ $applicant?->section?->section_name ? ' (' . $applicant?->section?->section_name . ')' : '' }} </p>
                        </div>
                        <div class="right">
                            <p>Date: {{ date('d-m-Y', strtotime($applicant->invoice_date)) ?? '' }}</p>
                            <span>PAID</span>
                        </div>
                    </div>
                    <div class="body">
                        <table class="info-table" width="100%">
                            <thead>
                                <tr>
                                    <th align="left">Month</th>
                                    <th align="left">Fee Type</th>
                                    <th align="center">Total Amount</th>
                                    <th align="center">Discount</th>
                                    <th align="right">Grand Total</th>
                                </tr>
                            </thead>
                            <tbody border-bottom="5">
                                

                                    <tr>
                                        <td align="left">{{   Carbon\Carbon::create()->month($applicant->month)->format('F') }}</td>
                                        <td align="left">
                                            @php
                                                $fees = json_decode($applicant->fee_details, true);
                                            @endphp
                                            {!! str_replace(['[', ']', '"'], '', $fees) !!}
                                        </td>
                                        <td align="center">{{ $applicant->total_amount ?? '' }} Tk</td>
                                        <td align="center">{{ $applicant->total_discount ?? '' }} Tk</td>
                                        <td align="right">{{ $applicant->grand_total ?? '' }} Tk</td>
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="foot">
                        <div class="prepared_by">
                            @if ($principal_signature)
                                <img src="{{ asset($principal_signature) }}" height="60px" alt="Principal Signature">
                            @endif
                            <div class="name">Principal Signature</div>
                        </div>
                        <div class="content">
                            <p><b>Amount:</b> {{ $applicant->total_amount ?? '' }} Tk</p>
                            <p>Discount: {{ $applicant->total_discount ?? '0' }} Tk</p>
                            <p><b>Total Payable:</b>
                                {{ $applicant->grand_total }}.00 Tk</p>
                        </div>
                    </div>
                </div>
                <div class="invoice_footer">
                    <div class="powerby">
                        <div class="title_message">Thank you for your payment</div>
                        Powered By <span>EduEasy</span>
                    </div>
                </div>
            </div>
        </div>
    @endif

@endsection
@section('scripts')
    <script>
        // let print_preview = "{{ isset($print_preview) ? $print_preview : '' }}";
        // if (print_preview == 'yes') {
            printInv();
        // }
        function printInv() {
            let htmlToPrint = '';
            // let divToPrint = document.getElementById('invoice');
            let divToPrint = document.getElementsByClassName("invoice_content");

            const newWin = window.open("");

            htmlToPrint = `<style type="text/css" media="print">
                        @page { size: a5; }
                        .invoice_content{
                            visibility: ;
                        }
                        body{
                            font-family: sans-serif;
                            font-style: normal;
                            // max-width: 450px;
                            height: 210mm;
                            width: 148.5mm;
                            margin: 0;
                            -webkit-print-color-adjust: exact;
                        }
                        p{
                            margin-top: 0;
                            margin-bottom: 10px;
                        }
                        .invoice_header .content h2{
                            margin-top: 0;
                            margin-bottom: 12px;
                            font-size: 21px;
                            font-weight: 700;
                        }
                        .invoice_header .content p{
                            margin-bottom: 5px;
                            font-weight: 300;
                            color: #5a5a5a;
                            font-size: 15px;
                        }
                        .invoice_header {
                            display: flex;
                        }
                        .invoice_header .img {
                            width: 35%;
                        }
                        .invoice_header .img img {
                            width: 160px;
                            height: 114px;
                        }
                        .invoice_header .content {
                            color: black;
                            width: 65%;
                        }
                        .invoice_footer .title_message {
                            text-align: center;
                            margin-top: 0;
                            font-family: cursive;
                            color: black;
                            margin-bottom: 7px;
                            font-size: 13px;
                        }
                        .invoice_footer .powerby {
                            color: #747474;
                            font-size: 12px;
                            font-weight: 300;
                            text-align: center;
                            background: #eee;
                            margin-top: 12px;
                            padding: 5px;
                            line-height: 1;
                        }
                        .invoice_footer .powerby span {
                            color: black;
                            letter-spacing: .5px;
                            font-weight: bold;
                        }
                        .invoice_content {
                            width: 100%;
                            max-width: 210mm;
                            margin: 0px auto 2.5em;
                            padding: 20px;
                            border: 1px dotted #ccc;
                            background-color: #fff;
                        }
                        .invoice_body {
                            padding: 15px 0;
                        }
                        .invoice_body .head {
                            padding: 15px;
                            border: 1px solid #ededed;
                            display: flex;
                            margin-bottom: 8px;
                            background-color: #f5f5f5b8;
                        }
                        .invoice_body .head .left {
                            width: 50%;
                            text-align: left;
                            color: black;
                        }
                        .invoice_body .head .right p, .invoice_body .head .left p {
                            margin-bottom: 7px;
                            margin-top: 0;
                            font-size: 15px;
                        }
                        .invoice_body .head .right {
                            width: 50%;
                            text-align: right;
                            color: black;
                        }
                        .invoice_body .head .right span{
                            font-weight: 700;
                            font-size: 28px;
                            color: green;
                        }
                        .invoice_body .body table thead {
                            background: #e1e1e1;
                        }
                        .invoice_body .body table thead th:first-child {
                            border-radius: 0 !important;
                        }
                        .invoice_body .body table thead th:nth-child(3),
                        .invoice_body .body table tbody td:nth-child(3) {
                            text-align: center;
                        }
                        .invoice_body .body table thead th:nth-child(4),
                        .invoice_body .body table tbody td:nth-child(4) {
                            text-align: center;
                        }
                        .invoice_body .body table thead th:last-child {
                            border-radius: 0 !important;
                            text-align: right;
                        }
                        .invoice_body .body table thead tr th {
                            border: none;
                            padding: 6px 10px;
                            color: black;
                            line-height: 1;
                        }
                        .invoice_body .body table {
                            margin-bottom: 8px;
                        }
                        .invoice_body .body table tbody tr td {
                            border-top: none;
                            padding: 8px;
                            color: black;
                            border-bottom: 1px solid #e9e9e9;
                        }
                        .invoice_body .foot {
                            display: flex;
                        }
                        .invoice_body .foot .prepared_by {
                            width: 35%;
                            text-align: center;
                            vertical-align: bottom;
                            display: inline-grid;
                            margin-top: 50px !important;
                        }
                        .invoice_body .foot .prepared_by .name {
                            border-top: 1px solid;
                            color: black;
                        }
                        .invoice_body .foot .content {
                            width: 65%;
                            text-align: right;
                            color: black;
                            padding-right: 10px;
                        }
                        .invoice_body .foot .content p {
                            margin-bottom: 6px;
                            font-size: 14px;
                            color: #4a4a4a;
                        }
                    </style>`;

            newWin.document.write(htmlToPrint);

            newWin.document.write(divToPrint[0].outerHTML);
            newWin.document.close();
            // newWin.print();
            // newWin.close();
            setTimeout(function() {
                newWin.print();
                newWin.close();
            }, 90);
        }
        let printWindowClosed = false;

        function closeWindow() {
            if (!printWindowClosed) {
                printWindowClosed = true;
                window.close();
                if (window.opener) {
                    window.opener.focus();
                }
            }
        }
    </script>
@endsection
