@extends('layouts.master')
@section('styles')
<style>
        .image-uploader {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative; /* Add position relative */
        }

        .image-uploader__label {
            display: flex;
            flex-direction: column;
            align-items: center;
            cursor: pointer;
            position: relative; /* Add position relative */
        }

        .image-uploader__icon-overlay {
            position: absolute;
            top: 50%; /* Align vertically centered */
            left: 50%; /* Align horizontally centered */
            transform: translate(-50%, -50%); /* Center the icon */
            width: 100%;
            height: calc(100%); /* Height equal to parent minus icon height */
            background-color: rgba(0, 0, 0, 0.2); /* Transparent black background */
            border-radius: 50%; /* Rounded border */
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0.3;
        }

        .image-uploader__icon-overlay i {
            color: #ffffff; /* Icon color */
            font-size: 24px; /* Icon size */
        }

        /* Your existing styles */
        .image-uploader__preview {
            overflow: hidden;
        }

        .image-uploader__input {
            display: none;
        }

        .previous_institute_tc .dropify-wrapper{
            height: 122px !important;
        }

    </style>
@endsection
@section('content')
    <div class="container-fluid mt-5 mb-5">
        <div class="row justify-content-center">
            <div class="col-md-12">
                {{-- main content start --}}
                <div class="card std__form">
                    <div class="card-header py-3 ">
                        <h2 class="mx-0 text-center">Online Applicant Info Show</h2>
                    </div>

                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                            </div>
                        @endif
                        
                        <form action="{{ route('online-admission.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="py-2 mb-0 form__head">
                                Academic information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="session">Session <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="session" id="session"
                                                value="{{ $item->session }}" placeholder="Enter Session" readonly>
                                        </div>
                                    </div>
                                    
                                    @if($branches->count() > 1)
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="branch_id">Branch <span class="text-danger">*</span></label>
                                                {{ generateDropdown($branches, 'class="form-control branch_id" id="branch_id" name="branch_id" required', $item->branch_id ) }}
                                            </div>
                                        </div>
                                    @else
                                        @php
                                            $branchId = $branches->keys()->first();
                                        @endphp
                                        <input type="hidden" name="branch_id" value="{{ $branchId }}">
                                    @endif

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="student_class_id">Class <span class="text-danger">*</span> </label>
                                            {{ generateDropdown($studentClasses, 'class="form-control select2 student_class" id="student_class" name="student_class_id" required', $item->student_class_id, 'Select Option') }}
                                        </div>
                                    </div>

 
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Personal information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-9">
                                        <div class="row">
                                            
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="first_name">Name <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="first_name" id="first_name"
                                                        value="{{ $item->first_name }}" placeholder="Enter First Name" required>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="gender">Gender <span class="text-danger">*</span> </label>
                                                    {{ generateDropdown($genderOptions, 'class="form-control" name="gender" required', $item->gender, 'Select Option') }}
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="blood_group">Blood group </label>
                                                    {{ generateDropdown($bloodGroupOptions, 'class="form-control" name="blood_group"', $item->blood_group, 'Select Option') }}
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="religion">Religion <span class="text-danger">*</span> </label>
                                                    {{ generateDropdown($religionOptions, 'class="form-control" name="religion" required', $item->religion ) }}
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="date_of_birth">Date of birth <span class="text-danger">*</span> </label>
                                                    <input type="date" class="form-control date360" name="date_of_birth"
                                                        value="{{ $item->date_of_birth  }}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="birth_certi_no">Birth certificate no </label>
                                                    <input type="number" class="form-control" name="birth_certi_no"
                                                        value="{{ $item->birth_certi_no  }}" placeholder="Enter Birth Certificate No">
                                                </div>
                                            </div>


                                            
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="mobile_no"><b>Mobile number (for SMS)</b> <span class="text-danger">*</span>
                                                    </label>
                                                    <input type="tel" class="form-control" name="mobile_no" value="{{ $item->mobile_no }}"
                                                        placeholder="Enter Mobile Number" required>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="email">Email </label>
                                                    <input type="email" class="form-control" name="email" value="{{ $item->email }}"
                                                        placeholder="Enter Email">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="image-uploader">
                                            <label for="image">Profile Image </label>
                                            <label for="imageFile" class="image-uploader__label">
                                                <!-- Icon overlay with transparent background -->
                                                <div class="image-uploader__icon-overlay">
                                                    <i class="fas fa-cloud-upload-alt"></i>
                                                </div>
                                                <!-- Preview image -->
                                                <img src="{{ asset( $item->profile_image ?? '/default/profile.png') }}" alt="Preview image"
                                                    class="image-uploader__preview-image img-thumbnail rounded-circle p-1"
                                                    style="width: 140px; height: 140px;">
                                                <!-- File input -->
                                                <input type="file" name="profile_image" class="image-uploader__input" id="imageFile"
                                                    accept="image/*">
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Parent information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="father_name">Father's name <span class="text-danger">*</span> </label>
                                            <input type="text" class="form-control" name="father_name"
                                                value="{{ $item->father_name }}" placeholder="Enter Father Name" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="father_occupation">Father's occupation </label>
                                            {{ generateDropdown($occupations, 'class="form-control select2 father_occupation" id="father_occupation" name="father_occupation"', $item->father_occupation, 'Select Option') }}
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="father_mobile">Father mobile </label>
                                            <input type="tel" class="form-control" name="father_mobile"
                                                value="{{ $item->father_mobile }}" placeholder="Enter Father Mobile">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="mother_name">Mother name </label>
                                            <input type="text" class="form-control" name="mother_name"
                                                value="{{ $item->mother_name }}" placeholder="Enter Mother Name">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="mother_occupation">Mother occupation </label>
                                            {{ generateDropdown($occupations, 'class="form-control select2" name="mother_occupation"', $item->mother_occupation, 'Select Option') }}
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="mother_mobile">Mother mobile </label>
                                            <input type="tel" class="form-control" name="mother_mobile"
                                                value="{{ $item->mother_mobile }}" placeholder="Enter Mother Mobile">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Address
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    {{-- Present Address Start --}}
                                    <label class="ml-2" for="present_address">Present address</label>
                                    <div class="row col-md-12 mt-2">
                                        <x-location-dropdown
                                            :selected-district="old('present_district_id')"
                                            :selected-upazila="old('present_upazila_id')"
                                            container-class=""
                                            group-class="form-group col-md-3"
                                            label-class="form-label"
                                            select-class="form-control select2"
                                            prefix="present"
                                        />

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="present_address" id="present_address"
                                                        placeholder="Enter Present Address">{{old('present_address')}}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    {{-- Present Address End --}}

                                    {{-- Permanent Address Start --}}
                                    <label class="ml-2 mt-4" for="permanent_address">Permanent address</label>
                                    <div class="mx-2 mt-4">
                                        (<input class="mx-2" type="checkbox" id="copyAddress"/>
                                        <label for="copyAddress"> Same as present address</label>)
                                    </div>

                                    <div class="row col-md-12 mt-2">
                                        <x-location-dropdown
            {{--                                :selected-division="old('permanent_division_id')"--}}
                                            :selected-district="old('permanent_district_id')"
                                            :selected-upazila="old('permanent_upazila_id')"
                                            :selected-union="old('permanent_union_id')"
                                            container-class=""
                                            group-class="form-group col-md-3"
                                            label-class="form-label"
                                            select-class="form-control select2"
                                            prefix="permanent"
                                        />
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="permanent_address" id="permanent_address"
                                                        placeholder="Enter Permanent Address">{{old('permanent_address')}}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    {{-- Permanent Address End --}}
                                </div>
                            </div>


                            <div class="py-2 mb-0 form__head">
                                Sibling information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="sibling_student_id_no">Sibling</label>
                                            <input type="number" class="form-control" name="sibling_student_id_no"
                                                value="{{ $item->sibling_student_id_no  }}" placeholder="Enter Student ID">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="py-2 mb-0 form__head">
                                Previous Institute Information
                            </div>
                            <div class="form__body">
                                <div class="row">
                                    <div class="col-md-9">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_name">Institute name</label>
                                                    <input type="text" class="form-control" name="previous_institute_name"
                                                        value="{{ $item->previous_institute_name }}" placeholder="Enter Institute Name">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_address">Institute address</label>
                                                    <input type="text" class="form-control" name="previous_institute_address"
                                                        value="{{ $item->previous_institute_address }}" placeholder="Enter Institute Address">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_tc_no">T.C. No.</label>
                                                    <input type="text" class="form-control" name="previous_institute_tc_no"
                                                        value="{{ $item->previous_institute_tc_no }}" placeholder="Enter T.C. No.">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="previous_institute_tc_date">T.C. Date</label>
                                                    <input type="date" class="form-control" name="previous_institute_tc_date"
                                                        value="{{ $item->previous_institute_tc_date }}" placeholder="Enter T.C. Date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group previous_institute_tc">
                                            <label for="previous_institute_tc">T.C.</label>
                                            <input name="previous_institute_tc" value="{{  $item->previous_institute_tc  }}" id="previous_institute_tc" type="file"
                                                class="dropify" data-default-file="{{ old('previous_institute_tc') }}"/>
                                            @error('previous_institute_tc')
                                            <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>  
                                </div>
                            </div>


                            
                            <div class="mt-3 flex justify-content-end">
                                <a href="{{ url()->previous() }}" type="button" class="btn btn-default mr-3">Back</a>
                            </div>
                        </form>
                    </div>
                </div>
                {{-- main content end --}}
            </div>
        </div>
    </div>
    <script>
        const input = document.querySelector('.image-uploader__input');
        const previewImage = document.querySelector('.image-uploader__preview-image');
        input.addEventListener('change', () => {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = (event) => {
                previewImage.src = event.target.result;
            };
            reader.readAsDataURL(file);
        });
    </script>
@endsection

@section('scripts')
<script>
    $(document).ready(function () {
    $('.dropify').dropify({
        messages: {
            'default': '<i class="fa fa-upload fa-2x mb-2 text-primary"></i><br>Drag and drop a file here or click',
            'replace': '<i class="fa fa-sync-alt fa-2x mb-2 text-warning"></i><br>Drag and drop or click to replace',
            'remove': 'Remove',
            'error': 'Ooops, something went wrong.'
        }
    });
});

</script>
@endsection