@extends('layouts.master')
@section('content')
<style>
    .admit-card-wrapper {
        max-width: 600px;
      margin: 30px auto;
      padding: 20px;
    }
    .admit-card-wrapper h2 {
      text-align: center;
      margin-bottom: 20px;
      text-transform: uppercase;
    }
    .admit-card-wrapper .info-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 20px;
        font-size: 18px;
        color: #000;
    }
    .info-label {
      font-weight: bold;
      margin-right: 5px;
    }
    .info-item {
      display: flex;
        border-bottom: 1px dotted #464646;
    }

    .signature-section {
      display: flex;
      justify-content: space-between;
      margin-top: 36px;
      align-items: center;
    }
    .signature-box {
      text-align: center;
      width: 200px;
    }
    .signature-img{
        height: 40px;
    }
    .signature-img img{
        height: 40px;
    }
    .signature-line {
      border-top: 1px solid #333;
    margin-bottom: 1px;
    margin-top: 1px;
    }

    .institute-name h3{
        font-size: 30px;
        font-weight: bold;
        margin-top: 14px;
        margin-bottom: 1px;
        font-family: sans-serif;
    }

    .admit-card-name  {
        text-align: center;
        margin-bottom: 24px;
        font-size: 24px;
        color: #000;
        text-transform: none;
    }

    .admit-card-name span{
        border: 2px solid #000;
        padding: 2px 8px;

    }
   
    .title,
    .institute-name,
    .institute-address,
    .exam-name{
        text-align: center;
        color: #000;
        text-transform: none;
    }
    .admin__bg{
        position: absolute;
        width: 100%;
        background-image: url(/default/admin_bg_4.png);
        height: 100%;
        background-size: contain;
        background-repeat: no-repeat;
        left: 0;
        right: 0;
        top: 0;
        bottom: 0;
    }
    /*.institute-info .title{*/
    /*    font-family: serif;*/
    /*}*/
</style>
    <div class="card">
        <div class="card-body card__head">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link {{ request()->input('tab') === 'search' || request()->input('tab') === null ? 'show active' : '' }}" data-toggle="tab" href="#search-tab">
                        Search By ID
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->input('tab') === 'filter' ? 'show active' : '' }}" data-toggle="tab" href="#filter-tab">
                        Search by Class
                    </a>
                </li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <div id="search-tab" class="tab-pane {{ request()->input('tab') === 'search' || request()->input('tab') === null ? 'show active' : '' }}"><br>
                    <form method="post" action="{{ route('admit-card.student.filter') }}" class="row">
                        @csrf
                        <input type="hidden" name="tab" value="search">

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="exam" class="form-control select2" id="exam" required>
                                <option value="">Exam</option>
                                @foreach ($exams as $exam)
                                    @if ($exam_id==$exam->id)
                                        <option value="{{$exam->id}}" selected>{{$exam->exam_name ." ". $exam->academic_year->year }}</option>
                                    @else
                                        <option  {{ $loop->first ? 'selected' : '' }} value="{{$exam->id}}">{{$exam->exam_name ." ". $exam->academic_year->year }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            @component('components.search_student', [
                                'student_name' => $student_name ?? '',
                                'student_id_no' => request()->student_id_no ?? '',
                                'required' => '',
                            ])
                            @endcomponent
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
                <div id="filter-tab" class="tab-pane fade {{ request()->input('tab') === 'filter' ? 'show active' : '' }}"><br>
                    <form method="post" action="{{ route('admit-card.student.filter') }}" class="row">
                        @csrf
                        <input type="hidden" name="tab" value="filter">

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="exam" class="form-control select2" id="exam" required>
                                <option value="">Exam</option>
                                @foreach ($exams as $exam)
                                    @if ($exam_id==$exam->id)
                                        <option value="{{$exam->id}}" selected>{{$exam->exam_name ." ". $exam->academic_year->year }}</option>
                                    @else
                                        <option  {{ $loop->first ? 'selected' : '' }} value="{{$exam->id}}">{{$exam->exam_name. " " .$exam->academic_year->year }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="shift" class="form-control select2 shift_id" id="shift_id" required>
                                <option value="">Shift</option>
                                @foreach ($shifts as $shift)
                                    <option value="{{ $shift->id }}" {{ $loop->first ? 'selected' : '' }}>
                                        {{ $shift->shift_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown($studentClasses, 'class="form-control student_class student_class_id select2" id="student_class" name="student_class" required', request()->input('student_class'), "Class") }}
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->input('section'), "Section") }}
                        </div>

                    <x-group-selector
    name="group"
    label=""
    labelText="Group"
    col="form-group col-lg-2 col-md-6 col-sm-6"
    :student_class_id="(int) request()->input('student_class')"
    :required="(int) request()->input('student_class') >= 11"
    :selected="old('group') ?? request()->input('group')"
/>


                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @if(isset($students) && !empty($students) && $students->count() > 0 )
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">Admit Card (Total Result: {{ count($students)}})</h6>
                <div class="m-0 float-right">
                    <a class="btn btn-secondary btn__export mr-1" href="#" data-toggle="tooltip"
                    @if(count($students) > 0)
                        onclick="prindAdmitCard()"
                    @else
                        onclick="return false;"
                    @endif title="Print" >
                        <i class="fas fa-print"></i>
                    </a>
                </div>
            </div>
                @php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : 'Jabalunnur Al-Jamiatul Islamia';
                    $principal_signature = get_setting_value(Settings::PRINCIPAL_SIGNATURE) ? get_setting_value(Settings::PRINCIPAL_SIGNATURE) : '';
                    $branch_info = get_branch_info();
                @endphp
            <div class="card-body table_content row" id="admit-card">
                @foreach ($students->sortBy('class_roll') as $key=>$student)
                    <div class="col-md-6 col-lg-6 items">
                        <section class="page-section">
                            <div class="container" >
                                <div class="admit-card-wrapper items position-relative">
                                    <div class="admin__bg"></div>
                                    <div class="institute-info">
                                        <h5 class="title" style="font-family: 'Amiri', 'Scheherazade', serif;font-size: 27px;margin-bottom: 0px;" dir="rtl">بِسْمِ اللهِ الرَّحْمٰنِ الرَّحِيْمِ                                        </h5>
                                        <div class="institute-name"><h3>{{ $institute_name }}</h3></div>
                                        <div class="institute-address">{{ $branch_info->address ?? 'N/A' }}</div>
                                    </div>
                                    <div class="exam-name"><p>{{ $selected_exam->exam_name ?? 'N/A' }}-{{ $selected_exam->academic_year->year ?? 'N/A' }}</p></div>
                                    <div class="admit-card-name"><span>Admit Card</span></div>
                                    <div class="student-info">
                                        <div class="info-row">
                                            <div class="info-item"><div class="info-label">Name:</div> {{ $student->name ?? 'N/A'}}</div>
                                            <div class="info-item"><div class="info-label">Roll:</div> {{ $student->class_roll ?? 'N/A'}}</div>
                                          </div>

                                          <div class="info-row">
                                            <div class="info-item"><div class="info-label">Class:</div> {{ $student->studentClass->class_name ?? 'N/A'}}</div>
                                            <div class="info-item"><div class="info-label">ID No:</div> {{ $student->student_id_no ?? 'N/A'}}</div>
                                          </div>
                                    </div>

                                    <div class="signature-section">
                                        <div class="signature-box">
                                            <div class="signature-img">
                                            </div>
                                            <div class="signature-line"></div>
                                            <div>Class Teacher</div>
                                        </div>
                                        <div class="signature-box">
                                            <div class="signature-img">
                                                @if(!empty($principal_signature))
                                                    <img src="{{ asset($principal_signature) }}" alt="Principal Signature" >
                                                @endif
                                            </div>
                                            <div class="signature-line">
                                                
                                            </div>

                                            <div>Headmaster/Incharge</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>
                @endforeach
            </div>
        </div>
    @endif
@endsection

@section('scripts')
<script>
    function prindAdmitCard() {
    let content = document.getElementById('admit-card').innerHTML;
    let printWindow = window.open('', '', 'height=900,width=1100');
    printWindow.document.write(`
        <html>
            <head>
                <style>

                    @media print {

                         #admit-card {
                            column-count: 2;
                            column-gap: 30px;
                        }
                         .admit-card-wrapper {
                            max-width: 600px;
                            margin: 30px auto;
                            padding: 10px 20px 15px ;
                        }
                        .page-section {
                            break-inside: avoid;
                            page-break-inside: avoid;
                            margin-top: 0 !important;
                            margin-bottom: 0 !important;
                        }

                        @page {
                            size: A4 portrait;
                            margin: 20mm;
                        }
                    }
                    .position-relative{
                        position:relative;
                    }
                    .admit-card-wrapper h2 {
                    text-align: center;
                    margin-bottom: 20px;
                    text-transform: uppercase;
                    }
                    .admit-card-wrapper .info-row {
                        display: flex;
                        justify-content: space-between;
                        margin-bottom: 20px;
                        font-size: 18px;
                        color: #000;
                    }
                    .info-label {
                    font-weight: bold;
                        margin-right: 5px;
                    }
                    .info-item {
                        display: flex;
                        border-bottom: 1px dotted #464646;
                    }

                    .signature-section {
                        display: flex;
                        justify-content: space-between;
                        margin-top: 36px;
                        align-items: center;
                    }
                    
                    .signature-box {
                        text-align: center;
                        width: 200px;
                    }
                    .signature-img{
        height: 40px;
    }
    .signature-img img{
        height: 40px;
    }
    .signature-line {
      border-top: 1px solid #333;
    margin-bottom: 1px;
    margin-top: 1px;
    }
    
                    .institute-name h3{
                        font-size: 30px;
                        font-weight: bold;
                        margin-top: 14px;
                        margin-bottom: 1px;
                        font-family: sans-serif;
                    }

                    .admit-card-name  {
                        text-align: center;
                        margin-bottom: 24px;
                        font-size: 24px;
                        color: #000;
                        text-transform: none;
                    }

                    .admit-card-name span{
                        border: 2px solid #000;
                        padding: 2px 8px;

                    }
                    .title,
                    .institute-name,
                    .institute-address,
                    .exam-name{
                        text-align: center;
                        color: #000;
                        text-transform: none;
                    }
                    .admin__bg{
                        position: absolute;
                        width: 100%;
                        background-image: url(/default/admin_bg_4.png);
                        height: 100%;
                        background-size: contain;
                        background-repeat: no-repeat;
                        left: 0;
                        right: 0;
                        top: 0;
                        bottom: 0;
                    }
                    .institute-info .title{
                        font-family: serif;
                    }
                </style>
            </head>
            <body>
                ${content}
            </body>
        </html>
    `);
    printWindow.document.close();
    printWindow.focus();

    setTimeout(() => {
        printWindow.print();
        printWindow.close();
    }, 500);  // Increased timeout for smoother operation
}
</script>
@endsection
