@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">API Key List</h6>
        <div class="m-0 float-right">
            @can('academic.branches.create')
                <button class="btn btn-sm btn-primary" id="add-student-btn"
                data-toggle="modal" data-target="#dataStoreModal">Add New</button>
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>API Token</th>
                                <th>URL</th>
                                <th class="action__col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($apiToken->isNotEmpty())
                            @php $sn=0; @endphp
                            @foreach ($apiToken as $item)
                                <tr>
                                    <td>{{ ++$sn }}</td>
                                    <td style="position: relative;">
                                        <span title="Copy API Token" class="copy-icon" onclick="copyText(this)">
                                            <i class="fas fa-copy" style="cursor: pointer;"></i>
                                        </span>
                                        <span class="copy-text d-none" style="word-break: break-all;">{{ $item->api_token }}</span>
                                        <span >{{$item->api_name}}</span>
                                    </td>

                                    <td class="text-break">{{ $item->api_token }}</td>
                                    <td class="text-break">{{ url('/').'/api/v1/student?student_id=EnterStudentID&api_token='.$item->api_token }}</td>
                                    <td class="d-flex justify-content-start">
                                        <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn" data-toggle="modal"
                                                data-target="#dataEditModal" data-name="{{ $item->name }}"
                                                data-api_name="{{ $item->api_name }}" data-id="{{ $item->id }}"><i class="fas fa-edit"></i></button>
                                        <form action="{{ route('apikey.destroy', $item->id) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-soft-danger btn-sm"
                                                onclick="return confirm('Are you sure you want to delete this Key?')"><i class="fas fa-trash"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                            @else
                            <tr><td colspan="5" class="text-center">No data available in table</td></tr>
                            @endif
                        </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('apikey.store') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add API Key </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="name">Name *</label>
                            <input type="text" class="form-control" id="name" name="name"
                                placeholder="Enter Name" required>
                        </div>
                        <div class="form-group">
                            <label for="api_name">API Name *</label>
                            <input type="text" class="form-control" id="api_name" name="api_name"
                                placeholder="Enter API Name" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary submitBtn">Add New</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('apikey.update') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit API Key </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="name">Name *</label>
                            <input type="text" class="form-control" id="name" name="name"
                                placeholder="Enter Branch Name" required>
                        </div>
                        <div class="form-group">
                            <label for="api_name">API Name *</label>
                            <input type="text" class="form-control" id="api_name" name="api_name"
                                placeholder="Enter API Name" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary submitBtn">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->


<script>
    function copyText(element) {
        var textElement = element.nextElementSibling; // Get the sibling span containing text
        var text = textElement.innerText.trim(); // Get the trimmed text
        // Create a temporary textarea to copy the text
        var textarea = document.createElement('textarea');
        textarea.value = text;
        document.body.appendChild(textarea);

        // Select and copy the text
        textarea.select();
        document.execCommand('copy');

        // Clean up - remove the textarea
        document.body.removeChild(textarea);

        // Show the checked icon briefly for visual feedback
        var copyIcon = element.querySelector('i'); // Get the copy icon
        copyIcon.classList.remove('fa-copy'); // Remove copy icon class
        copyIcon.classList.add('fa-check-circle'); // Add checked icon class
        copyIcon.style.color = 'green'; // Set checked icon color

        // Reset to copy icon after 1.5 seconds
        setTimeout(function() {
            copyIcon.classList.remove('fa-check-circle'); // Remove checked icon class
            copyIcon.classList.add('fa-copy'); // Add copy icon class back
            copyIcon.style.color = ''; // Reset icon color
        }, 1500);
    }
</script>

@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var api_name = button.data('api_name')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#name').val(name)
            modal.find('#api_name').val(api_name)
            modal.find('#id').val(id)
        })
    </script>
@endsection
