@extends('layouts.master')
@php
    $padding_y = isset($template?->padding_y) ? $template?->padding_y : 20;
    $padding_x = isset($template?->padding_x) ? $template?->padding_x : 20;
@endphp
@push('styles')
    <style>
        #certificate-preview {
            border: 1px solid #fae8e8; /* Optional for visibility */
            position: relative;
            overflow: hidden;
            width: 100%; /* Set to desired width */
            height: auto; /* Allow height to adjust based on content */
            aspect-ratio: 16 / 11; /* Adjust as necessary for your layout */
            padding: {{ $padding_y }}px {{ $padding_x }}px; /* Apply padding */
        }
        
        #certificate-background {
            width: 100%; /* Full width for the image */
            height: auto; /* Maintain aspect ratio */
            position: absolute; /* Positioning for background */
            left: 0;
            top: 0;
            z-index: 0; /* Send to back */
        }

        #certificate-content {
            position: relative; /* Ensure content is above the background */
            z-index: 1; /* Ensure content appears above the image */
        }

        @media print {
            body * {
                visibility: hidden; /* Hide everything */
            }
            #certificate-preview {
                border: 1px solid #fae8e8; /* Optional for visibility */
                position: relative;
                overflow: hidden;
                width: 100%; /* Set to desired width */
                height: auto; /* Allow height to adjust based on content */
/*                aspect-ratio: 16 / 11;  Adjust as necessary for your layout */
                padding: 0px 20px 20px;
                margin-bottom: 20px !important;
            }
            #certificate-preview, #certificate-preview * {
                visibility: visible; /* Show only the preview */
            }
            #certificate-preview {
                position: absolute; /* Remove from normal flow */
                left: 0;
                top: 0;
                width: 100%; /* Full width */
                height: auto; /* Adjust height dynamically */
            }
            @page {
                size: landscape; /* Set print orientation to landscape */
                margin: 0; /* Remove default margins */
            }
        }
    </style>
@endpush

@section('content')
<div class="card">
    <div class="card-body card__head">
        <form method="GET" action="{{ route('student-certificate.create') }}" class="row">
            <div class="form-group col-md-4">
                @component('components.search_student', ['student_name' => $student_name ?? '', 'student_id_no' => request()->query('student_id_no') ?? ''])
                @endcomponent
            </div>
            <div class="form-group col-md-4">
                {{ generateDropdown($certificateTemplates, 'class="form-control certificate_template_id" id="certificate_template_id" name="certificate_template_id"', request()->query('certificate_template_id'), "Select Template") }}
            </div>
            <div class="form-group col-md-4">
                <button type="submit" class="btn btn-info ">Search</button>
            </div>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Certificate Preview</h6>
        <div class="m-0 float-right">
            <a href="{{ route('certificate-templates.index') }}" class="btn btn-sm btn-primary">Certificate Templates</a>
            <button class="btn btn-sm btn-primary" onclick="printCertificate()">Print Certificate</button>
        </div>
    </div>

    <div class="card-body">
        <form action="{{route('student-certificate.store')}}" method="POST">
            @csrf
            @if ($studentCertificate)
                @php
                    $imagePath = asset($template->background_image);
                @endphp
                <input type="hidden" name="student_id" value="{{$student->id ?? ''}}">
                <input type="hidden" name="class_id" value="{{$student->student_class_id ?? ''}}">
                <input type="hidden" name="shift_id" value="{{$student->shift_id ?? ''}}">
                <input type="hidden" name="shift_id" value="{{$student->shift_id ?? ''}}">
                <input type="hidden" name="certificate_template_id" value="{{ request()->certificate_template_id ?? ''}}">
                <div class="mt-4">
                    <div id="certificate-preview">
                        <img id="certificate-background" src="{{ $imagePath }}" alt="Certificate Background">
                        <div id="certificate-content"> <!-- Ensure text is above image -->
                            <div>{!! $studentCertificate !!}</div>
                        </div>
                    </div>
                </div>
                <div class="flex d-flex justify-content-end mt-3">
                    <button type="submit" class="btn btn-sm btn-info">Save</button>
                </div>
            @endif
        </form>
    </div>
</div>

@endsection

@section('scripts')
<script>
    function printCertificate() {
        window.print();
    }
</script>
@endsection
