@extends('layouts.master')

@section('content')
<div class="card" id="app">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Create Certificate Template</h6>
        <div class="m-0 float-right">
        <a href="{{ route('student-certificate.create') }}" class="btn btn-sm btn-primary">Create New Template</a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <div class="card-body">
        <table class="table" id="dataTable">
            <thead>
                <tr>
                    <th>Student ID</th>
                    <th>Student Name</th>
                    {{-- <th>Shift</th>
                    <th>Class</th>
                    <th>Section</th> --}}
                    <th>Certificate Template</th>
                    <th>Assigned By</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
             
                {{-- @if ($studentCertificates->isNotEmpty()) --}}
                    @foreach ($studentCertificates as $studentCertificate)
                        <tr>

                            <td>{{ $studentCertificate->student->student_id_no }}</td>
                            <td>{{ "{$studentCertificate->student->first_name} {$studentCertificate->student->last_name}" }}</td>
                            <td>{{ $studentCertificate->certificateTemplate->title }}</td>
                            <td>{{ $studentCertificate->assignedBy->name }}</td>
                            <td>
                                <a href="{{ route('student-certificate.show', $studentCertificate) }}" class="btn btn-sm btn-info">View</a>
                                <a href="{{ route('student-certificate.edit', $studentCertificate) }}" class="btn btn-sm btn-warning">Edit</a>
                                <form action="{{ route('student-certificate.destroy', $studentCertificate) }}" method="POST"
                                    style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                {{-- @else
                    <tr>
                        <td rowspan="3">There is no data...</td>
                    </tr>
                @endif --}}
            </tbody>
        </table>
    </div>

</div>
@endsection
