@extends('layouts.master')
@push('styles')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.css" rel="stylesheet">
    <style>
        #certificate-preview {
            border: 1px solid #000; /* Optional for visibility */
            position: relative;
            overflow: hidden;
            width: 100%; /* Set to desired width */
            height: auto; /* Allow height to adjust based on content */
            aspect-ratio: 16 / 11; /* Adjust as necessary for your layout */
            background-size: contain; /* Change to contain */
            background-repeat: no-repeat; /* Prevent repeating the background */
            background-position: center; /* Center the background image */
        }
    </style>
@endpush
@section('content')
<div class="card" id="app">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Create Certificate Template</h6>
        <div class="m-0 float-right">
            <a href="{{ route('certificate-templates.index') }}" class="btn btn-sm btn-primary" id="add-student-btn">Certificate Templates</a>
        </div>
    </div>

    <div class="card-body">
        <form action="{{ route('certificate-templates.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="title">Title:</label>
                <input type="text" class="form-control" id="title" name="title" placeholder="Enter a certificate template title" required>
            </div>
            <div class="form-group">
                <label for="body">Body:</label>
                <textarea class="form-control" id="body" name="body" rows="10" required></textarea>
            </div>

            <p class="p-2" style="padding: 10px; border: 1px solid #744449;">
                <span style="font-weight: bold; color:red;">Note:</span> 
                Use the below variables in your template exactly as shown. They will dynamically replace with the corresponding values when creating the certificate: 
                [School_Logo], [School_Name], [Branch_Name], [Student_Name], [Student_Class], 
                [Student_Section], [Student_Shift], [Student_Roll], [Principal_Signature]
            </p>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="background">Background Image: <span class="text-danger">Ratio 2480 x 3508</span></label>
                        <input type="file" class="form-control" id="background" name="background_image" accept="image/*" @change="previewImage" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="padding_x">Padding X (Horizontal):</label>
                        <input type="number" class="form-control" id="padding_x" name="padding_x" v-model="padding_x" @input="updatePadding">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="padding_y">Padding Y (Vertical):</label>
                        <input type="number" class="form-control" id="padding_y" name="padding_y" v-model="padding_y" @input="updatePadding">
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <h4>Live Preview</h4>
                <div class="mt-4">
                    <div id="certificate-preview" class="border" :style="`background-image: url(${imagePreview}); padding: ${padding_y}px ${padding_x}px;`">
                        <div v-html="bodyContent"></div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label for="status">Status:</label>
                <select class="form-control" id="status" name="status">
                    <option value="{{ Status::ACTIVE }}">Active</option>
                    <option value="{{ Status::INACTIVE }}">Inactive</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Create Template</button>
        </form>
    </div>
</div>

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.js"></script>
<script>
    const app = Vue.createApp({
        data() {
            return {
                title: '',
                bodyContent: '',
                imagePreview: '',
                padding_x: 20, // Default horizontal padding
                padding_y: 20  // Default vertical padding
            };
        },
        mounted() {
            $('#body').summernote({
                height: 200,
                callbacks: {
                    onChange: (contents) => {
                        this.bodyContent = contents;
                    }
                },
            });

            $('#title').on('input', (e) => {
                this.title = e.target.value;
            });
        },
        methods: {
            previewImage(event) {
                const file = event.target.files[0];
                if (file && file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = (e) => {
                        this.imagePreview = e.target.result;
                    };
                    reader.readAsDataURL(file);
                } else {
                    alert('Please upload a valid image file.');
                }
            },
            updatePadding() {
                // No need for additional logic unless needed
            }
        }
    });

    app.mount('#app');
</script>
@endsection
@endsection
