@extends('layouts.master')
@push('styles')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.css" rel="stylesheet">
    <style>
        #certificate-preview {
            border: 1px solid #000;
            position: relative;
            overflow: hidden;
            width: 100%;
            height: auto;
            aspect-ratio: 16 / 11;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
        }
    </style>
@endpush

@section('content')
<div class="card" id="app">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Edit Certificate Template</h6>
        <div class="m-0 float-right">
            <a href="{{ route('certificate-templates.index') }}" class="btn btn-sm btn-primary" id="add-student-btn">Certificate Templates</a>
        </div>
    </div>

    <div class="card-body">
        <form action="{{ route('certificate-templates.update', $certificateTemplate->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="title">Title:</label>
                <input type="text" class="form-control" id="title" name="title" v-model="title" placeholder="Enter certificate template title" required>
            </div>
            
            <div class="form-group">
                <label for="body">Body:</label>
                <textarea class="form-control" id="body" name="body" rows="10" required>{{ htmlspecialchars_decode($certificateTemplate->body) }}</textarea>
            </div>

            <p class="p-2" style="border: 1px solid #744449;">
                <span style="font-weight: bold; color:red;">Note:</span> 
                Use the below variables in your template exactly as shown. They will dynamically replace with the corresponding values when creating the certificate: 
                [School_Logo], [School_Name], [Branch_Name], [Student_Name], [Student_Class], 
                [Student_Section], [Student_Shift], [Student_Roll], [Principal_Signature]
            </p>

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="background">Background Image: <span class="text-danger">Ratio 2480 x 3508</span></label>
                        <input type="file" class="form-control" id="background" name="background_image" accept="image/*" @change="previewImage">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="padding_x">Padding X (Horizontal):</label>
                        <input type="number" class="form-control" id="padding_x" name="padding_x" v-model="padding_x" @input="updatePadding" value="{{ $certificateTemplate->padding_x }}">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="padding_y">Padding Y (Vertical):</label>
                        <input type="number" class="form-control" id="padding_y" name="padding_y" v-model="padding_y" @input="updatePadding" value="{{ $certificateTemplate->padding_y }}">
                    </div>
                </div>
            </div>
    
            <!-- Live Preview Section -->
            <div class="table-responsive">
                <h4>Live Preview</h4>
                <div class="mt-4">
                    <div id="certificate-preview" class="border" :style="`background-image: url(${imagePreview}); padding: ${padding_y}px ${padding_x}px;`">
                        <div v-html="bodyContent"></div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="status">Status:</label>
                <select class="form-control" id="status" name="status">
                    <option value="active" {{ $certificateTemplate->status === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ $certificateTemplate->status === 'inactive' ? 'selected' : '' }}>Inactive</option>
                </select>
            </div>
            
            <button type="submit" class="btn btn-primary">Update Template</button>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.js"></script>
<script>
    const app = Vue.createApp({
        data() {
            return {
                title: '{{ $certificateTemplate->title }}',
                bodyContent: @json(htmlspecialchars_decode($certificateTemplate->body)),
                imagePreview: '{{ $certificateTemplate->background_image ? asset($certificateTemplate->background_image) : "" }}',
                padding_x: '{{ $certificateTemplate->padding_x }}',
                padding_y: '{{ $certificateTemplate->padding_y }}'
            };
        },
        mounted() {
            // Initialize Summernote after Vue has mounted
            $('#body').summernote({
                height: 200,
                callbacks: {
                    onChange: (contents) => {
                        this.bodyContent = contents;  // Update Vue's data with new content
                    }
                },
            });

            // Sync input fields with Vue data
            $('#title').on('input', (e) => {
                this.title = e.target.value;
            });
        },
        methods: {
            previewImage(event) {
                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = (e) => {
                        this.imagePreview = e.target.result;
                    };
                    reader.readAsDataURL(file);
                }
            },
            updatePadding() {
                // This method is called whenever padding values are changed
                // Additional logic can be added here if necessary
            }
        }
    });

    app.mount('#app');
</script>
@endsection
