@extends('layouts.master')

@section('content')
<div class="card" id="app">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Create Certificate Template</h6>
        <div class="m-0 float-right">
        <a href="{{ route('certificate-templates.create') }}" class="btn btn-sm btn-primary">Create New Template</a>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive" >
            <table class="table" id="dataTable">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Padding X</th>
                        <th>Padding Y</th>
                        <th>Status</th>
                        <th class="action__col">Action</th>
                    </tr>
                </thead>
                <tbody>
                 
                    {{-- @if ($templates->isNotEmpty()) --}}
                        @foreach ($templates as $template)
                            <tr>
                                <td>{{ $template->title }}</td>
                                <td>{{ $template->padding_x }}</td>
                                <td>{{ $template->padding_y }}</td>
                                <td>{!! getStatusBadge($template->status) !!}</td>
                                <td>
                                    <a href="{{ route('certificate-templates.show', $template) }}" class="btn btn-sm btn-soft-success"><i class="fas fa-eye"></i></a>
                                    <a href="{{ route('certificate-templates.edit', $template) }}" class="btn btn-sm btn-soft-info"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('certificate-templates.destroy', $template) }}" method="POST"
                                        style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    {{-- @else
                        <tr>
                            <td rowspan="3">There is no data...</td>
                        </tr>
                    @endif --}}
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
