@extends('layouts.master')

@push('styles')
    <style>
        #certificate-preview {
            border: 1px solid #fae8e8; /* Optional for visibility */
            position: relative;
            overflow: hidden;
            width: 100%; /* Set to desired width */
            height: auto; /* Allow height to adjust based on content */
            aspect-ratio: 16 / 11; /* Adjust as necessary for your layout */
            padding: {{ $certificateTemplate->padding_y }}px {{ $certificateTemplate->padding_x }}px; /* Apply padding */
        }
        
        #certificate-background {
            width: 100%; /* Full width for the image */
            height: auto; /* Maintain aspect ratio */
            position: absolute; /* Positioning for background */
            left: 0;
            top: 0;
            z-index: 0; /* Send to back */
        }

        #certificate-content {
            position: relative; /* Ensure content is above the background */
            z-index: 1; /* Ensure content appears above the image */
        }

        @media print {
            body * {
                visibility: hidden; /* Hide everything */
            }
            #certificate-preview, #certificate-preview * {
                visibility: visible; /* Show only the preview */
            }
            #certificate-preview {
                position: absolute; /* Remove from normal flow */
                left: 0;
                top: 0;
                width: 100%; /* Full width */
                height: auto; /* Adjust height dynamically */
            }
            @page {
                size: landscape; /* Set print orientation to landscape */
                margin: 0; /* Remove default margins */
            }
        }
    </style>
@endpush

@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Certificate Preview</h6>
        <div class="m-0 float-right">
            <a href="{{ route('certificate-templates.index') }}" class="btn btn-sm btn-primary">Certificate Templates</a>
            <button class="btn btn-sm btn-primary" onclick="printCertificate()">Print Certificate</button>
        </div>
    </div>

    <div class="card-body">
        @php
            $imagePath = asset($certificateTemplate->background_image);
        @endphp
        <div class="mt-4">
            <div id="certificate-preview">
                <img id="certificate-background" src="{{ $imagePath }}" alt="Certificate Background">
                <div id="certificate-content"> <!-- Ensure text is above image -->
                    <div>{!! htmlspecialchars_decode( $certificateTemplate->body) !!}</div>
                </div>
            </div>
        </div>
      
    </div>
</div>
@endsection

@section('scripts')
<script>
    function printCertificate() {
        window.print();
    }
</script>
@endsection
