@extends('layouts.master')
@section('styles')
<style>
/* Style for events' background color in calendar cells */
.fc-daygrid-day {
    position: relative;
}

.fc-daygrid-day[data-date] {
    position: relative;
}

.fc-daygrid-day[data-date] {
    z-index: 1; /* Ensure background stays below event text */
}

/* Style the events in FullCalendar */
.fc-daygrid-event {
    white-space: nowrap;  /* Prevent text from wrapping */
    overflow: hidden;     /* Hide overflow if text exceeds the event box */
    text-overflow: ellipsis; /* Show ellipsis ("...") if the text overflows */
    padding: 2px 5px;     /* Adjust padding to ensure better fit */
}

/* Optional: Control the height of the event */
.fc-daygrid-event-title {
    font-size: 12px;   /* Adjust font size as necessary */
    line-height: 1.2;  /* Ensure proper spacing between lines */
}

/* Optional: Style for the background */
.fc-daygrid-event {
    background-color: #FF5733; /* Background color for the event */
    color: white;              /* Text color for the event */
}


/* Custom event title */
.custom-event-title {
    white-space: nowrap;  /* Prevent text from wrapping */
    overflow: hidden;     /* Hide overflow if text exceeds the event box */
    text-overflow: ellipsis; /* Show ellipsis ("...") if the text overflows */
    padding: 2px 5px;     /* Adjust padding to ensure better fit */
    font-size: 12px;      /* Adjust font size */
}


</style>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">

            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Holiday List</h6>
                    <a href="{{ route('holiday.create') }}" class="btn btn-sm btn-primary">Add New</a>
                </div>
                <div class="table-responsive p-3" >
                    <div id='calendar'></div>
                </div>
            </div>
        </div>
</div>
@stop
@section('scripts')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.7/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.7/index.global.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');
    
    // Embed holidays data into JavaScript
    var holidays = @json($holidays);

    // Function to generate an array of dates between start_date and end_date
    function generateDatesBetween(startDate, endDate) {
        var dates = [];
        var currentDate = moment(startDate);
        var endMoment = moment(endDate);

        while (currentDate.isBefore(endMoment) || currentDate.isSame(endMoment, 'day')) {
            dates.push(currentDate.format("YYYY-MM-DD"));
            currentDate.add(1, 'days');
        }

        return dates;
    }

    // Format events
    var formattedEvents = holidays.flatMap(holiday => {
        // Generate all dates between start_date and end_date
        var dates = generateDatesBetween(holiday.start_date, holiday.end_date);

        return dates.map(date => ({
            id: holiday.id,
            title: holiday.title,
            start: date,  // Single day for each iteration
            end: date,    // Single day for each iteration
            backgroundColor:  '#f7c80c', // Set background color
            borderColor: '#f7c80c', // Optional: Customize the border color
        }));
    });

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        editable: false, // Disables drag-and-drop and resizing
        events: formattedEvents, // Load events
        eventClick: false, // Disable event clicking

        // Apply background color to <td> elements between start_date and end_date
        datesSet: function(info) {
            holidays.forEach(holiday => {
                // Get the dates between start and end for the holiday
                var dates = generateDatesBetween(holiday.start_date, holiday.end_date);

                // Apply background color to <td> for each date in the range
                dates.forEach(date => {
                    var dateCell = document.querySelector(`[data-date="${date}"]`);
                    if (dateCell) {
                        dateCell.style.backgroundColor = '#b2be25'; // Set background color
                    }
                });
            });
        }
    });

    calendar.render();
});



//     document.addEventListener('DOMContentLoaded', function() {
//     var calendarEl = document.getElementById('calendar');
    
//     // Embed holidays data into JavaScript
//     var holidays = @json($holidays);
    
//     // Function to generate an array of dates between start_date and end_date
//     function generateDatesBetween(startDate, endDate) {
//         var dates = [];
//         var currentDate = moment(startDate);
//         var endMoment = moment(endDate);

//         while (currentDate.isBefore(endMoment) || currentDate.isSame(endMoment, 'day')) {
//             dates.push(currentDate.format("YYYY-MM-DD"));
//             currentDate.add(1, 'days');
//         }

//         return dates;
//     }

//     // Format events
//     var formattedEvents = holidays.flatMap(holiday => {
//         // Generate all dates between start_date and end_date
//         var dates = generateDatesBetween(holiday.start_date, holiday.end_date);

//         return dates.map(date => ({
//             id: holiday.id,
//             title: holiday.title,
//             start: date,  // Single day for each iteration
//             end: date,    // Single day for each iteration
//             backgroundColor: holiday.background_color || '#FF5733', // Set background color
//             borderColor: holiday.border_color || '#FF5733', // Optional: Customize the border color
//         }));
//     });

//     var calendar = new FullCalendar.Calendar(calendarEl, {
//         initialView: 'dayGridMonth',
//         editable: false, // Disables drag-and-drop and resizing
//         events: formattedEvents, // Load events
//         eventClick: false, // Disable event clicking
//     });

//     calendar.render();
// });




// document.addEventListener('DOMContentLoaded', function() {
//     var calendarEl = document.getElementById('calendar');
//     // Embed holidays data into JavaScript
//     var holidays = @json($holidays);
//     var formattedEvents = holidays.map(holiday => ({
//         id: holiday.id, // Optional for backend integration
//         title: holiday.title,
//         start: holiday.start_date,
//         // end: holiday.end_date,
//         end: moment(holiday.end_date, "YYYY-MM-DD").add(1, 'days').format("YYYY-MM-DD"), // Add one day
//     }));
//     var calendar = new FullCalendar.Calendar(calendarEl, {
//         initialView: 'dayGridMonth',
//         editable: false, // Disables drag-and-drop and resizing
//         events: formattedEvents, // Load events
//         eventClick: false, // Disable event clicking
//     });
//     calendar.render();
// });
</script>
@endsection
