@extends('layouts.master')
@section('styles')
<style>
	.lesson_input{
		width: 88%;
    	display: inline-block;
	}
    .yearselect{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card mt-4">
			<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
		        <h6 class="m-0 table__top__txt">Copy Holiday </h6>
		    </div>
            <div class="card-body">
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="list-group list-unstyled">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
	            <form action="{{ route('holiday.copy.store',$original->id) }}" method="POST" enctype="multipart/form-data">
	                @csrf
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="year">Year <span class="text-danger">*</span></label>
                                <input type="number" name="year" value="{{ $year }}" readonly id="year" class="form-control form-control-sm" required placeholder="YYYY">
                            </div> 
                        </div>
                    </div>
                    <div class="row">
                        @if(!empty($holidays))
                        @foreach($holidays as $key=>$holiday)
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="title">Holiday Subject <span class="text-danger">*</span></label>
                                <input type="text" name="title[]" value="{{$holiday->title}}" class="form-control form-control-sm" required>
                            </div> 
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="holiday_type">Holiday Type <span class="text-danger">*</span></label>
                                <select class="form-control form-control-sm" name="holiday_type[]">
                                    <option value="">--Select Holiday Type--</option>
                                    @if(!empty($holiday->holiday_type))
                                    <option selected value="{{$holiday->holiday_type}}">{{$holiday->holiday_type}}</option>
                                    @endif
                                    <option value="Public">Public</option>
                                    <option value="Special">Special </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="start_date">Start Date <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-sm start-date-range" name="start_date[]" value="{{ date('d-m', strtotime($holiday->start_date)) }}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="end_date">End Date</label>
                                <input type="text" class="form-control form-control-sm lesson_input end-date-range" name="end_date[]" value="{{ date('d-m', strtotime($holiday->end_date)) }}">
                                @if($key === 0)
                                <span id="plusBtn" title="Add More" class="text-success cursor-pointer"><i class="fas fa-plus-square"></i></span>
                                @else
                                <span class="text-danger cursor-pointer removeBtn pl-1" title="Remove This"><i class="fas fa-minus-square"></i></span>
                                @endif
                            </div>
                        </div>

                        @endforeach
                        @endif
                    </div>
                    <div id="append-content"></div>
	                <div class="row mt-3 flex justify-content-end">
	                    <button type="submit" class="btn btn-primary">Submit</button>
	                </div>
	            </form>
	        </div>
		</div>
	</div>
</div>
@stop
@section('scripts')
<script>
    $(document).ready(function () {
        const today = new Date();
        const nextWeek = new Date(today);
        const year = today.getFullYear();
        nextWeek.setDate(today.getDate() + 7);

        $("#year").datepicker({
            format: "yyyy",
            viewMode: "years", 
            minViewMode: "years"
        });

        $(document).ready(function () {
            // Initialize datepickers for all dynamically generated fields
            $('input[name="start_date[]"]').datepicker({
                format: "dd-mm",
                autoclose: true,
                todayHighlight: true,
                startView: 0, // Show days only
            });

            $('input[name="end_date[]"]').datepicker({
                format: "dd-mm",
                autoclose: true,
                todayHighlight: true,
                startView: 0, // Show days only
            });
        });


    });

    $(document).ready(function () {
        const today = new Date().toISOString().split('T')[0];
        $("input[name='date[]']").attr('min', today);
        let uuid = 0;
        $("#plusBtn").click(function (ele) {
            ele.preventDefault();
            uuid++;
            $("#append-content").append('<div class="container_label"><div class="row"><div class="col-md-3"><div class="form-group"><label for="title">Holiday Subject <span class="text-danger">*</span></label><input type="text" name="title[]" class="form-control form-control-sm" required></div></div><div class="col-md-3"><div class="form-group"><label for="holiday_type">Holiday Type <span class="text-danger">*</span></label><select class="form-control form-control-sm" name="holiday_type[]"><option value="">--Select Holiday Type--</option><option value="Public">Public</option><option value="Special">Special </option></select></div></div><div class="col-md-3"><div class="form-group"><label for="start_date">Start Date <span class="text-danger">*</span></label><br><input type="text" class="form-control form-control-sm start-date-range-'+uuid+'" name="start_date[]" required></div></div> <div class="col-md-3"><div class="form-group"><label for="end_date">End Date</label><br><input type="text" class="form-control form-control-sm lesson_input end-date-range-'+uuid+'" name="end_date[]"><span class="text-danger cursor-pointer removeBtn pl-1" title="Remove This"><i class="fas fa-minus-square"></i></span></div></div></div>')

                $('.start-date-range-'+uuid).datepicker({
                    format: "dd-mm",
                    autoclose: true,
                    todayHighlight: true,
                    startView: 0, // Show days only
                })
                $('.end-date-range-'+uuid).datepicker({
                    format: "dd-mm",
                    autoclose: true,
                    todayHighlight: true,
                    startView: 0, // Show days only
                })
        })
        $(document).on('click', '.removeBtn', function () {
            $(this).closest('.container_label').remove();
        });
    });


</script>
@endsection
