@extends('layouts.master')
@section('styles')
<style>
	.lesson_input{
		width: 88%;
    	display: inline-block;
	}
    .yearselect{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card mt-4">
			<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
		        <h6 class="m-0 table__top__txt">Add Academic Calendar</h6>
		    </div>
            <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="list-group list-unstyled">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

	            <form action="{{ route('holiday.store') }}" method="POST" enctype="multipart/form-data">
	                @csrf
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="year">Year <span class="text-danger">*</span></label>
                                <input type="text" name="year" id="year" class="form-control form-control-sm" required placeholder="YYYY" min="2024" max="2124">
                            </div> 
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="title">Event Title <span class="text-danger">*</span></label>
                                <input type="text" name="title[]" class="form-control form-control-sm" required>
                            </div> 
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="holiday_type">Event Type <span class="text-danger">*</span></label>
                                <select class="form-control form-control-sm" name="holiday_type[]">
                                    <option value="">--Select Event Type--</option>
                                    <option value="Public">Public</option>
                                    <option value="Special">Special </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="start_date">Start Date <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-sm start-date-range" name="start_date[]" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="end_date">End Date </label>
                                <input type="text" class="form-control form-control-sm lesson_input end-date-range" name="end_date[]">
                                <span id="plusBtn" title="Add More" class="text-success cursor-pointer"><i class="fas fa-plus-square"></i></span>
                            </div>
                        </div>
                    </div>
                    <div id="append-content"></div>
	                <div class="row mt-3 flex justify-content-end">
	                    <button type="submit" class="btn btn-primary">Submit</button>
	                </div>
	            </form>
	        </div>
		</div>
	</div>
</div>
@stop
@section('scripts')
<script>

    $(document).ready(function () {
        const today = new Date();
        const nextWeek = new Date(today);
        const year = today.getFullYear();
        nextWeek.setDate(today.getDate() + 7);

        $("#year").datepicker({
            format: "yyyy",
            viewMode: "years", 
            minViewMode: "years"
        }).datepicker('setDate', today);
    });

   
    // $('.date-range').daterangepicker({
    //   "singleDatePicker": true,
    //   "locale":{
    //     "format": "DD/MM",
    //   },
    //   startDate: '01/01',
    //   endDate: '31/12',
    //   minDate: '01/01',
    //   maxDate: '31/12',
    //   showDropdowns: true
    // });

    $('.start-date-range').datepicker({
        format: "dd-mm",
        autoclose: true,
        todayHighlight: true,
        startView: 0, // Show days only
      })
    $('.end-date-range').datepicker({
        format: "dd-mm",
        autoclose: true,
        todayHighlight: true,
        startView: 0, // Show days only
    })

    

    $(document).ready(function () {
        const today = new Date().toISOString().split('T')[0];
        $("input[name='start_date[]']").attr('min', today);
        let uuid = 0;
        $("#plusBtn").click(function (ele) {
            ele.preventDefault();
            uuid++;
            $("#append-content").append('<div class="container_label"><div class="row"><div class="col-md-3"><div class="form-group"><label for="title">Event Subject <span class="text-danger">*</span></label><input type="text" name="title[]" class="form-control form-control-sm" required></div></div><div class="col-md-3"><div class="form-group"><label for="holiday_type">Event Type <span class="text-danger">*</span></label><select class="form-control form-control-sm" name="holiday_type[]"><option value="">--Select Event Type--</option><option value="Public">Public</option><option value="Special">Special </option></select></div></div><div class="col-md-3"><div class="form-group"><label for="start_date">Start Date <span class="text-danger">*</span></label><br><input type="text" class="form-control form-control-sm start-date-range-'+uuid+'" name="start_date[]" required></div></div><div class="col-md-3"><div class="form-group"><label for="end_date">End Date</label><br><input type="text" class="form-control form-control-sm lesson_input end-date-range-'+uuid+'" name="end_date[]"><span class="text-danger cursor-pointer removeBtn pl-1" title="Remove This"><i class="fas fa-minus-square"></i></span></div></div></div></div>')

            $('.start-date-range-'+uuid).datepicker({
                format: "dd-mm",
                autoclose: true,
                todayHighlight: true,
                startView: 0, // Show days only
            })
            $('.end-date-range-'+uuid).datepicker({
                format: "dd-mm",
                autoclose: true,
                todayHighlight: true,
                startView: 0, // Show days only
            })

        })
        $(document).on('click', '.removeBtn', function () {
            $(this).closest('.container_label').remove();
        });
    });


</script>
@endsection
