@extends('layouts.master')

@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card mt-4">
			<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
		        <h6 class="m-0 table__top__txt">Update Academic Calendar </h6>
                <a href="{{ route('holiday.index') }}" class="btn btn-sm btn-primary">Academic Calendar</a>
		    </div>
            <div class="card-body">
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="list-group list-unstyled">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
	            <form action="{{ route('holiday.update',$original->id) }}" method="POST" enctype="multipart/form-data">
	                @csrf
	                @method('put')
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="year">Year <span class="text-danger">*</span></label>
                                <input type="number" name="year" value="{{ $original->year }}" readonly id="year" class="form-control form-control-sm" required placeholder="YYYY" min="2024" max="2124">
                            </div> 
                        </div>
                    </div>
                    <div class="row">
                        @if(!empty($holidays))
                        @foreach($holidays as $key=>$holiday)
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="title">Event Title <span class="text-danger">*</span></label>
                                <input type="text" name="title[]" value="{{$holiday->title}}" class="form-control form-control-sm" required>
                                <input type="hidden" name="id[]" value="{{$holiday->id}}">
                            </div> 
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="holiday_type">Event Type <span class="text-danger">*</span></label>
                                <select class="form-control form-control-sm" name="holiday_type[]">
                                    <option value="">--Select Event Type--</option>
                                    <option value="Public" @if($holiday->holiday_type == 'Public') selected @endif>Public</option>
                                    <option value="Special" @if($holiday->holiday_type == 'Special') selected @endif>Special </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="start_date">Start Date <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-sm start-date-range-{{$key}}" name="start_date[]" value="{{ date('d-m', strtotime($holiday->start_date)) }}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="end_date">End Date </label>
                                <input type="text" class="form-control form-control-sm lesson_input end-date-range-{{$key}}" name="end_date[]" value="{{ date('d-m', strtotime($holiday->end_date)) }}">
                            </div>
                        </div>


                        @endforeach
                        @endif
                    </div>
                    <div id="append-content"></div>
	                <div class="row mt-3 flex justify-content-end">
	                    <button type="submit" class="btn btn-primary">Update</button>
	                </div>
	            </form>
	        </div>
		</div>
	</div>
</div>
@stop
@section('scripts')
<script>

    $(document).ready(function () {
        const today = new Date();
        const nextWeek = new Date(today);
        const year = today.getFullYear();
        nextWeek.setDate(today.getDate() + 7);

        $("#year").datepicker({
            format: "yyyy",
            viewMode: "years", 
            minViewMode: "years"
        }).datepicker('setDate', today);

        $(document).ready(function () {
            // Initialize datepickers for all dynamically generated fields
            $('input[name="start_date[]"]').datepicker({
                format: "dd-mm",
                autoclose: true,
                todayHighlight: true,
                startView: 0, // Show days only
            });

            $('input[name="end_date[]"]').datepicker({
                format: "dd-mm",
                autoclose: true,
                todayHighlight: true,
                startView: 0, // Show days only
            });
        });


    });
</script>
@endsection