@extends('layouts.master')
@section('styles')
<style>
	.lesson_input{
		width: 88%;
    	display: inline-block;
	}
    .yearselect{
        display: none;
    }
</style>
@endsection
@section('content')
<div class="row">
	<div class="col-md-12">

            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Academic Calendar</h6>
                    <a href="{{ route('holiday.create') }}" class="btn btn-sm btn-primary">Add New</a>
                </div>
                <div class="table-responsive" >
                    <table class="table">
                        <thead class="thead-light">
                            <tr>
                                <th>Event Title</th>
                                <th>Event Type</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th class="action__col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(!empty($holidays))
                            @foreach($holidays as $holiday)
                            <tr>
                                <td>{{ $holiday->title }}</td>
                                <td>{{ $holiday->holiday_type }}</td>
                                <td>{{ $holiday->start_date }}</td>
                                <td>{{ $holiday->end_date }}</td>
                                <td class="d-flex justify-content-start">      
                                    <a class="btn btn-sm btn-soft-secondary mr-1" href="{{ route('holiday.copy', $holiday->id) }}"><i class="fas fa-copy"></i></a>
                                    <a class="btn btn-sm btn-soft-success mr-1" href="{{ route('calendar.index') }}"><i class="fas fa-eye"></i></a>
                                    <a class="btn btn-sm btn-soft-info mr-1" href="{{ route('holiday.edit', $holiday->id) }}"><i class="fas fa-edit"></i></a>             
                                    <form action="{{ route('holiday.destroy', $holiday->id) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-soft-danger btn-sm"
                                            onclick="return confirm('Are you sure you want to delete this branch?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <tr><td colspan="3" class="text-center">No data available in table</td></tr>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
</div>
@stop
