@extends('layouts.master')
@section('styles')
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
.select2{
	height: calc(1.5em + .75rem + 7px) !important;
}
</style>
@endsection
@section('content')
    <div class="card">
    	<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
	        <h6 class="m-0 table__top__txt">Edit Homework</h6>
	        <a href="{{ route('homework.index') }}" class="btn btn-sm btn-light-blue">Homework List</a>
	    </div>
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('homework.update',$homework->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="student_class_id">Class <span class="text-danger">*</span></label>
	                        {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class_id" required', $homework->student_class_id, "--Select Class--") }}
	                        @error('student_class_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="subject_id">Subject <span class="text-danger">*</span></label>
	                        {{ generateDropdown('', 'class="form-control subject_id" id="subject_id" name="subject_id" required', $homework->subject_id, "--Select Subject--") }}
	                        @error('subject_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="section_id">Section</label>
	                        {{ generateDropdown('', 'class="form-control section_id" id="section_id" name="section_id"', $homework->section_id, "--Select Section--") }}
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="group_id">Group</label>
	                        {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"  disabled', $homework->group_id, "--Select Group--") }}
                        </div>
                    </div>
                    
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="homework_date">Homework Date <span class="text-danger">*</span></label>
                            <input type="text" value="{{ view_date_format($homework->homework_date) }}" class="form-control date3601" id="homework_date" name="homework_date">
                            @error('homework_date')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="submission_date">Submission Date <span class="text-danger">*</span></label>
                            <input type="text" value="{{ view_date_format($homework->submission_date) }}" class="form-control date3602" id="submission_date" name="submission_date">
                            @error('submission_date')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="marks">Marks</label>
                            <input type="number" value="{{ $homework->marks }}" class="form-control" id="marks" name="marks" min="0" max="100">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title">Title <span class="text-danger">*</span></label>
                            <input type="text" value="{{ $homework->title }}" class="form-control" id="title" name="title" maxlength="250" required>
                            @error('title')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description">{{ $homework->description }}</textarea>
                            @error('description')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="attachment">Attach Document</label>
                            <input type="file" value="{{ old('attachment') }}" class="form-control dropify" data-default-file="{{ asset($homework->attachment) }}" id="attachment" name="attachment" data-height="238" >
                            @error('attachment')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3 flex justify-content-end">
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
<script>
	$('.student_class').on('change', function(){
        let student_class_id = $('.student_class').val();
        if(student_class_id == 11 || student_class_id == 12){
	      $('#group_id').prop('disabled', false);
	    }else{
	      $('#group_id').prop('disabled', true);
	    }
        getSection(student_class_id);
        getSubjects(student_class_id);
    });

   
    

    let student_class_id = "{{ isset($homework->student_class_id) ? $homework->student_class_id : '' }}";
    let subject_id = "{{ isset($homework->subject_id) ? $homework->subject_id : '' }}";
    let section_id = "{{ isset($homework->section_id) ? $homework->section_id : '' }}";
    if(student_class_id!=''){
        getSection(student_class_id);
        getSubjects(student_class_id);
    }

    

    function getSection(student_class_id){

        
        if(student_class_id){
            $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let sections = response;
                let option = '<option value="">--Select Section--</option>';
                for(let i=0;i<sections.length;i++){
                    // if(sections[i].student_class_id == student_class_id){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }

                    // }
                }
                $('select.section_id').empty().append(option);
            });
        }
    }

    //------------------Get Class Wise Subject List----------------

    function getSubjects(student_class_id){
        
        if(student_class_id){
            $.get('{{ route('subjects.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let subjects = response;

                let option = '<option value="">--Select Subject--</option>';
                for(let i=0;i<subjects.length;i++){
                    if(subjects[i].student_class_id == student_class_id){
                        if(subject_id==subjects[i].subject_id){
                            option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                        }else{
                            option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                        }

                    }
                }
                $('select.subject_id').empty().append(option);
            });
        }
    }

	$(document).ready(function () {

        $('.date3601').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,      
            todayHighlight: true, 
        });

        $('.date3602').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,      
            todayHighlight: true, 
        });


		$('#description').summernote({
	        height: 200
	    });
		$('.dropify').dropify({
		    messages: {
		        'default': 'Drag and drop a file here or click',
		        'replace': 'Drag and drop or click to replace',
		        'remove':  'Remove',
		        'error':   'Ooops, something wrong happended.'
		    }
		});

        document.getElementById("marks").addEventListener("keyup", function() {
          this.value = this.value.replace(/[^0-9]/g,"");
        });
    })


</script>
@endsection
