@extends('layouts.master')
@section('content')
    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Homework List</h6>
            <div class="m-0 float-right">
                <a href="{{ route('homework.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs ml-3" id="myTab" role="tablist">
                    <li class="nav-item active">
                        <a class="nav-link active" id="upcoming-homework-tab" data-toggle="tab"
                           href="#upcoming-homework" role="tab" aria-controls="upcoming-homework" aria-selected="false">Upcoming
                            Homework</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="closed-homework-tab" data-toggle="tab" href="#closed-homework"
                           role="tab" aria-controls="closed-homework" aria-selected="true">Closed Homework</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="upcoming-homework" role="tabpanel"
                         aria-labelledby="upcoming-homework-tab">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Shift</th>
                                    <th>Class</th>
                                    <th>Subject</th>
                                    <th>Homework Date</th>
                                    <th>Submission Date</th>
                                    <th>Marks</th>
                                    <th>Attachment</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if($upcoming->isNotEmpty())
                                    @foreach ($upcoming as $work)
                                        <tr>
                                            <td>{{ $work->id }}</td>
                                            <td>{{ Str::limit($work->title,80) }}</td>
                                            <td>
                                                @if(!empty($work->shift_id))
                                                    {{ $work->shift->shift_name }}
                                                @endif
                                            </td>
                                            <td>{{ $work->studentClass->class_name }}</td>
                                            <td>{{ $work->subject->subject_name }}</td>
                                            <td>{{ view_date_format($work->homework_date) }}</td>
                                            <td>{{ view_date_format($work->submission_date) }}</td>
                                            <td>{{ $work->marks }}</td>
                                            <td>
                                                @if ($work->attachment)
                                                    <a class="btn btn-sm btn-info" href="{{ asset($work->attachment) }}"
                                                       target="_blank">Attachment</a>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td class="d-flex justify-content-start">
                                                <a class="btn btn-sm btn-soft-success"
                                                   href="{{route('homework.show',['homework'=>$work->id])}}"
                                                   target="_blank"><i class="fas fa-eye"></i></a>
                                                <a class="btn btn-sm btn-soft-info mx-1"
                                                   href="{{route('homework.edit',['homework'=>$work->id])}}"><i
                                                        class="fas fa-edit"></i></a>
                                                <form action="{{ route('homework.destroy', $work->id) }}" method="POST"
                                                      class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                                            onclick="return confirm('Are you sure you want to delete this Homework?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="9" class="text-center">No data available in table</td>
                                    </tr>
                                @endif
                                @php unset($upcoming); @endphp
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="closed-homework" role="tabpanel"
                         aria-labelledby="closed-homework-tab">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Shift</th>
                                    <th>Class</th>
                                    <th>Subject</th>
                                    <th>Homework Date</th>
                                    <th>Submission Date</th>
                                    <th>Marks</th>
                                    <th>Attachment</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if($pasts->isNotEmpty())
                                    @foreach ($pasts as $work)
                                        <tr>
                                            <td>{{ $work->id }}</td>
                                            <td>{{ Str::limit($work->title,80) }}</td>
                                            <td>
                                                @if(!empty($work->shift_id))
                                                    {{ $work->shift->shift_name }}
                                                @endif
                                            </td>
                                            <td>{{ $work->studentClass->class_name }}</td>
                                            <td>{{ $work->subject->subject_name }}</td>
                                            <td>{{ $work->homework_date }}</td>
                                            <td>{{ $work->submission_date }}</td>
                                            <td>{{ $work->marks }}</td>
                                            <td>
                                                @if ($work->attachment)
                                                    <a class="btn btn-sm btn-info" href="{{ asset($work->attachment) }}"
                                                       target="_blank">Attachment</a>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td class="d-flex justify-content-start">
                                                <a class="btn btn-sm btn-soft-success"
                                                   href="{{route('homework.show',['homework'=>$work->id])}}"
                                                   target="_blank"><i class="fas fa-eye"></i></a>
                                                <a class="btn btn-sm btn-soft-info mx-1"
                                                   href="{{route('homework.edit',['homework'=>$work->id])}}"><i
                                                        class="fas fa-edit"></i></a>
                                                <form action="{{ route('homework.destroy', $work->id) }}" method="POST"
                                                      class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                                            onclick="return confirm('Are you sure you want to delete this Homework?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="9" class="text-center">No data available in table</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
