@extends('layouts.master')
@section('styles')
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
.select2{
	height: calc(1.5em + .75rem + 7px) !important;
}
</style>
@endsection
@section('content')
    <div class="card">
    	<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
	        <h6 class="m-0 table__top__txt">Show Homework</h6>
	        <a href="{{ route('homework.index') }}" class="btn btn-sm btn-primary">Homework List</a>
	    </div>
        <div class="card-body">
            <form action="{{ route('homework.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                	<div class="col-md-3">
                        <div class="form-group">
                            <label>Branch <span class="text-danger">*</span></label>
                            <select class="form-control" readonly>
                                <option selected>{{$homework->branch->branch_name}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Shift <span class="text-danger">*</span></label>
                            <select class="form-control" readonly>
                                @if(!empty($work->shift_id))
                                <option selected>{{$homework->shift->shift_name}}</option>
                                @else
                                <option selected>Null</option>
                                @endif
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Class <span class="text-danger">*</span></label>
                            <select class="form-control" readonly>
                                <option selected>{{$homework->studentClass->class_name}}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Subject <span class="text-danger">*</span></label>
                            <select class="form-control" readonly>
                                <option selected>{{$homework->subject->subject_name}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Section</label>
                            <select class="form-control" readonly>
                                <option selected>{{ $homework->section_id ? $homework->section->section_name : '--Select Section--'}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Group</label>
                            <select class="form-control" readonly>
                                <option selected>{{ $homework->group_id ? $homework->group->section_name : '--Select Group--'}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Department</label>
                            <select class="form-control" readonly>
                                <option selected>{{ $homework->department_id ? $homework->department->name : '--Select Department--'}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="homework_date">Homework Date <span class="text-danger">*</span></label>
                            <input type="text" readonly value="{{ view_date_format($homework->homework_date) }}" class="form-control" id="homework_date" name="homework_date">
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="submission_date">Submission Date <span class="text-danger">*</span></label>
                            <input type="text" readonly value="{{ view_date_format($homework->submission_date) }}" class="form-control" id="submission_date" name="submission_date">
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="marks">Marks</label>
                            <input type="number" readonly value="{{ $homework->marks }}" class="form-control" id="marks" name="marks" min="0" max="100">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title">Title <span class="text-danger">*</span></label>
                            <input type="text" readonly value="{{ $homework->title }}" class="form-control" id="title" name="title" maxlength="250" required>
                        </div>
                    </div>

                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea readonly class="form-control" id="description" name="description">{!! $homework->description !!}</textarea>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="attachment">Attach Document</label>
                            <input type="file"  value="{{ old('attachment') }}" class="form-control dropify" data-default-file="{{ asset($homework->attachment) }}" id="attachment" name="attachment" data-height="238" >
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
@endsection

@push('scripts')
<script>
	$(document).ready(function () {
		$('#description').summernote({
	        height: 200,
	    });
		$('.dropify').dropify({
		    messages: {
		        'default': 'Drag and drop a file here or click',
		        'replace': 'Drag and drop or click to replace',
		        'remove':  'Remove',
		        'error':   'Ooops, something wrong happended.'
		    }
		});

    })


</script>
@endpush
