@extends('layouts.master')
@section('styles')
<link rel="stylesheet" href="https://prismjs.com/themes/prism.css">
<script src="https://prismjs.com/prism.js"></script>
<script src={{ asset('assets/vendor/multi-file/js/docs.js') }}></script>
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
.select2{
	height: calc(1.5em + .75rem + 7px) !important;
}
</style>
@endsection
@section('content')
    <div class="card">
    	<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
	        <h6 class="m-0 table__top__txt">Add Homework</h6>
	        <a href="{{ route('homework_submission.index') }}" class="btn btn-sm btn-primary">Homework List</a>
	    </div>
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('homework_submission.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                	<div class="col-md-3">
                        <div class="form-group">

                            <label for="homework_id">Homework <span class="text-danger">*</span></label>
                            <select class="form-control" id="homework_id" name="homework_id">
                                <option value="">--Select Homework--</option>
                                @foreach($homeworks as $homework)
                                <option value="{{ $homework->id }}">{{ Str::limit($homework->title,50) }}</option>
                                @endforeach
                            </select>
	                        @error('homework_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="student_class_id">Class <span class="text-danger">*</span></label>
	                        {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class_id" required', $student_class_id, "--Select Class--") }}
	                        @error('student_class_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>


                    <div class="col-md-12 text-danger text-center">You can write answer or upload answer sheet</div>

                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="submission">Write Answer</label>
                            <textarea class="form-control" id="submission" name="submission">{{ old('submission') }}</textarea>
                            @error('submission')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="attachment">Upload File <span class="text-danger">You can select multiple file</span></label>
                            <input name="attachment[]" type="file" multiple="multiple" class="multi" maxlength="10" data-maxfile="1024" accept="gif|jpg|png|pdf|xlsx"/>
                            @error('attachment')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <script>
// wait for document to load
$(function(){

    // invoke plugin
    $('#our-test').MultiFile({
        onFileChange: function(){
            console.log(this, arguments);
        }
    });

});
        </script>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="comment">Comment</label>
                            <textarea class="form-control" id="comment" name="comment">{{ old('comment') }}</textarea>
                            @error('comment')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3 flex justify-content-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
<script src={{ asset('assets/vendor/multi-file/js/jquery.form.js') }}></script>
<script src={{ asset('assets/vendor/multi-file/js/jquery.MetaData.js') }}></script>
<script src={{ asset('assets/vendor/multi-file/js/jquery.MultiFile.min.js') }}></script>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-1942730-1', 'fyneworks.com');
  ga('send', 'pageview');

</script>
</div><footer id="footer"><p>&copy; Fyneworks</p></footer><script type="text/javascript">var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-1942730-1']);
_gaq.push(['_setDomainName', 'fyneworks.com']);
_gaq.push(['_trackPageview']);
(function() {
        var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
        ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
})();</script>

<script>
	$('.student_class').on('change', function(){
        let student_class_id = $('.student_class').val();
        if(student_class_id == 11 || student_class_id == 12){
	      $('#group_id').prop('disabled', false);
	    }else{
	      $('#group_id').prop('disabled', true);
	    }
        getSection(student_class_id);
        getSubjects(student_class_id);
    });

    $('.subject_id').on('change', function(){
        let student_class_id = $('.student_class').val();
        let subject_id = $('.subject_id').val();
        let section_id = $('.section_id').val();
        console.log('student_class_id '+ student_class_id + ' subject_id '+ subject_id+ ' section_id '+ section_id);
        getLessons(student_class_id,subject_id,section_id);
    });


    

    let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";
    let subject_id = "{{ isset($subject_id) ? $subject_id : '' }}";
    let section_id = "{{ isset($section_id) ? $section_id : '' }}";

    if(student_class_id!=''){
        getSection(student_class_id);
        getSubjects(student_class_id);
    }

    if(student_class_id!='' && subject_id!=''){
        getLessons(student_class_id,subject_id,section_id);
    }

    

    function getSection(student_class_id){

        let section_id = "{{ isset($section_id) ? $section_id : '' }}";
        if(student_class_id){
            $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let sections = response;
                let option = '<option value="">--Select Section--</option>';
                for(let i=0;i<sections.length;i++){
                    // if(sections[i].student_class_id == student_class_id){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }

                    // }
                }
                console.log(option);
                $('select.section_id').empty().append(option);
            });
        }
    }

    //------------------Get Class Wise Subject List----------------

    function getSubjects(student_class_id){
        
        if(student_class_id){
            $.get('{{ route('subjects.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let subjects = response;

                let option = '<option value="">--Select Subject--</option>';
                for(let i=0;i<subjects.length;i++){
                    if(subjects[i].student_class_id == student_class_id){
                        if(subject_id==subjects[i].subject_id){
                            option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                        }else{
                            option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                        }

                    }
                }
                $('select.subject_id').empty().append(option);
            });
        }
    }

	$(document).ready(function () {
		$('#comment').summernote({
	        height: 100
	    });
        $('#submission').summernote({
            height: 200
        });
		$('.dropify').dropify({
		    messages: {
		        'default': 'Drag and drop a file here or click',
		        'replace': 'Drag and drop or click to replace',
		        'remove':  'Remove',
		        'error':   'Ooops, something wrong happended.'
		    }
		});
    })


</script>
@endsection
