@extends('layouts.master')
@section('styles')
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
</style>
@endsection
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="POST" action="{{ route('homework.result.search') }}" class="row">
                @csrf
               <div class="form-group col-lg-3 col-md-3 col-sm-6">
                    <select class="form-control" name="homework_id">
                        <option value="">--Select Homework--</option>
                        @foreach($homeworks as $homework)
                        <option value="{{$homework->id}}" @if(!empty($searchBy)) @if($searchBy->id == $homework->id) selected @endif @endif>{{$homework->title}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-lg-3 col-md-3 col-sm-6">
                    <button type="submit" class="btn btn-info ">Search</button>
                </div>
            </form>
        </div>
    </div>


@if(!empty($results))
<div class="card mt-4" id="syllabusStatus">
    <div class="row">
        <div class="col-md-12">

            <form method="POST" action="{{ route('homework.marks.entry') }}">
            @csrf
            <div class="table-responsive">
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th width="30">Std. ID</th>
                            <th>Name</th>
                            <th>Answer</th>
                            <th>Attachment</th>
                            <th class="text-center">Marks</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($results->isNotEmpty())
                        @foreach($results as $key=>$result)
                        <tr>
                            <td>{{ $result->student?->student_id_no ?? 0 }}</td>
                            <td>{{ $result->student?->name ?? 'N/A' }}</td>
                            <td>{!! $result->answer !!}</td>        
                            <td>
                                @php
                                    $filePaths = json_decode($result->attachment, true);
                                @endphp
                                @foreach ($filePaths as $filePath)
                                    <a href="{{ asset($filePath) }}" class="btn btn-sm btn-info mb-2" target="_blank">Attachment</a><br>
                                @endforeach
                            </td>   
                            <td class="text-center">
                                <div class="d-flex justify-content-center align-items-center gap-2">
                                    <input 
                                        class="form-control form-control-sm" 
                                        placeholder="Marks" 
                                        style="width: 80px;" 
                                        type="number" 
                                        name="marks[]" 
                                        @if(!empty($result->marks)) readonly @endif  
                                        value="{{ $result->marks }}" 
                                        min="0" 
                                        max="{{ $searchBy->marks }}"
                                    >
                                    <input 
                                        type="text"  
                                        class="form-control form-control-sm" 
                                        style="width: 150px;"  
                                        readonly 
                                        value="Out Of {{ $result->homework?->marks ?? 0 }}"
                                    >
                                </div>
                            </td>    
                            <input type="hidden" name="student_id[]" value="{{$result->student_id}}"> 
                            <input type="hidden" name="homework_id" value="{{$result->homework_id}}"> 
                        </tr>
                        @endforeach
                        @else
                            <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif
                    </tbody>
                    @if($results->isNotEmpty())
                    <tfoot>
                        <tr>
                          <td colspan="6">
                              <button type="submit" class="btn btn-info float-right" style="padding:10px;">Submit</button>
                          </td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
            </form>
        </div>
    </div>
</div>
@endif

@endsection

@section('scripts')


@endsection
