@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-body card__head">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link {{ request()->query('tab', 'search') === 'search' ? 'active' : '' }}" data-toggle="tab" href="#search-tab">Search By ID</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ request()->query('tab') === 'filter' ? 'active' : '' }}" data-toggle="tab" href="#filter-tab">Search by Class</a>
            </li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <div id="search-tab" class="tab-pane {{ request()->query('tab', 'search') === 'search' ? 'show active' : '' }}"><br>
                <form method="GET" action="{{ route('assign_room.index') }}" class="row">
                    <input type="hidden" name="tab" value="search">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">                        
                        @component('components.search_student', [
                            'student_name' => request()->query('student_name') ?? '',
                            'student_id_no' => request()->query('student_id_no') ?? '',
                            'required' => '',
                        ])
                        @endcomponent
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            <div id="filter-tab" class="tab-pane fade {{ request()->query('tab') === 'filter' ? 'show active' : '' }}"><br>
                <form method="GET" action="{{ route('assign_room.index') }}" class="row">
                    <input type="hidden" name="tab" value="filter">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control select2 student_class" id="student_class" name="student_class" required', request()->query('student_class'), "Class") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">
            Student List
        </h6>
        <div class="m-0 float-right">
            
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">   
                        <tr>
                            <th>Roll</th>
                            <th>Stu. ID</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Hostel</th>
                            <th>Amount</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($students)
                            @foreach ($students as $student)
                                <tr>
                                    <td>{{ $student->class_roll ?? "" }}</td>
                                    <td> <a href="{{route('student_info.edit', $student->id)}}" target="_blank">{{ $student->student_id_no }}</a> </td>
                                    <td>{{ $student->first_name." ".$student->last_name }}</td>
                                    <td>{{ $student->studentClass?->class_name ?? "" }}</td>
                                    <td>
                                        {{ generateDropdown($hostels, 'class="form-control hostel_id"', $student->studentHostel?->hostel_id, 'Hostel') }}
                                        <input type="hidden" class="student_id" value="{{ $student->id }}">
                                    </td>
                                    <td>
                                        <input type="number" class="monthly_cost" min="0" max="20000" value="{{ (int) ($student->studentHostel?->cost ?? 0) }}">
                                    </td>
                                    <td>
                                        <button class="btn btn-sm {{ $student->studentHostel?->student_id ? 'btn-success' : 'btn-info' }} " onclick="saveData(this)">{{ $student->studentHostel?->student_id ? 'Update' : 'Save' }}</button>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr><td colspan="9" class="text-center">No data available in table</td></tr>  
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
    <!-- Modal -->
    {{-- <div class="modal fade" id="assignModal" tabindex="-1" aria-labelledby="assignModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="assignModalLabel">Assign Hostel Room</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="code">Hostel Room <i class="fas fa-question-circle" data-container="body" data-toggle="popover"
                            data-placement="right" data-content="Hostel -> Floor -> Room No -> Cost -> Total Bed/Available be"></i></label>

                        @component('components.search_hostel_room')@endcomponent
                    </div>
                    <div class="modalContent">
                        <input type="hidden" name="student_id" id="student_id" class="student_id">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="saveData()">Save</button>
                </div>
            </div>
        </div>
    </div> --}}

@endsection
@section('scripts')
    <script>

        // $('.student_class').on('change', function(){
        //     let student_class_id = $('.student_class').val();
        //     getSection(student_class_id);
        // });

        // let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        // if(student_class_id!=''){
        //     getSection(student_class_id);
        // }

        // function getSection(student_class_id){

        //     let section_id = "{{ request()->query('section') ?? '' }}";
        //     if(student_class_id){
        //         $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
        //             let sections = response;
        //             console.log(sections);
        //             let option = '<option value="">Section</option>';
        //             for(let i=0;i<sections.length;i++){
        //                 if(section_id==sections[i].id){
        //                     option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
        //                 }else{
        //                     option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
        //                 }
        //             }
        //             $('select.section').empty().append(option);
        //         });
        //     }
        // }

        // $('#assignModal').on('show.bs.modal', function(event) {
        //     $('#hostel-room-search').focus();
        //     var button = $(event.relatedTarget);
        //     var action = button.data('action');
        //     var studentId = button.data('student_id');
        //     $('#student_id').val(studentId);

        //     if(action=='edit'){
        //         var hostel_room = button.data('student_hostel_details');

        //         $('#student_id').val(studentId);

        //         $.ajax({
        //             url: "{{ route('student-hostel-rooms') }}",
        //             data: {
        //                 hostel_room_id : hostel_room.hostel_room_id
        //             },
        //             success: function(hostel_room) {
        //                 console.log(hostel_room);
        //                 const label = `${hostel_room.hostel.name} -> ${hostel_room.hostel_floor.name} -> ${hostel_room.room_name} -> (Tk. ${Math.round(hostel_room.room_type.cost_per_bed)}) - ${hostel_room.no_of_bed}/${hostel_room.no_of_bed - hostel_room.assigned_beds}`;
        //                 const value = hostel_room.id;
        //                 $('#hostel-room-search').val(label);
        //                 $('#hostel-room-search-value').val(value);
        //             }
        //         });
        //     }
        // });

        // $('#assignModal').on('hidden.bs.modal', function() {
        //     $('#hostel-room-search').val('');
        //     $('#hostel-room-search-value').val('');
        // });


        // function saveData() {
        //     var student_id = $('#student_id').val();
        //     var hostel_room_id = $('#hostel-room-search-value').val();
        //     const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;

        //     $.post("{{route('assign_room.store')}}", {
        //         _token: csrfToken,
        //         student_id: student_id,
        //         hostel_room_id: hostel_room_id
        //     }, function(response) {
        //         if (response.success) {
        //             toastr.success(response.message, 'Success');
        //             $('#assignModal').modal('hide');
        //             var button = $('button[data-student_id="' + student_id + '"]');
        //             button.text('Update');
        //             // button.prop('disabled', true);
        //         }else{
        //             toastr.error(response.message, 'Success');
        //         }
        //     });
        // }

        function saveData(btn) {
            let row = $(btn).closest('tr');

            let student_id  = row.find('.student_id').val();
            let hostel_id = row.find('.hostel_id').val();
            let monthly_cost      = row.find('.monthly_cost').val();
            console.log(monthly_cost)
            const csrfToken = document.head.querySelector(
                'meta[name="csrf-token"]'
            ).content;

            $.ajax({
                url: "{{ route('assign_room.store') }}",
                type: "POST",
                data: {
                    _token: csrfToken,
                    student_id: student_id,
                    hostel_id: hostel_id,
                    monthly_cost: monthly_cost
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                        $(btn).text('Update').removeClass('btn-info').addClass('btn-success');
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Something went wrong');
                }
            });
        }

    </script>
@endsection
