@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
                
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
                <h6 class="m-0 table__top__txt">Hostel List</h6>
                <div class="m-0 float-right">
                    <button type="button" class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#hostelModal" data-action="create">
                        Add New
                    </button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table" id="dataTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th>No of Floor</th>
                                    <th>Address</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $sn = 0; @endphp
                                @foreach($hostels as $hostel)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{ $hostel->name }}</td>
                                        <td>{{ $hostel->no_of_floor }}</td>
                                        <td>{{ $hostel->address }}</td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-soft-info" data-toggle="modal" data-target="#hostelModal"
                                            data-action="edit" data-id="{{ $hostel->id }}" data-name="{{ $hostel->name }}"
                                            data-no_of_floor="{{ $hostel->no_of_floor }}" data-address="{{ $hostel->address }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <form action="{{ route('hostel.destroy', $hostel->id) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i></button>

                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Hostel Modal -->
    <div class="modal fade" id="hostelModal" tabindex="-1" role="dialog" aria-labelledby="hostelModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="hostelModalLabel">Hostel</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="hostelForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="_method" id="formMethod">

                        <div class="form-group">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                        </div>

                        <div class="form-group">
                            <label for="no_of_floor">No of floor</label>
                            <input type="number" class="form-control no_of_floor" id="no_of_floor" name="no_of_floor" value="{{ old('no_of_floor') }}" >
                        </div>

                        <div class="form-group">
                            <label for="address">Address</label>
                            <input type="text" class="form-control" id="address" name="address" value="{{ old('address') }}" >
                        </div>

                        <input type="hidden" id="id" name="id" value="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Hostel Modal -->
    {{-- <div class="modal fade" id="hostelModal" tabindex="-1" role="dialog" aria-labelledby="hostelModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="hostelModalLabel">Hostel</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="hostelForm" method="POST">
                        @csrf
                        <input type="hidden" name="_method" id="formMethod">

                        <div class="form-group">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                        </div>

                        <div class="form-group">
                            <label for="no_of_floor">No of floor <span class="text-danger">*</span></label>
                            <input type="number" class="form-control no_of_floor" id="no_of_floor" name="no_of_floor" value="{{ old('no_of_floor') }}" required>
                        </div>

                        <div class="form-group">
                            <label for="address">Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="address" name="address" value="{{ old('address') }}" required>
                        </div>

                        <input type="hidden" id="id" name="id" value="">
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit">Submit</button>
                </div>
            </div>
        </div>
    </div> --}}


@endsection
@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#hostelModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var action = button.data('action');
                var id = button.data('id');
                var name = button.data('name');
                var no_of_floor = button.data('no_of_floor');
                var address = button.data('address');

                var modal = $(this);
                var form = modal.find('form');
                var method = id ? 'PUT' : 'POST';
                modal.find('[name="_method"]').val(method);
                var actionUrl = id ? '/hostel/update/' + id : '/hostel/create';
                if (action === 'edit') {
                    // form.attr('action', '{{ route("hostel.update", ":id") }}'.replace(':id', id));
                    form.attr('action', actionUrl);
                    modal.find('.modal-title').text('Edit Hostel');
                    modal.find('#name').val(name);
                    modal.find('#no_of_floor').val(no_of_floor);
                    modal.find('#address').val(address);
                    modal.find('#id').val(id);
                } else {
                    form.attr('action', '{{ route("hostel.store") }}');
                    modal.find('.modal-title').text('Create New Hostel');
                    modal.find('#name').val('');
                    modal.find('#no_of_floor').val('');
                    modal.find('#address').val('');
                    modal.find('#id').val('');
                }
            });
        });
    </script>
@endsection
