@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
                
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Hostel Room List</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-primary" id="add-student-btn" data-toggle="modal" data-target="#hostelRoomModal">Add
                        New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Hostel Name</th>
                                    <th>Room Name</th>
                                    <th>Room Type</th>
                                    <th>Cost/Bed (Tk)</th>
                                    <th>Floor Number</th>
                                    <th>No Of Bed</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($hostelRooms->isNotEmpty())
                                @php
                                    $sn = 0;
                                @endphp
                                    @foreach ($hostelRooms as $hostelRoom)
                                        <tr>
                                            <td>{{ ++$sn; }}</td>
                                            <td>{{ $hostelRoom->hostel->name }}</td>
                                            <td>{{ $hostelRoom->room_name }}</td>
                                            <td>{{ $hostelRoom->roomType->name }}</td>
                                            <td>{{ round($hostelRoom->roomType->cost_per_bed) }}</td>
                                            <td>{{ $hostelRoom->hostelFloor->name }}</td>
                                            <td>{{ $hostelRoom->no_of_bed }}</td>
                                            <td class="d-flex justify-content-between">
                                                <button type="button" class="btn btn-sm btn-primary mr-1" data-toggle="modal"
                                                data-target="#hostelRoomModal" data-action="edit" data-id="{{ $hostelRoom->id }}"
                                                data-room-name="{{ $hostelRoom->room_name }}" data-hostel-id="{{ $hostelRoom->hostel_id }}"
                                                data-room-type-id="{{ $hostelRoom->room_type_id }}" data-hostel-floor-id="{{ $hostelRoom->hostel_floor_id }}"
                                                data-no-of-bed="{{ $hostelRoom->no_of_bed }}">Edit</button>
                                                <form action="{{ route('hostel-room.destroy', $hostelRoom->id) }}" method="post" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this subject?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                <tr><td colspan="8" class="text-center">No data available in table</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- create Modal -->
    <div class="modal fade" id="hostelRoomModal" tabindex="-1" role="dialog" aria-labelledby="hostelRoomModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="hostelRoomModalLabel">Create/Edit Hostel Room</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="hostelRoomForm" method="post">
                        @csrf
                        @method('POST')
                        <input type="hidden" id="id" name="id" value="">
                        <div class="form-group">
                            <label for="room_name">Room Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="room_name" name="room_name" required>
                        </div>
                        <div class="form-group">
                            <label for="hostel_id">Hostel <span class="text-danger">*</span></label>
                            <select class="form-control hostel" id="hostel_id" name="hostel_id" required>
                                <option value="">--Select Hostel--</option>
                                @foreach($hostels as $hostel)
                                    <option value="{{ $hostel->id }}">{{ $hostel->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="floor_no">Floor No <span class="text-danger">*</span></label>
                            {{ generateDropdown([], 'class="form-control select2 hostel_floor_id" id="hostel_floor_id" name="hostel_floor_id" required', '', 'Select Option') }}
                        </div>
                        <div class="form-group">
                            <label for="room_type_id">Room Type <span class="text-danger">*</span></label>
                            <select class="form-control " id="room_type_id" name="room_type_id" required>
                                <option value="">--Select Room Type--</option>
                                @foreach($roomTypes as $roomType)
                                    <option value="{{ $roomType->id }}">{{ "$roomType->name (Tk. ".round($roomType->cost_per_bed).")" }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="no_of_bed">No of Bed <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="no_of_bed" name="no_of_bed" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" form="hostelRoomForm">Save</button>
                </div>
            </div>
        </div>
    </div>
    <!-- modal end -->
@endsection
@section('scripts')
    <script type="text/javascript">
       $(document).ready(function() {

            $('#hostelRoomModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var action = button.data('action');
                var id = button.data('id');
                var roomName = button.data('room-name');
                var hostelId = button.data('hostel-id');
                var roomTypeId = button.data('room-type-id');
                var hostelFloorID = button.data('hostel-floor-id');
                var noOfBed = button.data('no-of-bed');

                var modal = $(this);
                var form = modal.find('form');
                var method = id ? 'PUT' : 'POST';
                modal.find('[name="_method"]').val(method);

                if (action === 'edit') {
                    form.attr('action', '/hostel/hostel-rooms/update/' + id);
                    modal.find('.modal-title').text('Edit Hostel Room');
                    modal.find('#room_name').val(roomName);

                    modal.find('#hostel_id').val(hostelId).trigger('change');
                    modal.find('#room_type_id').val(roomTypeId).trigger('change');
                    modal.find('#hostel_floor_id').val(hostelFloorID).trigger('change');
                    modal.find('#no_of_bed').val(noOfBed);

                    $.get('{{ route('hostel.floors') }}', { hostel_id: hostelId }, function(response) {
                        let hostel_floors = response;

                        let option = '<option value="">--Select Section--</option>';
                        for(let i = 0; i < hostel_floors.length; i++) {
                            option += `<option value="${hostel_floors[i].id}">${hostel_floors[i].name}</option>`;
                        }
                        $('#hostel_floor_id').empty().append(option);
                        modal.find('#hostel_floor_id').val(hostelFloorID).trigger('change');
                    });


                } else {
                    form.attr('action', '{{ route("hostel-room.store") }}');
                    modal.find('.modal-title').text('New Hostel Room');
                    modal.find('#room_name').val('');
                    modal.find('#hostel_id').val(''); // reset select2 field
                    modal.find('#room_type_id').val(''); // reset select2 field
                    modal.find('#hostel_floor_id').val('');
                    modal.find('#no_of_bed').val('');

                }
            });

            $('.hostel').on('change', function(){
                let hostel_id =  $(this).val();
                if(hostel_id){
                    $.get('{{ route('hostel.floors') }}', { hostel_id: hostel_id }, function(response) {
                        let hostel_floors = response;

                        let option = '<option value="">--Select Section--</option>';
                        for(let i=0;i<hostel_floors.length;i++){

                            option += '<option value='+hostel_floors[i].id+' >' +hostel_floors[i].name+ '</option>';

                        }
                        $('#hostel_floor_id').empty().append(option);

                    });
                }
            });
        });
    </script>
@endsection
