@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
                
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Room Type List</h6>
                <div class="m-0 float-right">
                <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#roomTypeModal">Create New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Room Type</th>
                                    <th>Cost Per Bed</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($roomTypes->isNotEmpty())
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach($roomTypes as $roomType)
                                    <tr>
                                        <td>{{ ++$sn }}</td>
                                        <td>{{ $roomType->name }}</td>
                                        <td>{{ round($roomType->cost_per_bed) }}</td>
                                        <td class="d-flex justify-content-start">
                                            <button type="button" class="btn btn-sm btn-soft-info mr-1" data-toggle="modal"
                                            data-target="#roomTypeModal" data-action="edit" data-id="{{ $roomType->id }}"
                                            data-name="{{ $roomType->name }}" data-cost_per_bed="{{ round($roomType->cost_per_bed) }}"><i class="fas fa-edit"></i></button>
                                            <form action="{{ route('room-type.destroy', $roomType->id) }}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @else
                                <tr><td colspan="4" class="text-center">No data available in table</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="roomTypeModal" tabindex="-1" role="dialog" aria-labelledby="roomTypeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="roomTypeModalLabel">Create/Edit Room Type</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="roomTypeForm" method="post">
                    @csrf
                    <input type="hidden" name="_method" id="formMethod">
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="cost_per_bed">Cost Per Bed</label>
                        <input type="number" class="form-control" id="cost_per_bed" name="cost_per_bed" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary" form="roomTypeForm">Save</button>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script type="text/javascript">
   $(document).ready(function() {
        $('#roomTypeModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget);
            var action = button.data('action');
            var id = button.data('id');
            var name = button.data('name');
            var cost_per_bed = button.data('cost_per_bed');

            var modal = $(this);
            var form = modal.find('form');
            var method = id ? 'PUT' : 'POST';
            modal.find('[name="_method"]').val(method);

            if (action === 'edit') {
                form.attr('action', '/room-type/update/' + id);
                modal.find('.modal-title').text('Edit Room Type');
                modal.find('#name').val(name);
                modal.find('#cost_per_bed').val(cost_per_bed);
                modal.find('#id').val(id);
            } else {
                form.attr('action', '{{ route("room-type.store") }}');
                modal.find('.modal-title').text('Create Room Type');
                modal.find('#name').val('');
                modal.find('#cost_per_bed').val('');
                modal.find('#id').val('');
            }
        });
    });
</script>
@endsection
