@extends('layouts.master')
@section('content')

{{-- <div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('employee-salary.create') }}" class="row">
            <div class="col-lg-4">
                <div class="form-group mb-0">
                    @component('components.employee_search', [
                        'employee_name' => $employee_name ?? '',
                        'employee_code' => request()->employee_code ?? '',
                        'required' => '',
                    ])
                    @endcomponent
                </div>
            </div>
            <div class="form-group col-lg-2 col-md-2">
                {{ generateDropdown($academicYears, 'class="form-control academic_year" id="academic_year" name="academic_year"', request()->query('academic_year'), "Select Year") }}
            </div>
            <div class="form-group col-lg-2 col-md-2">
                {{ generateDropdown(config('months'), 'class="form-control month" id="month" name="month"', request()->query('month'), "Select Month") }}
            </div>
            <div class="form-group col-lg-2 col-md-2">
                {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Select Shift") }}
            </div>

            <div class="form-group col-lg-2 col-md-2">
                <button type="submit" class="btn btn-info ">Search</button>
            </div>

        </form>
    </div>
</div> --}}

<div class="card mt-3">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Create Employee Salary</h6>
        <div class="m-0 float-right">
            <a href="{{ route('employee-salary.index') }}" class="btn btn-sm btn-primary">Employee Salary List</a>
        </div>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('employee-salary.create') }}" class="row">
            <div class="col-lg-5">
                <div class="form-group mb-0">
                    @component('components.employee_search', [
                        'employee_name' => $employee_name ?? '',
                        'employee_code' => request()->employee_code ?? '',
                        'required' => '',
                    ])
                    @endcomponent
                </div>

            </div>
            <div class="form-group col-lg-2 col-md-2">
                <button type="submit" class="btn btn-info ">Search</button>
            </div>
        </form>

        @if (isset($employee) && !empty($employee))

            <form action="{{ route('employee-salary.store') }}" method="POST" >
                @csrf
                <input type="hidden" name="employee_code" value="{{$employee->employee_code}}">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="salary">Salary</label>
                                    <input type="number" step="0.01" value="{{ old('salary', round($employee->salary)) }}" class="form-control salary"
                                        id="salary" name="salary">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="salary_grade">Salary Grade *</label>
                                    {{ generateDropdown($salary_grades, 'class="form-control salary_grade" id="salary_grade" name="salary_grade"', old('salary_grade', $employee->salary_grade_id), 'Select Grade') }}
                                </div>
                            </div>
                            @if(isset($employee->salaryGrade->salaryGradeRules))

                                @foreach ($employee->salaryGrade->salaryGradeRules as $gradeRule)
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="{{$gradeRule->salaryHead->code}}">{{$gradeRule->salaryHead->title}}</label>
                                            @php
                                                $value = $gradeRule->amount;
                                                $amount = $gradeRule->rule_type == "Percentage" ? ($employee->salary * ($value/100)) : $value;
                                            @endphp
                                            <input type="number" step="0.01" value="{{$amount}}" class="form-control {{$gradeRule->salaryHead->code}}"
                                                id="{{$gradeRule->salaryHead->code}}" name="{{$gradeRule->salaryHead->code}}"
                                                placeholder="Enter {{$gradeRule->salaryHead->title}}" readonly>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="col-md-6">
                                    <h4>Assign a grade to this employee first.</h4>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <button type="submit" class="btn btn-info ">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        @endif
    </div>
</div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $('.salary_grade, #salary').on('change keyup', function(event) {
                event.preventDefault();
                var id = $('.salary_grade').val();
                var salary = $('#salary').val();

                $.ajax({
                    type: 'GET',
                    url: '{{ route("salary-grades.edit", ":id") }}'.replace(':id', id),
                    success: function(data) {

                        $.each(data.salary_grade_rules, function(index, value) {
                            let headValue = value.rule_type == "Percentage" ? (salary * (value.amount / 100)) : value.amount;
                            $('#' + value.salary_head.code).empty().val(customRound(headValue,2));
                        });
                    }
                });
            });
        });

    </script>

@endsection
