@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="GET" action="{{ route('employee-salary.index') }}" class="row">
                <div class="col-sm-6 col-md-6 col-lg-3">
                    <div class="form-group mb-0">
                        @component('components.employee_search', [
                            'employee_name' => $employee_name ?? '',
                            'employee_code' => request()->employee_code ?? '',
                            'required' => '',
                        ])
                        @endcomponent
                    </div>
                </div>
                <div class="form-group col-sm-6 col-md-6 col-lg-3">
                    <input type="text" name="from_date" value="{{request()->from_date}}" class="form-control date360"
                           readonly>
                </div>
                <div class="form-group col-sm-6 col-md-6 col-lg-3">
                    <input type="text" name="to_date" value="{{request()->to_date}}" class="form-control date360"
                           readonly>
                </div>

                <div class="form-group col-sm-6 col-md-6 col-lg-3">
                    <button type="submit" class="btn btn-info ">Search</button>
                </div>

            </form>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Employee Salary List</h6>
            <div class="m-0 float-right">
                <a href="{{ route('employee-salary.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                        <tr>
                            <th>Emp. ID</th>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>Salary Grade</th>
                            <th>Status</th>
                            @foreach ($salary_heads as $head)
                                <th>{{$head->title}}</th>
                            @endforeach
                            <th class="action__col">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if($employee_salaries->isNotEmpty())
                            @foreach($employee_salaries as $salary)
                                <tr>
                                    <td>{{$salary->employee->employee_code}}</td>
                                    <td>{{$salary->employee->name}}</td>
                                    <td>{{$salary->employee->mobile_number}}</td>
                                    <td>{{$salary->salaryGrade->title}}</td>
                                    <td>{!!getStatusBadge($salary->status)!!}</td>
                                    @foreach ($salary->salaryGrade->salaryGradeRules as $gradeRules)
                                        @if ($gradeRules->rule_type == 'Percentage')

                                            <td>{{ ($salary->amount * $gradeRules->amount)/100 }}</td>
                                        @endif
                                    @endforeach

                                    {{-- <td>{{$salary->amount}}</td> --}}
                                    <td class="d-flex justify-content-start">
                                        @if ($salary->status=='active')

                                            <a class="btn btn-sm btn-soft-info"
                                               href="{{route('employee-salary.create')."?employee_code=".$salary->employee->employee_code }}"><i
                                                    class="fas fa-edit"></i></a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="15" class="text-center">No data available in table</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            const today = new Date();
            $('.date360').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true,
                todayHighlight: true,
            }).datepicker('setDate', today);
        })
    </script>
@endsection
