@extends('layouts.master')
@section('content')

    <div class="card">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Edit Employee</h5> <a href="{{ route('employees.index') }}" class="btn btn-sm btn-primary">Employee List</a>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('employees.update', $employee->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <!-- Personal Info Section -->
                <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                    Personal Info
                </div>
                <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="first_name">First Name <span class="text-danger">*</span></label>
                                    <input type="text" value="{{ old('first_name', $employee->first_name) }}"
                                        class="form-control" id="first_name" name="first_name"
                                        placeholder="Enter first name" required>
                                    @error('first_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="last_name">Last Name</label>
                                    <input type="text" value="{{ old('last_name', $employee->last_name) }}"
                                        class="form-control" id="last_name" name="last_name" placeholder="Enter last name"
                                        required>
                                    @error('last_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="gender">Gender <span class="text-danger">*</span></label>
                                    {{ generateDropdown($genderOptions, 'class="form-control" name="gender" required', old('gender', $employee->gender), 'Select Option') }}
                                    @error('gender')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date_of_birth">Date Of Birth </label>
                                    <input type="date" class="form-control" name="date_of_birth"
                                        value="{{ old('date_of_birth', $employee->date_of_birth) }}" required>
                                    @error('date_of_birth')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="blood_group">Blood Group </label>
                                    {{ generateDropdown($bloodGroupOptions, 'class="form-control" name="blood_group"', old('blood_group', $employee->blood_group), 'Select Option') }}
                                    @error('blood_group')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="religion">Religion <span class="text-danger">*</span></label>
                                    {{ generateDropdown($religionOptions, 'class="form-control" name="religion" required', old('religion', $employee->religion)) }}
                                    @error('religion')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="image-uploader">
                            <label for="image">Profile Image </label>
                            <label for="imageFile" class="image-uploader__label">
                                <div class="image-uploader__icon-overlay">
                                    <i class="fas fa-cloud-upload-alt"></i>
                                </div>
                                @php
                                    $employee_photo = $employee->employee_photo;
                                    $path = $employee_photo ? $employee_photo : 'assets/img/man.png';
                                @endphp
                                <img src="{{ asset($path) }}" alt="Preview image"
                                    class="image-uploader__preview-image img-thumbnail"
                                    style="width: 140px; height: 140px;">
                                <input type="file" name="profile_image" class="image-uploader__input" id="imageFile"
                                    accept="image/*">
                            </label>
                            @error('profile_image')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="father_name">Father Name</label>
                            <input type="text" value="{{ old('father_name', $employee->father_name) }}"
                                class="form-control" id="father_name" name="father_name" placeholder="Enter father name">
                            @error('father_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="mother_name">Mother Name</label>
                            <input type="text" value="{{ old('mother_name', $employee->mother_name) }}"
                                class="form-control" id="mother_name" name="mother_name" placeholder="Enter mother name">
                            @error('mother_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="marital_status">Marital Status</label>
                            {{ generateDropdown($marital_status, 'class="form-control" name="marital_status"', old('marital_status', $employee->marital_status), 'Select Option') }}
                            @error('marital_status')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="spaous_name">Spaous Name</label>
                            <input type="text" class="form-control" id="spaous_name" name="spaous_name"
                                value="{{ old('spaous_name', $employee->spaous_name) }}" placeholder="Enter spaous name">
                            @error('spaous_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{-- Present Address Start --}}
                    <label for="present_address">Present Address</label>
                    <div class="row col-md-12 border mb-3 ml-1">
                        <x-location-dropdown
                            :selected-division="$employee->present_division_id" 
                            :selected-district="$employee->present_district_id"
                            :selected-upazila="$employee->present_upazila_id"
                            :selected-union="$employee->present_union_id"
                            container-class=""
                            group-class="form-group col-md-3"
                            label-class="form-label"
                            select-class="form-control select2"
                            prefix="present"
                        />
                        
                        <div class="col-md-12">
                            <div class="form-group">
                                <textarea class="form-control" name="present_address" id="present_address"
                                placeholder="Present Address">{{$employee->present_address}}</textarea>
                            </div>
                        </div>
                    </div>
                    {{-- Present Address End --}}

                    {{-- Permanent Address Start --}}
                    <label for="permanent_address">Permanent Address</label>
                    (<div class="form-group">
                        <input type="checkbox" id="copyAddress" />
                        <label for="copyAddress">Copy Present Address</label>
                    </div>)
                    <div class="row col-md-12 border mb-3 ml-1">
                        <x-location-dropdown 
                            :selected-division="$employee->permanent_division_id" 
                            :selected-district="$employee->permanent_district_id"
                            :selected-upazila="$employee->permanent_upazila_id"
                            :selected-union="$employee->permanent_union_id"
                            container-class=""
                            group-class="form-group col-md-3"
                            label-class="form-label"
                            select-class="form-control select2"
                            prefix="permanent"
                        />

                        <div class="col-md-12">
                            <div class="form-group">
                                <textarea class="form-control" name="permanent_address" id="permanent_address"
                                placeholder="Permanent Address">{{$employee->permanent_address}}</textarea>
                            </div>
                        </div>
                    </div>
                    {{-- Permanent Address End --}}

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="mobile_number">Mobile Number</label>
                            <input type="text" class="form-control" id="mobile_number" name="mobile_number"
                                value="{{ old('mobile_number', $employee->mobile_number) }}"
                                placeholder="Enter mobile number">
                            @error('mobile_number')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="emergency_number">Emergency Number</label>
                            <input type="text" class="form-control" id="emergency_number" name="emergency_number"
                                value="{{ old('emergency_number', $employee->emergency_number) }}"
                                placeholder="Enter Emergency Number">
                            @error('emergency_number')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="text" class="form-control" id="email" name="email"
                                value="{{ old('email', $employee->email) }}" placeholder="Enter Email">
                            @error('email')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="identity_type">Identity Types</label>
                            {{ generateDropdown($identity_types, 'class="form-control" name="identity_type" ', old('identity_type', $employee->identity_type), 'Select Option') }}
                            @error('identity_type')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="identity_no">Identity No</label>
                            <input type="text" class="form-control" id="identity_no" name="identity_no"
                                value="{{ old('identity_no', $employee->identity_no) }}" placeholder="Enter Identity No">
                            @error('identity_no')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <!-- user type -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="roles">User Type <span class="text-danger">*</span></label>
                            {{ generateDropdown(['supper-admin' => 'Supper Admin', 'admin'=>'Admin', 'teacher'=>'Teacher', 'accountant'=>'Accountant', 'staff'=>'Staff/Employee'], 'class="form-control" name="user_type" required', old('user_type', $employee->user_type), 'Select Option') }}
                            @error('user_type')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="roles">Role</label>
                            @php
                                $selectedRole = $employee->user->getRoleNames()->first() ?? '';
                            @endphp
                            {{ generateDropdown($roles, 'class="form-control" name="roles" ', old('roles', $selectedRole), '--Select Role--') }}
                            @error('roles')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <input type="hidden" name="user_type" value="{{ $employee->user_type }}">

                </div>

                <!-- Education Info Section -->
                <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                    Education Info
                </div>
                <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                    @if (isset($employee->employee_education) && count($employee->employee_education) > 0)
                        @foreach ($employee->employee_education as $key => $employee_education)
                            <div class="row p-2 education-info border m-2">
                                @if ($key != 0)
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <button type="button" class="btn btn-sm btn-danger removeBtn">
                                                <i class="fas fa-minus-circle"></i> Remove
                                            </button>
                                        </div>
                                    </div>
                                @endif
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="exam_name">Exam</label>
                                        {{ generateDropdown($exam_names, 'class="form-control" name="education_infos[' . $key . '][exam_name]" ', old('education_infos.' . $key . '.exam_name', $employee_education->exam_name), 'Select Option') }}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="institute">Institution</label>
                                        <input type="text" max="200" class="form-control"
                                            name="education_infos[{{ $key }}][institute]"
                                            value="{{ old('education_infos.' . $key . '.institute', $employee_education->institute) }}"
                                            placeholder="Enter institute name">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="group_department">Group/Department</label>
                                        <input type="text" max="200" class="form-control"
                                            name="education_infos[{{ $key }}][group_department]"
                                            value="{{ old('education_infos.' . $key . '.group_department', $employee_education->group_department) }}"
                                            placeholder="Enter Group/Department">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="education_board">Education Board</label>
                                        <input type="text" maxlength="200" class="form-control"
                                            name="education_infos[{{ $key }}][education_board]"
                                            value="{{ old('education_infos.' . $key . '.education_board', $employee_education->education_board) }}"
                                            placeholder="Enter Education board">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="passing_year">Passing Year</label>
                                        <input type="number" min="1900" max="2099" step="1"
                                            class="form-control" name="education_infos[{{ $key }}][passing_year]"
                                            value="{{ old('education_infos.' . $key . '.passing_year', $employee_education->passing_year) }}"
                                            placeholder="Enter passing year">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="result">Result</label>
                                        <input type="text" maxlength="200" class="form-control"
                                            name="education_infos[{{ $key }}][result]"
                                            value="{{ old('education_infos.' . $key . '.result', $employee_education->result) }}"
                                            placeholder="Enter result (GPA/CGPA)">
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else

                        <div class="row p-2 education-info">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="exam_name">Exam</label>
                                    {{ generateDropdown($exam_names, 'class="form-control" name="education_infos[0][exam_name]" ', old('education_infos.0.exam_name'), 'Select Option') }}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="institute">Institution</label>
                                    <input type="text" max="200" class="form-control"
                                        name="education_infos[0][institute]" value="{{ old('education_infos.0.institute') }}"
                                        placeholder="Enter institute name">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="group_department">Group/Department</label>
                                    <input type="text" max="200" class="form-control"
                                        name="education_infos[0][group_department]"
                                        value="{{ old('education_infos.0.group_department') }}"
                                        placeholder="Enter Group/Department">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="education_board">Education Board</label>
                                    <input type="text" maxlength="200" class="form-control"
                                        name="education_infos[0][education_board]"
                                        value="{{ old('education_infos.0.education_board') }}"
                                        placeholder="Enter Education board">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="passing_year">Passing Year</label>
                                    <input type="number" min="1900" max="2099" step="1" class="form-control"
                                        name="education_infos[0][passing_year]"
                                        value="{{ old('education_infos.0.passing_year') }}" placeholder="Enter passing year">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="result">Result</label>
                                    <input type="text" maxlength="200" class="form-control"
                                        name="education_infos[0][result]" value="{{ old('education_infos.0.result') }}"
                                        placeholder="Enter result (GPA/CGPA)">
                                </div>
                            </div>
                        </div>

                    @endif

                    <div id="append-field"></div>
                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <button type="button" id="plusBtn" class="btn btn-primary"><i
                                        class="fas fa-plus-circle"></i> Add</button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bank Details Section -->
                <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                    Bank Details
                </div>
                <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="bank_name">Bank Name</label>
                            <input type="text" value="{{ old('bank_name', $employee->bank_name) }}"
                                class="form-control" id="bank_name" name="bank_name" placeholder="Enter bank name">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="branch_name">Branch Name</label>
                            <input type="text" value="{{ old('branch_name', $employee->branch_name) }}"
                                class="form-control" id="branch_name" name="branch_name"
                                placeholder="Enter branch name">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="account_no">Account Number</label>
                            <input type="text" value="{{ old('account_no', $employee->account_no) }}"
                                class="form-control" id="account_no" name="account_no"
                                placeholder="Enter account number">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="account_type">Account Type</label>
                            <select class="form-control" id="account_type" name="account_type">
                                <option value="">-Select Option-</option>
                                <option value="Savings"
                                    {{ old('account_type', $employee->account_type) == 'Savings' ? 'selected' : '' }}>
                                    Savings</option>
                                <option value="Current"
                                    {{ old('account_type', $employee->account_type) == 'Current' ? 'selected' : '' }}>
                                    Current</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="bank_branch_code">Bank Branch Code</label>
                            <input type="text" value="{{ old('bank_branch_code', $employee->bank_branch_code) }}"
                                class="form-control" id="bank_branch_code" name="bank_branch_code"
                                placeholder="Enter bank branch code">
                        </div>
                    </div>
                </div>

                <!-- Work Details Section -->
                <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                    Work Details
                </div>
                <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="employee_type">Employee Type</label>
                            {{ generateDropdown($employee_types, 'class="form-control" name="employee_type" ', old('employee_type', $employee->employee_type_id), 'Select Option') }}
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="branch_id">Branch</label>
                            <input type="text" value="{{ $branches[$employee->branch_id] }}" class="form-control"
                                readonly>
                            <input type="hidden" name="branch_id" value="{{ $employee->branch_id }}" readonly>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="shift_id">Shift</label>
                            {{ generateDropdown($shifts, 'class="form-control" name="shift_id" ', old('shift_id', $employee->shift_id), 'Select Option') }}
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="designation_id">Designation</label>
                            {{ generateDropdown($designations, 'class="form-control" name="designation_id"', old('designation_id', $employee->designation), 'Select Designation') }}
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="department_id">Department</label>
                            {{ generateDropdown($departments, 'class="form-control" name="department_id"', old('department_id', $employee->department), 'Select Department') }}
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="joining_date">Joining Date</label>
                            <input type="date" class="form-control" id="joining_date" name="joining_date"
                                value="{{ old('joining_date', $employee->joining_date) }}" required>
                        </div>
                    </div>

                </div>

                <!-- Salary Details Section -->
                <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                    Salary Details
                </div>
                <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="salary">Salary</label>
                            <input type="number" step="0.01" value="{{ old('salary', round($employee->salary)) }}" class="form-control salary"
                                id="salary" name="salary">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="salary_grade">Salary Grade</label>
                            {{ generateDropdown($salary_grades, 'class="form-control salary_grade" id="salary_grade" name="salary_grade"', old('salary_grade', $employee->salary_grade_id), 'Select Grade') }}
                        </div>
                    </div>
                    @if (isset($employee->salaryGrade->salaryGradeRules))

                        @foreach ($employee->salaryGrade->salaryGradeRules as $gradeRule)
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="{{$gradeRule->salaryHead->code}}">{{$gradeRule->salaryHead->title}}</label>
                                    @php
                                        $value = $gradeRule->amount;
                                        $amount = $gradeRule->rule_type == "Percentage" ? ($employee->salary * ($value/100)) : $value;
                                    @endphp
                                    <input type="number" step="0.01" value="{{$amount}}" class="form-control {{$gradeRule->salaryHead->code}}"
                                        id="{{$gradeRule->salaryHead->code}}" name="{{$gradeRule->salaryHead->code}}"
                                        placeholder="Enter {{$gradeRule->salaryHead->title}}" readonly>
                                </div>
                            </div>
                        @endforeach
                    @else
                        @foreach ($salary_heads as $head)
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="{{$head->code}}">{{$head->title}}</label>
                                    <input type="number" step="0.01" value="" class="form-control" id="{{$head->code}}"
                                    name="{{$head->code}}" placeholder="Enter {{$head->title}}" readonly>
                                </div>
                            </div>
                        @endforeach
                    @endif

                </div>

                <div class="row mt-3 flex justify-content-end">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            let educationCount = {{ count($employee->employee_education) }};

            // Function to add event listener to remove buttons
            function addRemoveButtonListener() {
                $('.removeBtn').off('click').on('click', function() {
                    $(this).closest('.education-info').remove();
                });
            }

            // Call the function to set the event listeners for existing remove buttons
            addRemoveButtonListener();

            $('#plusBtn').click(function() {
                // Clone the first education info row
                const newEntry = $('.education-info').first().clone();

                // Clear the input values and reset the selects
                newEntry.find('input').val('');
                newEntry.find('select').prop('selectedIndex', 0);

                // Update the name attributes for the cloned inputs
                newEntry.find('input, select').each(function() {
                    const name = $(this).attr('name');
                    if (name) {
                        const newName = name.replace(/\[\d+\]/,
                        `[${educationCount}]`); // Update the index
                        $(this).attr('name', newName);
                    }
                });

                // Add a remove button
                const removeButton = `
                    <div class="col-md-12">
                        <div class="form-group">
                            <button type="button" class="btn btn-sm btn-danger removeBtn">
                                <i class="fas fa-minus-circle"></i> Remove
                            </button>
                        </div>
                    </div>`;
                newEntry.prepend(removeButton);

                // Append the new entry to the form
                $('#append-field').append(newEntry);

                // Increment the educationCount
                educationCount++;

                // Reassign the event listener for the new remove button
                addRemoveButtonListener();
            });

            $('.salary_grade, #salary').on('change keyup', function(event) {
                event.preventDefault();
                var id = $('.salary_grade').val();
                var salary = $('#salary').val();

                $.ajax({
                    type: 'GET',
                    url: '{{ route("salary-grades.edit", ":id") }}'.replace(':id', id),
                    success: function(data) {

                        $.each(data.salary_grade_rules, function(index, value) {
                            let headValue = value.rule_type == "Percentage" ? (salary * (value.amount / 100)) : value.amount;
                            $('#' + value.salary_head.code).empty().val(customRound(headValue,2));
                        });
                    }
                });
            });
        });



        const input = document.querySelector('.image-uploader__input');
        const previewImage = document.querySelector('.image-uploader__preview-image');

        input.addEventListener('change', () => {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = (event) => {
                previewImage.src = event.target.result;
            };

            reader.readAsDataURL(file);
        });

        $('#copyAddress').on('change', function() {
            if ($(this).is(':checked')) {
                // Copy division value and trigger change event
                const divisionId = $('#present_division_id').val();
                $('#permanent_division_id').val(divisionId).trigger('change');
                
                // Wait for districts to load before copying district
                setTimeout(() => {
                    const districtId = $('#present_district_id').val();
                    $('#permanent_district_id').val(districtId).trigger('change');
                    
                    // Wait for upazilas to load before copying upazila
                    setTimeout(() => {
                        const upazilaId = $('#present_upazila_id').val();
                        $('#permanent_upazila_id').val(upazilaId).trigger('change');
                        
                        // Wait for unions to load before copying union
                        setTimeout(() => {
                            const unionId = $('#present_union_id').val();
                            $('#permanent_union_id').val(unionId);
                            
                            // Copy textarea content
                            const address = $('#present_address').val();
                            $('#permanent_address').val(address);
                        }, 500);
                    }, 500);
                }, 500);
            }
        });
    </script>

@endsection
