@extends('layouts.master')
@section('content')
<div class="card mb-3">
    <div class="card-body card__head">
        <form method="GET" action="{{ route('employees.index') }}" class="row">
            <div class="col-lg-3">
                <div class="form-group mb-0">
                    @component('components.employee_search', [
                        'employee_name' => $employee_name ?? '',
                        'employee_code' => request()->employee_code ?? '',
                        'required' => '',
                    ])
                    @endcomponent
                </div>
            </div>
            <div class="form-group col-lg-3">
                {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
            </div>
            <div class="form-group col-lg-2 col-md-2">
                <button type="submit" class="btn btn-info">Search</button>
            </div>
        </form>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Employee List</h6>
        <div class="m-0 float-right">
            <a href="{{ route('employees.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>Emp. ID</th>
                            <th>Profile</th>
                            <th>Name</th>
                            <th>Gender</th>
                            <th>Mobile Number</th>
                            <th>Joining Date</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                <tbody>
                @if($employees->isNotEmpty())
                @foreach($employees as $employee)
                    <tr>
                        <td>{{$employee->employee_code}}</td>
                        <td><img width="50" src="{{$employee->employee_photo ? asset($employee->employee_photo):asset('/default/profile.png')}}"/></td>
                        <td>{{$employee->first_name}} {{$employee->last_name}}</td>
                        <td>{{$employee->gender}}</td>
                        <td>{{$employee->mobile_number}}</td>
                        <td>{{$employee->joining_date}}</td>
                        <td class="d-flex justify-content-start">
                            <a href="{{ route('employees.show', $employee->id) }}" class="btn btn-sm btn-soft-success"><i class="fas fa-eye"></i></a>
                            <a href="{{ route('employees.edit', $employee->id) }}" class="btn btn-sm btn-soft-info mx-1"><i class="fas fa-edit"></i></a>
                            <form action="{{ route('employees.destroy', $employee->id) }}" method="POST" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr><td colspan="7" class="text-center">No data available in table</td></tr>
                    @endif
                </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

