@extends('layouts.master')
@section('content')

    <div class="card">
        <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Employee</h5> <a href="{{ route('employees.index') }}" class="btn btn-sm btn-primary">Employee List</a>
        </div>

        <div class="card-body">

            @csrf
            @method('PUT')

            <!-- Personal Info Section -->
            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Personal Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" value="{{ old('first_name', $employee->first_name) }}"
                                    class="form-control" id="first_name" name="first_name"
                                    placeholder="Enter first name" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" value="{{ old('last_name', $employee->last_name) }}"
                                    class="form-control" id="last_name" name="last_name" placeholder="Enter last name"
                                    required>
                                @error('last_name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="gender">Gender</label>
                                {{ generateDropdown($genderOptions, 'class="form-control" name="gender"', old('gender', $employee->gender), 'Select Option') }}
                                @error('gender')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="date_of_birth">Date Of Birth *: </label>
                                <input type="date" class="form-control" name="date_of_birth"
                                    value="{{ old('date_of_birth', $employee->date_of_birth) }}" required>
                                @error('date_of_birth')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="blood_group">Blood Group : </label>
                                {{ generateDropdown($bloodGroupOptions, 'class="form-control" name="blood_group"', old('blood_group', $employee->blood_group), 'Select Option') }}
                                @error('blood_group')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="religion">Religion *: </label>
                                {{ generateDropdown($religionOptions, 'class="form-control" name="religion" required', old('religion', $employee->religion)) }}
                                @error('religion')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="image-uploader">
                        <label for="image">Profile Image : </label>
                        <label for="imageFile" class="image-uploader__label">
                            <div class="image-uploader__icon-overlay">
                                <i class="fas fa-cloud-upload-alt"></i>
                            </div>
                            @php
                                $employee_photo = $employee->employee_photo;
                                $path = $employee_photo ? $employee_photo : 'assets/img/man.png';
                            @endphp
                            <img src="{{ asset($path) }}" alt="Preview image"
                                class="image-uploader__preview-image img-thumbnail"
                                style="width: 140px; height: 140px;">
                            <input type="file" name="profile_image" class="image-uploader__input" id="imageFile"
                                accept="image/*">
                        </label>
                        @error('profile_image')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="father_name">Father Name</label>
                        <input type="text" value="{{ old('father_name', $employee->father_name) }}"
                            class="form-control" id="father_name" name="father_name" placeholder="Enter father name">
                        @error('father_name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="mother_name">Mother Name</label>
                        <input type="text" value="{{ old('mother_name', $employee->mother_name) }}"
                            class="form-control" id="mother_name" name="mother_name" placeholder="Enter mother name">
                        @error('mother_name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="marital_status">Marital Status</label>
                        {{ generateDropdown($marital_status, 'class="form-control" name="marital_status"', old('marital_status', $employee->marital_status), 'Select Option') }}
                        @error('marital_status')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="spaous_name">Spaous Name</label>
                        <input type="text" class="form-control" id="spaous_name" name="spaous_name"
                            value="{{ old('spaous_name', $employee->spaous_name) }}" placeholder="Enter spaous name">
                        @error('spaous_name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label for="present_address">Present Address</label>
                        <textarea class="form-control" id="present_address" name="present_address" rows="2"
                            placeholder ="Enter present address">{{ old('present_address', $employee->present_address) }}</textarea>
                        @error('present_address')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="permanent_address">Permanent Address</label>
                        <textarea class="form-control" id="permanent_address" name="permanent_address" rows="2"
                            placeholder="Enter permanent address">{{ old('permanent_address', $employee->permanent_address) }}</textarea>
                        @error('permanent_address')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="mobile_number">Mobile Number</label>
                        <input type="text" class="form-control" id="mobile_number" name="mobile_number"
                            value="{{ old('mobile_number', $employee->mobile_number) }}"
                            placeholder="Enter mobile number">
                        @error('mobile_number')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="emergency_number">Emergency Number</label>
                        <input type="text" class="form-control" id="emergency_number" name="emergency_number"
                            value="{{ old('emergency_number', $employee->emergency_number) }}"
                            placeholder="Enter Emergency Number">
                        @error('emergency_number')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" class="form-control" id="email" name="email"
                            value="{{ old('email', $employee->email) }}" placeholder="Enter Email">
                        @error('email')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="identity_type">Identity Type</label>
                        <select name="identity_type" class="form-control">
                            <option value="">-Select Option-</option>
                            <option value="nid"
                                {{ old('identity_type', $employee->identity_type) == 'nid' ? 'selected' : '' }}>NID
                            </option>
                            <option value="passport"
                                {{ old('identity_type', $employee->identity_type) == 'passport' ? 'selected' : '' }}>
                                Passport</option>
                            <option value="driving-licence"
                                {{ old('identity_type', $employee->identity_type) == 'driving-licence' ? 'selected' : '' }}>
                                Driving Licence</option>
                        </select>
                        @error('identity_type')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="identity_no">Identity No</label>
                        <input type="text" class="form-control" id="identity_no" name="identity_no"
                            value="{{ old('identity_no', $employee->identity_no) }}" placeholder="Enter Identity No">
                        @error('identity_no')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="roles">Role</label>
                        @php
                            $selectedRole = $employee->user->user_type ?? '';
                        @endphp
                        {{ generateDropdown($roles, 'class="form-control" name="roles" ', old('roles', $selectedRole), 'Select Option') }}
                        @error('roles')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <input type="hidden" name="user_type" value="{{ $employee->user_type }}">

            </div>

            <!-- Education Info Section -->
            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Education Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                @foreach ($employee->employee_education as $key => $employee_education)
                    <div class="row p-2 education-info border m-2">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="exam_name">Exam</label>
                                <input type="text" class="form-control" value="{{$exam_names[$employee_education->exam_name]}}" disabled>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="institute">Institution</label>
                                <input type="text" max="200" class="form-control"
                                    name="education_infos[{{ $key }}][institute]"
                                    value="{{ old('education_infos.' . $key . '.institute', $employee_education->institute) }}"
                                    placeholder="Enter institute name" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="group_department">Group/Department</label>
                                <input type="text" max="200" class="form-control"
                                    name="education_infos[{{ $key }}][group_department]"
                                    value="{{ old('education_infos.' . $key . '.group_department', $employee_education->group_department) }}"
                                    placeholder="Enter Group/Department" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="education_board">Education Board</label>
                                <input type="text" maxlength="200" class="form-control"
                                    name="education_infos[{{ $key }}][education_board]"
                                    value="{{ old('education_infos.' . $key . '.education_board', $employee_education->education_board) }}"
                                    placeholder="Enter Education board" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="passing_year">Passing Year</label>
                                <input type="number" min="1900" max="2099" step="1"
                                    class="form-control" name="education_infos[{{ $key }}][passing_year]"
                                    value="{{ old('education_infos.' . $key . '.passing_year', $employee_education->passing_year) }}"
                                    placeholder="Enter passing year" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="result">Result</label>
                                <input type="text" maxlength="200" class="form-control"
                                    name="education_infos[{{ $key }}][result]"
                                    value="{{ old('education_infos.' . $key . '.result', $employee_education->result) }}"
                                    placeholder="Enter result (GPA/CGPA)" required>
                            </div>
                        </div>
                    </div>
                @endforeach


            </div>

            <!-- Bank Details Section -->
            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Bank Details
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="bank_name">Bank Name</label>
                        <input type="text" value="{{ old('bank_name', $employee->bank_name) }}"
                            class="form-control" id="bank_name" name="bank_name" placeholder="Enter bank name">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="branch_name">Branch Name</label>
                        <input type="text" value="{{ old('branch_name', $employee->branch_name) }}"
                            class="form-control" id="branch_name" name="branch_name"
                            placeholder="Enter branch name">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="account_no">Account Number</label>
                        <input type="text" value="{{ old('account_no', $employee->account_no) }}"
                            class="form-control" id="account_no" name="account_no"
                            placeholder="Enter account number">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="account_type">Account Type</label>
                        <select class="form-control" id="account_type" name="account_type">
                            <option value="">-Select Option-</option>
                            <option value="Savings"
                                {{ old('account_type', $employee->account_type) == 'Savings' ? 'selected' : '' }}>
                                Savings</option>
                            <option value="Current"
                                {{ old('account_type', $employee->account_type) == 'Current' ? 'selected' : '' }}>
                                Current</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="bank_branch_code">Bank Branch Code</label>
                        <input type="text" value="{{ old('bank_branch_code', $employee->bank_branch_code) }}"
                            class="form-control" id="bank_branch_code" name="bank_branch_code"
                            placeholder="Enter bank branch code">
                    </div>
                </div>
            </div>

            <!-- Work Details Section -->
            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Work Details
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="employee_type">Employee Type</label>

                        {{ generateDropdown($employee_types, 'class="form-control" name="employee_type" ', old('employee_type', $employee->employee_type), 'Select Option') }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="branch_id">Branch</label>
                        {{ generateDropdown($branches, 'class="form-control" name="branch_id" ', old('branch_id', $employee->branch_id), 'Select Option') }}
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="shift_id">Shift</label>
                        {{ generateDropdown($shifts, 'class="form-control" name="shift_id" ', old('shift_id', $employee->shift_id), 'Select Option') }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="designation">Designation</label>
                        {{ generateDropdown($designations, 'class="form-control" name="designation"', old('designation', $employee->designation), 'Select Designation') }}
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="department">Department</label>
                        {{ generateDropdown($departments, 'class="form-control" name="department"', old('department', $employee->department), 'Select Department') }}
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="joining_date">Joining Date</label>
                        <input type="date" class="form-control" id="joining_date" name="joining_date"
                            value="{{ old('joining_date', $employee->joining_date) }}" required>
                    </div>
                </div>

            </div>

            <!-- Salary Details Section -->
            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Salary Details
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="salary">Salary</label>
                        <input type="number" step="0.01" value="{{ old('salary', round($employee->salary)) }}" class="form-control"
                            id="salary" name="salary">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="salary_grade">Salary Grade *</label>
                        {{ generateDropdown($salary_grades, 'class="form-control" name="salary_grade"', old('salary_grade', $employee->salary_grade_id), 'Select Grade') }}
                    </div>
                </div>
                @if (isset($employee->salaryGrade->salaryGradeRules))
                    @foreach ($employee->salaryGrade->salaryGradeRules as $gradeRule)
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="{{$gradeRule->salaryHead->code}}">{{$gradeRule->salaryHead->title}}</label>
                                @php
                                    $value = $gradeRule->amount;
                                    $amount = $gradeRule->rule_type == "Percentage" ? ($employee->salary * ($value/100)) : $value;
                                @endphp
                                <input type="number" step="0.01" value="{{$amount}}" class="form-control {{$gradeRule->salaryHead->code}}"
                                    id="{{$gradeRule->salaryHead->code}}" name="{{$gradeRule->salaryHead->code}}"
                                    placeholder="Enter {{$gradeRule->salaryHead->title}}" readonly>
                            </div>
                        </div>
                    @endforeach
                @endif

            </div>

        </div>
    </div>

@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('input, select, textarea').prop('disabled', true);
        });
    </script>
@endpush



