@extends('layouts.master')
@section('content')
<div class="row">
  <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Employee Type List</h6>
            <div class="m-0 float-right">
                <button class="btn btn-sm btn-primary" id="add-student-btn" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive" >
                    <table class="table">
                        <thead class="thead-light">
                            <tr>
                                <th>SN</th>
                                <th>Employee Type</th>
                                <th>Status</th>
                                <th class="action__col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        @if($types->isNotEmpty())    
                        @foreach($types as $type)
                            <tr>
                                <td>{{$type->id}}</td>
                                <td>{{$type->emp_type}}</td>
                                <td>{{ $type->status?'active':'inactive'}}</td>
                                <td  class="d-flex justify-content-start">
                                <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn" data-toggle="modal" data-target="#dataEditModal" data-emptype="{{$type->emp_type}}" data-status="{{$type->status}}" data-id="{{$type->id}}"><i class="fas fa-edit"></i></button>
                                        <form action="{{ route('employee_type.destroy', $type->id) }}" method="POST" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                                        </form>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr><td colspan="4" class="text-center">No data available in table</td></tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
      <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <form role="form" id='myForm' method="POST" action="{{ route('employee_type.store') }}">
            @csrf
          <!-- Modal Header -->
          <div class="modal-header">
            <div class="float-start">
                <h4 class="modal-title" id="myModalLabel">Add Employee Type</h4>
            </div>
            <div class="float-end d-none">
                <button type="button" class="close" data-dismiss="modal">
              <span aria-hidden="true">&times;</span>
              <span class="sr-only">Close</span>
            </button>
            </div>
          </div>
          <!-- Modal Body -->
          <div class="modal-body">
            <p class="statusMsg"></p>            
            <div class="form-group">
                <label for="emp_type">Employee Type <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="emp_type" name="emp_type" required>
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status">
                    <option value="1">Active</option>
                    <option value="0">Inactive</option>
                </select>
            </div>        
          </div>
          <!-- Modal Footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary submitBtn">Add New</button>
          </div>
          </form>
        </div>
      </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
      <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <form role="form" id='myForm' method="POST" action="{{ route('employee_type.update') }}">
            @csrf
          <!-- Modal Header -->
          <div class="modal-header">
            <div class="float-start">
                <h4 class="modal-title" id="myModalLabel">Edit Employee Type</h4>
            </div>
            <div class="float-end d-none">
                <button type="button" class="close" data-dismiss="modal">
              <span aria-hidden="true">&times;</span>
              <span class="sr-only">Close</span>
            </button>
            </div>
          </div>
          <!-- Modal Body -->
          <div class="modal-body">
            <p class="statusMsg"></p>  
                <input type="hidden" id="id" name="id">          
            <div class="form-group">
                <label for="emp_type">Employee Type <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="emp_type" name="emp_type" required>
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status">
                    <option value="1" >Active</option>
                    <option value="0" >Inactive</option>
                </select>
            </div>
          </div>
          <!-- Modal Footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary submitBtn">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>
    <!-- modal end -->
@stop
@section('scripts')
<script type="text/javascript">
    $('#dataEditModal').on('show.bs.modal', function (event) {
      var button = $(event.relatedTarget) // Button that triggered the modal
      var emptype = button.data('emptype')
      var status = button.data('status')
      var id = button.data('id')
      var modal = $(this)
      modal.find('#emp_type').val(emptype)
      modal.find("#status option[value="+status+"]").prop("selected", true);
      modal.find('#id').val(id)
    })
</script>
@endsection