@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card mt-4" id="app">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Leave Request</h6>
                <div class="m-0 float-right">
                    <a href="{{ route('leaves-request.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Leave Reason</th>
                                    <th>Leave Type</th>
                                    <th>From Date</th>
                                    <th>To Date</th>
                                    <th>Requested Days</th>
                                    <th>Approved Days</th>
                                    <th class="text-center">Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($leave_list->isNotEmpty())
                                    @foreach ($leave_list as $leave)
                                        <tr>
                                            <td>{{ $leave->id }}</td>
                                            <td>{{ $leave->leave_reason }}</td>
                                            <td>{{ $leave->leaveType->name }}</td>
                                            <td>{{ $leave->from_date }}</td>
                                            <td>{{ $leave->to_date }}</td>
                                            <td>{{ $leave->requested_days }}</td>
                                            <td>{{ $leave->approved_days ?? "-" }}</td>
                                            <td class="text-center">{!! getStatusBadge($leave->status) !!}</td>
                                            <td class="d-flex justify-content-start">
                                                <a href="{{route('leaves-request.edit', $leave->id)}}" class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"><i class="fas fa-edit"></i></a>
                                                <form action="{{ route('leaves.destroy', $leave->id) }}" method="POST"
                                                    style="display: inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-soft-danger"
                                                        onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="10" class="text-center">No data available in table</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@push('scripts')
<script>
    const app = Vue.createApp({
        data() {
            return {
                message: 'Hello from Vue 3!',
                inputValue: ''
            }
        },
        methods: {
            changeMessage() {
                this.message = 'Message changed!';
            }
        }
    });

    app.mount('#app');
</script>
@endpush
