@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Leave Type</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal" data-target="#dataModal">Add
                        New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Type Name</th>
                                    <th>Short Name</th>
                                    <th>Allocated Leave</th>
                                    <th class="text-center">Status</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($leave_types->isNotEmpty())
                                @foreach ($leave_types as $type)
                                    <tr>
                                        <td>{{ $type->id }}</td>
                                        <td>{{ $type->name }}</td>
                                        <td>{{ $type->short_name }}</td>
                                        <td>{{ $type->allocated_days }}</td>
                                        <td class="text-center">{!! getStatusBadge($type->status) !!}</td>
                                        <td class="d-flex justify-content-start">
                                            <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn" data-toggle="modal"
                                                data-target="#dataModal" data-type_name="{{ $type->name }}"
                                                data-short_name="{{ $type->short_name }}" data-id="{{ $type->id }}"
                                                data-allocated_days="{{ $type->allocated_days }}" data-description="{{ $type->description }}"><i class="fas fa-edit"></i></button>
                                            <form action="{{ route('leave-type.destroy', $type->id) }}" method="POST"
                                                style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger"
                                                    onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @else
                                <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                                @endif
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <!-- Single Modal -->
    <div class="modal fade" id="dataModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('leave-type.store') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel"></h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="name">Type Name</label> <span class="text-danger">*</span>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter leave type name">
                        </div>
                        <div class="form-group">
                            <label for="short_name">Short Name</label> <span class="text-danger">*</span>
                            <input type="text" class="form-control short_name" id="short_name" name="short_name" placeholder="This will generate automaiically" readonly>
                        </div>
                        <div class="form-group">
                            <label for="allocated_days">Allocated Days</label> <span class="text-danger">*</span>
                            <input type="text" class="form-control" id="allocated_days" name="allocated_days" placeholder="Enter allocated days">
                        </div>
                        <div class="form-group">
                            <label for="allocated_days">Description (Optional)</label>
                            <textarea name="description" class="form-control description" id="description" cols="2" rows="2" placeholder="Enter description"></textarea>
                        </div>
                        {{-- <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div> --}}
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {
        // ...

        // Bind a show event to the #dataModal modal
        $('#dataModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget) // Button that triggered the modal
            var type_name = button.data('type_name')
            var short_name = button.data('short_name')
            var allocated_days = button.data('allocated_days')
            var description = button.data('description')
            var status = button.data('status')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#name').val(type_name)
            modal.find('#short_name').val(short_name)
            modal.find('#allocated_days').val(allocated_days)
            modal.find('#description').val(description)
            // modal.find("#status option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)

            // Set the modal title and submit button text based on the action
            if (id) {
                modal.find('.modal-title').text('Edit Leave Type')
                modal.find('.submitBtn').text('Update')
                modal.find('#myForm').attr('action', '{{ route('leave-type.update', ':id') }}'.replace(':id', id));
            } else {
                modal.find('.modal-title').text('Add Leave Type')
                modal.find('.submitBtn').text('Add New')
                modal.find('#myForm').attr('action', '{{ route('leave-type.store') }}');
            }
        });

        $('#name').on('input', function() {
            var typeName = $(this).val();
            var shortName = generateShortName(typeName);
            $('#short_name').val(shortName);
        });

        function generateShortName(name) {
            // If empty string, return empty
            if (!name) return '';

            // Split the string by spaces and special characters
            var words = name.split(/[\s-]+/);

            // Get first letter of each word and convert to uppercase
            var shortName = words
                .map(word => word.charAt(0).toUpperCase())
                .join('');

            // Limit to maximum 5 characters
            return shortName.substring(0, 5);
        }
    });
</script>
@endsection

</```
rewritten_file>
