@extends('layouts.master')
@section('content')
    <div class="card" id="app">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Edit Leave</h6>
            <div class="m-0 float-right">
                <a href="{{ route('leaves.index') }}" class="btn btn-sm btn-primary" id="add-student-btn">Leaves</a>
            </div>
        </div>
        <div class="card-body">
            <div class="row justify-content-center">

                <form class="col-md-6" action="{{ route('leaves.update', $leave->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT') <!-- Indicate that this is an update request -->
                    <div class="form-group">
                        <label for="leave_type">Leave Type:</label>
                        <select name="leave_type" id="leave_type" class="form-control">
                            @foreach($leaveTypes as $leaveType)
                                <option value="{{ $leaveType->id }}" {{ $leaveType->id == $leave->leave_type ? 'selected' : '' }}>
                                    {{ $leaveType->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="from_date">From Date:</label>
                        <input type="text" name="from_date" v-model="from_date" id="from_date" class="form-control date360" value="{{ $leave->from_date }}">
                    </div>

                    <div class="form-group">
                        <label for="to_date">To Date:</label>
                        <input type="text" name="to_date" v-model="to_date" id="to_date" class="form-control date360" value="{{ $leave->to_date }}">
                    </div>

                    <div class="form-group">
                        <label for="requested_days">Number of days:</label>
                        <input type="number" name="requested_days" v-model="requested_days" id="requested_days" class="form-control" placeholder="Number of leave days" readonly>
                    </div>

                    <div class="form-group">
                        <label for="leave_reason">Leave Reason:</label>
                        <textarea name="leave_reason" id="leave_reason" class="form-control" placeholder="Enter Leave Reason">{{ $leave->leave_reason }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="attachment">Attachment</label>
                        <div class="custom-file">
                            <input type="file" name="reference_file" class="custom-file-input" id="reference_file">
                            <label class="custom-file-label" for="reference_file">Choose file</label>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Update Leave</button>
                </form>
            </div>
        </div>
    </div>

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        const today = new Date();
        $('.date360').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,      
            todayHighlight: true, 
        });
    })


    const app = Vue.createApp({
        data() {
            return {
                from_date: '{{ $leave->from_date }}',
                to_date: '{{ $leave->to_date }}',
                requested_days: 0
            };
        },
        watch: {
            from_date(newVal) {
                this.calculateDays();
            },
            to_date(newVal) {
                this.calculateDays();
            }
        },
        methods: {
            calculateDays() {
                if (this.from_date && this.to_date) {
                    const from = new Date(this.from_date);
                    const to = new Date(this.to_date);
                    const timeDifference = to - from;
                    const dayDifference = Math.ceil(timeDifference / (1000 * 3600 * 24));
                    this.requested_days = dayDifference >= 0 ? dayDifference + 1 : 0;
                } else {
                    this.requested_days = 0;
                }
            }
        },
        mounted() {
            this.calculateDays(); // Calculate days on mount
        }
    });

    app.mount('#app');
</script>
@endsection
