@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card mt-4" id="app">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Leave List</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#dataStoreModal">Add New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Leave Reason</th>
                                    <th>Leave Type</th>
                                    <th>From Date</th>
                                    <th>To Date</th>
                                    <th>Request Days</th>
                                    <th class="text-center">Status</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($leave_list->isNotEmpty())
                                @foreach ($leave_list as $leave)
                                    <tr>
                                        <td>{{ $leave->id }}</td>
                                        <td>{{ $leave->leave_reason }}</td>
                                        <td>{{ $leave->leaveType->name }}</td>
                                        <td>{{ view_date_format($leave->from_date) }}</td>
                                        <td>{{ view_date_format($leave->to_date )}}</td>
                                        <td>{{ $leave->requested_days }}</td>
                                        <td class="text-center">{!! getStatusBadge($leave->status) !!}</td>
                                        <td class="d-flex justify-content-start">
                                            @if ($leave->status!=Status::PENDING)
                                            <a href="{{route('leaves.details', $leave->id)}}" class="btn btn-sm btn-primary mr-1" id="add-student-btn">Details</a>
                                            @else
                                            <button class="btn btn-sm btn-soft-info edit-expense-btn mr-1" data-toggle="modal"
                                                data-target="#dataEditModal" data-id="{{ $leave->id }}"
                                                data-leave_reason="{{ $leave->leave_reason }}" data-leave_type="{{ $leave->leaveType->name }}" data-leave_type_id="{{ $leave->leaveType->id }}"
                                                data-from_date="{{ view_date_format($leave->from_date) }}" data-to_date="{{ view_date_format($leave->to_date) }}"
                                                data-requested_days="{{ $leave->requested_days }}" >
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            @endif
                                            <form action="{{ route('leaves.destroy', [$leave->id]) }}"
                                                method="POST"
                                                onsubmit="return confirm('Are you sure you want to delete this')"
                                                style="display:inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @else
                                <tr><td colspan="10" class="text-center">No data available in table</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- create Modal -->
<div class="modal fade" id="dataStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="{{ route('leaves.store') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Leave</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="leave_type">Leave Type</label>
                                <select name="leave_type" id="leave_type" class="form-control">
                                    @foreach($leaveTypes as $leaveType)
                                        <option value="{{ $leaveType->id }}">
                                            {{ $leaveType->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="requested_days">Number of days</label>
                                <input type="number" name="requested_days" v-model="requested_days" id="requested_days" class="form-control" placeholder="Number of leave days" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="from_date">From Date</label>
                                <input type="text" name="from_date" v-model="from_date" id="from_date" class="form-control date3601" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="to_date_edit">To Date</label>
                                <input type="text" name="to_date" v-model="to_date" id="to_date_edit" class="form-control date3602">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="attachment">Attachment</label>
                                <div class="custom-file">
                                    <input type="file" name="reference_file" class="custom-file-input" id="reference_file">
                                    <label class="custom-file-label" for="reference_file">Choose file</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="leave_reasos">Leave Reason</label>
                                <textarea name="leave_reason" id="leave_reasos" class="form-control" placeholder="Enter Leave Reason"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary submitBtn">Add New</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->

<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm2' method="POST" action="{{ route('leaves.update') }}" enctype="multipart/form-data">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel2">Edit Leave</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="leave_type_edit">Leave Type</label>
                                <select name="leave_type" id="leave_type_edit" class="form-control">
                                    @foreach($leaveTypes as $leaveType)
                                        <option value="{{ $leaveType->id }}">
                                            {{ $leaveType->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="requested_days_edit">Number of days</label>
                                <input type="number" name="requested_days" v-model="requested_days" id="requested_days_edit" class="form-control" placeholder="Number of leave days" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="from_date_edit">From Date</label>
                                <input type="text" name="from_date" v-model="from_date" id="from_date_edit" class="form-control date3603" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="to_date_edit">To Date</label>
                                <input type="text" name="to_date" v-model="to_date" id="to_date_edit" class="form-control date3604">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="attachment">Attachment</label>
                                <div class="custom-file">
                                    <input type="file" name="reference_file" class="custom-file-input" id="reference_file">
                                    <label class="custom-file-label" for="reference_file">Choose file</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="leave_reason_edit">Leave Reason</label>
                                <textarea name="leave_reason" id="leave_reason_edit" class="form-control" placeholder="Enter Leave Reason"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary submitBtn">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->
@endsection

@push('scripts')
<script>
    const app = Vue.createApp({
        data() {
            return {
                message: 'Hello from Vue 3!',
                inputValue: ''
            }
        },
        methods: {
            changeMessage() {
                this.message = 'Message changed!';
            }
        }
    });

    app.mount('#app');
</script>
@endpush



@section('scripts')
        <script type="text/javascript">
            const today = new Date();
            $('.date3601').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            }).datepicker('setDate', today);

            $('.date3602').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            }).datepicker('setDate', today);


            $('.date3603').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            })

            $('.date3604').datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true,
            })

            $('#dataEditModal').on('hidden.bs.modal', function () {
                // Reset the form inside the modal
                $(this).find('form')[0].reset();
                // Optionally, reset specific fields manually (in case you're setting them dynamically)
                $(this).find('.form-control').val('');
                $(this).find('.form-control-sm').val('');
            });

            $('#dataEditModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget)
                var id = button.data('id')
                var leave_reason = button.data('leave_reason')
                var leave_type = button.data('leave_type')
                var from_date = button.data('from_date')
                var to_date = button.data('to_date')
                var requested_days = button.data('requested_days')
                var leave_type_id = button.data('leave_type_id')
                var modal = $(this)
                // Populate the modal fields with data only if they are empty
                if (!modal.find('#id').val()) {
                    modal.find('#id').val(id)
                }
                if (!modal.find('#leave_reason_edit').val()) {
                    modal.find('#leave_reason_edit').val(leave_reason)
                }
                if (!modal.find('#requested_days_edit').val()) {
                    modal.find('#requested_days_edit').val(requested_days)
                }
                if (!modal.find('#from_date_edit').val()) {
                    modal.find('#from_date_edit').val(from_date)
                }
                if (!modal.find('#to_date_edit').val()) {
                    modal.find('#to_date_edit').val(to_date)
                }
                if (!modal.find('#leave_reason_edit').val()) {
                    modal.find('#leave_reason_edit').val(account_number)
                }
                // Select the option corresponding to leave_type_id in the dropdown
                modal.find("#leave_type_edit option[value=" + leave_type_id + "]").prop("selected", true);
            });
        </script>
    @endsection
