@extends('layouts.master')
@section('content')

<div class="card">
    <div class="card-body card__head">
        <form method="GET" action="{{ route('monthly-salary.create') }}" class="row">
            <div class="col-lg-3 col-md-3">
                <div class="form-group mb-0">
                    @component('components.employee_search', [
                        'employee_name' => $employee_name ?? '',
                        'employee_code' => request()->employee_code ?? '',
                        'required' => '',
                    ])
                    @endcomponent
                </div>
            </div>
            <div class="form-group col-lg-3 col-md-3">
                {{ generateDropdown($academicYears, 'class="form-control academic_year" id="academic_year" name="academic_year" required', request()->query('academic_year') ?? $defaultYear, "Select Year") }}
            </div>
            <div class="form-group col-lg-3 col-md-3">
                {{ generateDropdown(config('months'), 'class="form-control month" id="month" name="month" required', request()->query('month') ?? date('m'), "Select Month") }}
            </div>

            <div class="form-group col-lg-3 col-md-3">
                <button type="submit" class="btn btn-info">Search</button>
            </div>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Generate Salary</h6>
        <div class="m-0 float-right">
            <a href="{{ route('monthly-salary.index') }}" class="btn btn-sm btn-primary">Salary Sheet</a>
        </div>
    </div>

    <div class="card-body">
        <form action="{{ route('monthly-salary.store') }}" method="POST" id="salary-form">
            @csrf
            <input type="hidden" name="month" value="{{request()->month ?? ""}}">
            <input type="hidden" name="academic_year" value="{{request()->academic_year ?? ""}}">
            <input type="hidden" name="employee_code" value="{{request()->employee_code ?? ""}}">
            <div class="row">

                @if ($employeeSalaries)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead class="thead-light">
                                <tr>
                                    <th><input type="checkbox" id="master-checkbox"></th>
                                    <th>Emp. Code</th>
                                    <th>Name</th>
                                    <th>Mobile Number</th>
                                    <th>Joining Date</th>
                                    <th>Payment Status</th>
                                    @foreach ($salary_heads as $head)
                                        <th>{{ $head->title }}</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($employeeSalaries as $employee)
                                    @if($employee?->activeSalary?->salaryGrade?->salaryGradeRules)
                                        <tr>
                                            <td>
                                                <input type="checkbox" name="selected_employees[]" value="{{ $employee->id }}" class="employee-checkbox">
                                            </td>
                                            <td>{{ $employee->employee_code }}</td>
                                            <td>{{ $employee->name }}</td>
                                            <td>{{ $employee->mobile_number }}</td>
                                            <td>{{ $employee->joining_date }}</td>
                                            <td>{!! getStatusBadge($employee->payment_status) !!}</td>
                                            @foreach ($employee?->activeSalary?->salaryGrade?->salaryGradeRules as $gradeRules)
                                                @if ($gradeRules->rule_type == 'Percentage')
                                                    <td>{{ ($employee?->activeSalary?->amount * $gradeRules?->amount)/100 }}</td>
                                                @else
                                                    <td>{{ $employee?->activeSalary?->amount }}</td>
                                                @endif
                                            @endforeach
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="col-lg-12 text-center">
                        <h4>Please search above and then process salary.</h4>
                    </div>
                @endif
            </div>
            @if ($employeeSalaries)
            <div class="row">
                <div class="col-md-12 d-flex justify-content-end my-3">
                    {{-- <button type="button" class="btn btn-primary mr-1" id="draft-btn">Draft & Print</button> --}}
                    <button type="button" class="btn btn-success" id="save-btn">Save & Print</button>
                </div>
            </div>
            @endif
        </form>
    </div>
</div>
@endsection

@push('scripts')
    <script>
         // Master checkbox to select/deselect all employee checkboxes
        document.getElementById('master-checkbox').addEventListener('click', function () {
            const checkboxes = document.querySelectorAll('.employee-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
        });

        // Form submission for Draft & Save buttons
        const form = document.getElementById('salary-form');

        // document.getElementById('draft-btn').addEventListener('click', function () {
        //     if (validateForm()) {
        //         form.submit();
        //     }
        // });

        document.getElementById('save-btn').addEventListener('click', function () {
            if (validateForm()) {
                form.action = '{{ route('monthly-salary.store') }}';  // Change form action for save
                form.submit();
            }
        });

        // Ensure at least one employee is selected before submission
        function validateForm() {
            const checkedEmployees = document.querySelectorAll('.employee-checkbox:checked');
            if (checkedEmployees.length === 0) {
                alert('Please select at least one employee.');
                return false;
            }
            return true;
        }
    </script>
@endpush
