@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Edit Employee Salary</h5> <a href="{{ route('employee-salary.index') }}" class="btn btn-sm btn-primary">Employee Salary List</a>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger m-3">
            <ul class="m-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="card-body">
        <form action="{{ route('employee-salary.update',$salary->id) }}" method="POST" >
            @csrf
            @method('put')
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="salary_rule_code">Salary Rule Code</label>
                        <input type="text" class="form-control" id="salary_rule_code" name="salary_rule_code" value="{{$salary->salary_rule_code}}">
                    </div>
                    <div class="form-group">
                        <label for="salary_head_id">Salary Head</label>
                        <input type="number" class="form-control" id="salary_head_id" name="salary_head_id" value="{{$salary->salary_head_id}}">
                    </div>
                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount" value="{{$salary->amount}}">
                    </div>
                    <button type="submit" class="btn btn-primary float-right">Submit</button>
                </div>
            </div>
        </form>
    </div>
</div>
@stop
