@extends('layouts.master')
@section('content')
<style>
    /* Improved CSS styles */
    .invoice-header {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px; /* Space between header and table */
    }
   /* .invoice-header .logo {
        width: 35%;
    }
    .invoice-header .logo img {
        width: 200px;
        height: 124px;
    }*/
    .invoice-header .content {
/*        width: 65%;*/
        width: 100%;
    }
    .printable-table .content h2, .printable-table .content p {
        margin-bottom: 5px;
    }
</style>
<div class="card mb-3">
    <div class="card-body card__head">
        <form method="GET" action="{{ route('monthly-salary.index') }}" class="row">
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="form-group mb-0">
                    @component('components.employee_search', [
                        'employee_name' => $employee_name ?? '',
                        'employee_code' => request()->employee_code ?? '',
                        'required' => '',
                    ])
                    @endcomponent
                </div>
            </div>
            <div class="form-group col-sm-6 col-md-6 col-lg-3">
                {{ generateDropdown($academicYears, 'class="form-control academic_year" id="academic_year" name="academic_year" required', request()->query('academic_year') ?? $defaultYear, "Select Year") }}
            </div>
            <div class="form-group col-sm-6 col-md-6 col-lg-3">
                {{ generateDropdown(config('months'), 'class="form-control month" id="month" name="month" required', request()->query('month') ?? date('m'), "Select Month") }}
            </div>

            <div class="form-group col-sm-6 col-md-6 col-lg-3">
                <button type="submit" class="btn btn-info">Search</button>
            </div>
        </form>
    </div>
</div>



<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Salary Sheet</h6>
        <div class="m-0 float-right">
            @if ($newSalaries->isNotEmpty())
                <button onclick="printTable()" class="btn btn-sm btn-primary mr-1">Print</button>
            @endif
            <a href="{{ route('monthly-salary.create') }}" class="btn btn-sm btn-primary">Generate Salary</a>
        </div>
    </div>

    <div class="card-body">
        @if ($newSalaries->isNotEmpty())
            <div class="printable-table">
                <div class="invoice-header">
                    <div class="logo d-none">
                        <img src="{{ asset('uploads/images/logo-white.jpg') }}" alt="Logo">
                    </div>
                    <div class="content text-center">
                        @php
                            $get_branch_info = get_branch_info();
                        @endphp
                        <h2>{{get_setting_value(Settings::SCHOOL_NAME)}}</h2>
                        <p>{{ $get_branch_info->address }}</p>
                        <p>Contact: {{ $get_branch_info->contact_info }}</p>
                        <p>Email: {{ get_setting_value(Settings::SCHOOL_EMAIL) }}</p>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Emp. Code</th>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Grade</th>
                                <th>Processed Date</th>
                                @foreach ($salary_heads as $head)
                                    <th>{{ $head->title }}</th>
                                @endforeach
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($newSalaries as $salary)
                                <tr>
                                    <td>{{ $salary->employee->employee_code }}</td>
                                    <td>{{ $salary->employee->name }}</td>
                                    <td>{{ $salary->employee->mobile_number ?? '-' }}</td>
                                    <td>{{ $salary->employee->salaryGrade->title ?? '-' }}</td>
                                    <td>{{ \Carbon\Carbon::parse($salary->process_date)->format('d-m-Y') }}</td>
                                    @foreach ($salary->salaryGrade->salaryGradeRules as $gradeRule)
                                        @if ($gradeRule->rule_type == 'Percentage')
                                            <td>{{ ($salary->amount * $gradeRule->amount)/100 }}</td>
                                        @else
                                            <td>{{ $salary->amount }}</td>
                                        @endif
                                    @endforeach
                                    <td>{!! getStatusBadge($salary->status) !!}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @else
            <div class="text-center">
                @if (isset(request()->academic_year) && isset(request()->month))
                    <h4>No salary data found for the selected month, year. Generate salary sheet from <a href="{{route("monthly-salary.create",['employee_code'=>request()->employee_code, 'academic_year'=> request()->academic_year, 'month'=>request()->month])}}" target="_blank">here</a>.</h4>
                @else
                    <h4>Search with month, year for salary sheet.</h4>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
    <script>

        function printTable() {
            // Improved print functionality
            const printableTable = document.querySelector('.printable-table');
            const printStyles = `
                @media print {
                    @page {
                        size: landscape;
                        paper: a4;
                        margin: 10mm;
                    }
                    body {
                        margin: 0; /* Remove body margins */
                    }
                    body * {
                        visibility: hidden;
                    }
                    .printable-table, .printable-table * {
                        visibility: visible;
                    }
                    .printable-table {
                        position: absolute;
                        left: 0;
                        top: 0;
                        width: 100%;
                    }
                    .table-responsive {
                        overflow: visible;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                    }
                    th, td {
                        border: 1px solid #ddd;

                        font-size: 12px;
                    }
                    .printable-table .content h2, .printable-table .content p {
                        margin-bottom: 5px;
                    }
                    .invoice-header {
                        display: flex;
                        flex-wrap: wrap;
                        justify-content: space-between;
                        align-items: center;
                        margin-bottom: 20px; /* Space between header and table */
                    }
                    .invoice-header .logo {
                        width: 35%;
                    }
                    .invoice-header .logo img {
                        width: 200px;
                        height: 124px;
                    }
                    .invoice-header .content {
                        width: 65%;
                    }
                }
            `;
            const style = document.createElement('style');
            style.innerHTML = printStyles;
            document.head.appendChild(style);
            window.print();
            document.head.removeChild(style);
        }
    </script>
@endpush
