@extends('layouts.master')

@section('content')
    <style>
        /* Improved CSS styles */
        .invoice-header {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px; /* Space between header and table */
        }
        .invoice-header .logo {
            width: 35%;
        }
        .invoice-header .logo img {
            width: 200px;
            height: 124px;
        }
        .invoice-header .content {
            width: 65%;
        }
        .printable-table .content h2, .printable-table .content p {
            margin-bottom: 5px;
        }
    </style>

    <div class="card mt-3">
        <header class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
            <h5>Salary Sheet</h5>
            <div class="d-flex justify-content-end">
                <button onclick="printTable()" class="btn btn-sm btn-primary mr-1">Print</button>
                <button onclick="window.history.back()" class="btn btn-sm btn-secondary">Back</button>
            </div>
        </header>
        <div class="card-body">
            @if ($newSalaries->isNotEmpty())
                <div class="printable-table">
                    <div class="invoice-header">
                        <div class="logo">
                            <img src="{{ asset('uploads/images/logo-white.jpg') }}" alt="Logo">
                        </div>
                        <div class="content">
                            @php
                                $get_branch_info = get_branch_info();
                            @endphp
                            <h2>{{get_setting_value(Settings::SCHOOL_NAME)}}</h2>
                            <p>{{ $get_branch_info->address }}</p>
                            <p>Contact: {{ $get_branch_info->contact_info }}</p>
                            <p>Email: {{ get_setting_value(Settings::SCHOOL_EMAIL) }}</p>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Emp. Code</th>
                                    <th>Name</th>
                                    <th>Mobile</th>
                                    <th>Grade</th>
                                    <th>Processed Date</th>
                                    @foreach ($salary_heads as $head)
                                        <th>{{ $head->title }}</th>
                                    @endforeach
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($newSalaries as $salary)
                                    <tr>
                                        <td>{{ $salary->employee->employee_code }}</td>
                                        <td>{{ $salary->employee->name }}</td>
                                        <td>{{ $salary->employee->mobile_number ?? '-' }}</td>
                                        <td>{{ $salary->employee->salaryGrade->title ?? '-' }}</td>
                                        <td>{{ \Carbon\Carbon::parse($salary->process_date)->format('d-m-Y') }}</td>
                                        @foreach ($salary->salaryGrade->salaryGradeRules as $gradeRule)
                                            @if ($gradeRule->rule_type == 'Percentage')
                                                <td>{{ ($salary->amount * $gradeRule->amount)/100 }}</td>
                                            @else
                                                <td>{{ $salary->amount }}</td>
                                            @endif
                                        @endforeach
                                        <td>{!! getStatusBadge($salary->status) !!}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @else
                <div class="text-center">
                    <h4>No salary data found for the selected employees.</h4>
                </div>
            @endif
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let newSalaries = @json($newSalaries);
         if (Array.isArray(newSalaries) && newSalaries.length > 0) {
            document.addEventListener('DOMContentLoaded', function() {
                setTimeout(printTable, 1000); // Delay by 1 second
            });
        }


        function printTable() {
            // Improved print functionality
            const printableTable = document.querySelector('.printable-table');
            const printStyles = `
                @media print {
                    @page {
                        size: landscape;
                        paper: a4;
                        margin: 10mm;
                    }
                    body {
                        margin: 0; /* Remove body margins */
                    }
                    body * {
                        visibility: hidden;
                    }
                    .printable-table, .printable-table * {
                        visibility: visible;
                    }
                    .printable-table {
                        position: absolute;
                        left: 0;
                        top: 0;
                        width: 100%;
                    }
                    .table-responsive {
                        overflow: visible;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                    }
                    th, td {
                        border: 1px solid #ddd;

                        font-size: 12px;
                    }
                    .printable-table .content h2, .printable-table .content p {
                        margin-bottom: 5px;
                    }
                }
            `;
            const style = document.createElement('style');
            style.innerHTML = printStyles;
            document.head.appendChild(style);
            window.print();
            document.head.removeChild(style);
        }
    </script>
@endpush
