@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card">
            <div class="card__head">
                <!-- Nav tabs -->
                <ul class="nav nav-tabs" id="myTab" role="tablist">

                    <li class="nav-item">
                        <a class="nav-link" id="salary-head-tab" data-toggle="tab" href="#salary-head" role="tab" aria-controls="salary-head" aria-selected="false">Salary Head</a >
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="salary-grade-tab" data-toggle="tab" href="#salary-grade" role="tab" aria-controls="salary-grade" aria-selected="true">Salary Grade</a>
                    </li>

                </ul>
            </div>
            <!-- Tab content -->
            <div class="row">
                <div class="col-md-12">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade" id="salary-head" role="tabpanel" aria-labelledby="salary-head-tab">
                            @include('pages.hr-payroll.salary-setting.salary-head')
                        </div>

                        <div class="tab-pane fade" id="salary-grade" role="tabpanel" aria-labelledby="salary-grade-tab">
                            @include('pages.hr-payroll.salary-setting.salary-grade')
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // Get the active tab from local storage
            var activeTab = localStorage.getItem('activeTab');

            // If an active tab is stored, select it
            if (activeTab) {
                $('#' + activeTab).tab('show');
                $('a[href="#' + activeTab + '"]').addClass('active');
            }

            // Store the active tab in local storage when a tab is clicked
            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                localStorage.setItem('activeTab', $(e.target).attr('href').substr(1));
                $(e.target).addClass('active'); // Add active class to the tab link
            });
        });
    </script>
@endsection
