<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
    <button class="btn btn-sm btn-light-blue" id="add-new" data-toggle="modal" data-target="#salaryGradeModal">Add New</button>
</div>
<div class="table-responsive" >
    <table class="table">
        <thead class="thead-light">
            <tr>
                <th>SN</th>
                <th>Grade</th>
                <th>Code</th>
                <th>Status</th>
                <th class="action__col">Action</th>
            </tr>
        </thead>
        <tbody>
            @if($salaryGrades->isNotEmpty())
            @foreach ($salaryGrades as $key => $salaryGrade)
                <tr>
                    <td>{{ $key + 1 }}</td>
                    <td>{{ $salaryGrade->title }}</td>
                    <td>{{ $salaryGrade->code }}</td>
                    <td>{!! getStatusBadge($salaryGrade->status) !!}</td>
                    <td class="d-flex justify-content-start">
                        <a href="" class="btn btn-sm btn-soft-info mr-1 edit" data-id="{{ $salaryGrade->id }}"><i class="fas fa-edit"></i></a>
                        <form action="{{ route('salary-grades.destroy', $salaryGrade->id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
            @endforeach
            @else
            <tr><td colspan="5" class="text-center">No data available in table</td></tr>
            @endif
        </tbody>
    </table>
</div>

<!-- Modal -->
<div class="modal fade" id="salaryGradeModal" tabindex="-1" role="dialog" aria-labelledby="salaryGradeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="salaryGradeModalLabel">Add/Edit Salary Grade</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="salaryGradeForm" method="POST">
                @csrf
                <input type="hidden" name="_method" value="POST" id="method">
                <input type="hidden" name="id" id="id" value="">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="title">Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="grade_title" name="title" value="" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="type">Criteria/Type</label>
                                {{ generateDropdown($salaryRuleType, 'name="type" id="criteria" class="form-control" required', old('type'), 'Select Criteria' ) }}
                            </div>
                        </div>
                        @foreach ($salaryHeads as $head)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="{{$head->code}}">{{$head->title}}</label>
                                    <input type="number" class="form-control salary-grade" id="{{$head->code}}" name="{{$head->code}}" value="" placeholder="Enter value" required>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')
<script>
$(document).ready(function() {
    // Create new salary grade
    $('#add-new').on('click', function() {
        $('#salaryGradeModal').modal('show');
        $('#salaryGradeForm').attr('action', '{{ route("salary-grades.store") }}');
        $('#method').val('POST');
        $('#id').val('');
        $('#grade_title').val('');
        $('#criteria').val('');
        $('.salary-grade').val('');
    });

    // Edit salary grade
    $('.edit').on('click', function(event) {
        event.preventDefault();
        var id = $(this).data('id');
        $.ajax({
            type: 'GET',
            url: '{{ route("salary-grades.edit", ":id") }}'.replace(':id', id),
            success: function(data) {
                $('#salaryGradeModal').modal('show');
                $('#salaryGradeForm').attr('action', '{{ route("salary-grades.update", ":id") }}'.replace(':id', id));
                $('#id').val(id);
                $('#grade_title').val(data.title);
                $('#criteria').val(data.salary_grade_rules[0].rule_type).change();
                $.each(data.salary_grade_rules, function(index, value) {
                    $('#' + value.salary_head.code).val(customRound(value.amount,2));
                });
            }
        });
    });

});
</script>
@endpush
