<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
    <button class="btn btn-sm btn-light-blue" data-toggle="modal" data-target="#salaryHeadModal">Add New</button>
</div>
<div class="table-responsive" >
    <table class="table">
        <thead class="thead-light">
            <tr>
                <th>ID</th>
                <th>Title</th>
                <th>Code</th>
                <th>Type</th>
                <th class="action__col">Action</th>
            </tr>
        </thead>
        <tbody>
            @if($salaryHeads->isNotEmpty())
            @foreach($salaryHeads as $index => $head)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $head->title }}</td>
                    <td>{{ $head->code }}</td>
                    <td>{{ $head->type == 'E' ? 'Earn' : 'Deduct' }}</td>
                    <td class="d-flex justify-content-start">
                        <button class="btn btn-sm btn-soft-info mr-1 edit-btn" data-id="{{ $head->id }}" data-code="{{ $head->code }}" data-title="{{ $head->title }}" data-type="{{ $head->type }}"><i class="fas fa-edit"></i></button>
                        <form action="{{ route('salary-heads.destroy', $head->id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this salary head?')"><i class="fas fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
            @endforeach
            @else
            <tr><td colspan="5" class="text-center">No data available in table</td></tr>
            @endif
        </tbody>
    </table>
</div>

<!-- Modal -->
<div class="modal fade" id="salaryHeadModal" tabindex="-1" role="dialog" aria-labelledby="salaryHeadModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="salaryHeadModalLabel">Add/Edit Salary Head</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="salaryHeadForm" method="POST">
                @csrf
                <input type="hidden" name="_method" value="POST" id="method">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="title">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="title" name="title" required>
                    </div>
                    <div class="form-group">
                        <label for="type">Type</label>
                        <select class="form-control" id="type" name="type" required>
                            <option value="E">Earn</option>
                            <option value="D">Deduct</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')
<script>
    $(document).ready(function() {
        // Open modal for creating new salary head
        $('.btn-light-blue[data-target="#salaryHeadModal"]').click(function() {
            $('#salaryHeadForm')[0].reset();
            $('#salaryHeadForm').attr('action', '{{ route("salary-heads.store") }}');
            $('#method').val('POST');
            $('#salaryHeadModalLabel').text('Add Salary Head');
        });

        // Open modal for editing salary head
        $('.edit-btn').click(function() {
            var id = $(this).data('id');
            $('#salaryHeadForm').attr('action', '/salary-setting/update-head/' + id);
            $('#method').val('PUT');
            $('#salaryHeadModalLabel').text('Edit Salary Head');
            $('#title').val($(this).data('title'));
            $('#type').val($(this).data('type'));
            $('#salaryHeadModal').modal('show');
        });
    });
</script>
@endpush
