<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admission Form</title>
    <style>
        body { font-family: sans-serif; font-size: 11px; }
        .header {
            text-align: center;
            border-bottom: 2px solid #000;
            margin-bottom: 10px;
        }
        .header img {
            width: 70px;
            float: left;
        }
        .header h2 {
            margin: 0;
            color: red;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }
        th, td {
            border: 1px solid #000;
            padding: 3px;
            text-align: left;
        }
        .section-title {
            background-color: #f0f0f0;
            font-weight: bold;
            padding: 4px;
        }
        .signature {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
        }
        .info-label { font-weight: bold; }
    </style>
</head>
<body>

<div class="header">
    <img src="{{ public_path('images/college-logo.png') }}" alt="Logo">
    <h2>নবাবগঞ্জ সিটি কলেজ, চাঁপাইনবাবগঞ্জ</h2>
    <p>স্থাপিত: ১৯৯৬ &nbsp;|&nbsp; EIIN NO: 124596 &nbsp;|&nbsp; মোবাইল: ০১৭৩৮৮৮১৯১৮</p>
</div>

@php
    $imagePath = asset($data['profile_image']);
@endphp

@if(file_exists($imagePath))
    <img src="{{ $imagePath }}" style="width: 100px; height: 120px; float: right; border: 1px solid #000;">
@endif
<table>
    <tr>
        <td><strong>College Code:</strong> 1756</td>
        <td colspan="2" style="text-align: center;"><strong>GROUP OF {{ strtoupper($data['hscgruop']) }}</strong></td>
        <td><strong>Application Date:</strong> {{ now()->format('d / M / Y') }}</td>
    </tr>
</table>

<p class="section-title">Applicant Information</p>
<table>
    <tr>
        <td><strong>Student's Name (English)</strong></td><td>{{ $data['first_name'] }}</td>
        <td><strong>Class Roll</strong></td><td>{{ $data['class_roll'] ?? '-' }}</td>
    </tr>
    <tr>
        <td><strong>SSC Roll</strong></td><td>{{ $data['ssc_roll_num'] }}</td>
        <td><strong>Merit Position</strong></td><td>{{ $data['merit_position'] }}</td>
    </tr>
    <tr>
        <td><strong>Student's Mobile Number</strong></td><td>{{ $data['applicant_mobile'] }}</td>
        <td><strong>Blood Group</strong></td><td>{{ $data['blood_group'] }}</td>
    </tr>
    <tr>
        <td><strong>Birth Certificate/NID</strong></td><td>{{ $data['nid'] }}</td>
        <td><strong>Date of Birth</strong></td><td>{{ $data['dob'] }}</td>
    </tr>
    <tr>
        <td><strong>Marital Status</strong></td><td>{{ $data['marital_status'] ?? 'N/A' }}</td>
        <td><strong>Gender</strong></td><td>{{ $data['gender'] }}</td>
    </tr>
    <tr>
        <td><strong>Religion</strong></td><td>{{ $data['religion'] }}</td>
        <td><strong>Nationality</strong></td><td>{{ $data['nationality'] }}</td>
    </tr>
</table>

<p class="section-title">Parent/Guardian Information</p>
<table>
    <tr>
        <td><strong>Father's Name</strong></td><td>{{ $data['fther_name'] }}</td>
        <td><strong>Father's NID</strong></td><td>{{ $data['fther_nid'] }}</td>
    </tr>
    <tr>
        <td><strong>Father's Mobile</strong></td><td>{{ $data['father_mobile'] }}</td>
        <td><strong>Father's Date of Birth</strong></td><td>{{ $data['father_dob'] }}</td>
    </tr>
    <tr>
        <td><strong>Father's Occupation</strong></td><td>{{ $data['father_occupation'] }}</td>
        <td><strong>Monthly Income</strong></td><td>{{ $data['father_income'] }}</td>
    </tr>
    <tr>
        <td><strong>Mother's Name</strong></td><td>{{ $data['mother_name'] }}</td>
        <td><strong>Mother's NID</strong></td><td>{{ $data['mother_nid'] }}</td>
    </tr>
    <tr>
        <td><strong>Mother's Mobile</strong></td><td>{{ $data['mother_mobile'] }}</td>
        <td><strong>Mother's DOB</strong></td><td>{{ $data['mother_dob'] }}</td>
    </tr>
    <tr>
        <td><strong>Mother's Occupation</strong></td><td>{{ $data['mother_occupation'] }}</td>
        <td><strong>Monthly Income</strong></td><td>{{ $data['mother_income'] }}</td>
    </tr>
    <tr>
        <td><strong>Guardian</strong></td><td>{{ $data['guardian_selection'] ?? 'N/A' }}</td>
        <td><strong>Guardian's Mobile</strong></td><td>{{ $data['guardian_mobile'] }}</td>
    </tr>
</table>

<p class="section-title">Address</p>
<table>
    <tr>
        <td><strong>Present Address:</strong> {{ $data['village_present'] }}, {{ $data['post_present'] }}, {{ $data['police_present'] }}, {{ $data['district_present'] }}</td>
    </tr>
    <tr>
        <td><strong>Permanent Address:</strong> {{ $data['village_permanent'] }}, {{ $data['post_permanent'] }}, {{ $data['police_permanent'] }}, {{ $data['district_permanent'] }}</td>
    </tr>
</table>

<p class="section-title">Academic Information</p>
<table>
    <tr>
        <td><strong>Board</strong></td><td>{{ $data['board_select'] }}</td>
        <td><strong>Year</strong></td><td>{{ $data['passing_year'] }}</td>
    </tr>
    <tr>
        <td><strong>Institute</strong></td><td colspan="3">{{ $data['InstituteName'] ?? 'N/A' }}</td>
    </tr>
    <tr>
        <td><strong>SSC Roll</strong></td><td>{{ $data['ssc_roll_num'] }}</td>
        <td><strong>Reg No</strong></td><td>{{ $data['ssc_reg_num'] }}</td>
    </tr>
    <tr>
        <td><strong>Session</strong></td><td>{{ $data['ssc_session'] }}</td>
        <td><strong>GPA</strong></td><td>{{ $data['ssc_gpa'] }}</td>
    </tr>
</table>

<p class="section-title">Subject Choice</p>
<table>
    <tr>
        <td><strong>Main Subjects</strong></td><td>Bangla, English, ICT</td>
    </tr>
    <tr>
        <td><strong>Elective Subjects</strong></td><td>{{ $data['elective_subject'] }}</td>
    </tr>
    <tr>
        <td><strong>4th Subject</strong></td><td>{{ $data['optional_subject'] }}</td>
    </tr>
</table>

<p class="section-title">Payment Information</p>
<table>
    <tr>
        <td><strong>Method</strong></td><td>{{ $data['group_payment'] }}</td>
        <td><strong>From Account</strong></td><td>{{ $data['payment_from_account']  ?? 'N/A'}}</td>
        <td><strong>Txn ID</strong></td><td>{{ $data['payment_tnxid'] ?? 'N/A' }}</td>
    </tr>
</table>

<div class="signature">
    <div>Applicant's Signature</div>
    <div>Principal's Signature</div>
</div>

<p style="text-align: center; font-size: 10px; margin-top: 30px;">
    Education Management System - Design & Develop by JBD IT.
</p>

</body>
</html>
