@extends('layouts.master')

@section('content')
    <style>
        /* Chrome, Safari, Edge, Opera */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }
        .image-uploader {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative; /* Add position relative */
        }

        .image-uploader__label {
            display: flex;
            flex-direction: column;
            align-items: center;
            cursor: pointer;
            position: relative; /* Add position relative */
        }

        .image-uploader__icon-overlay {
            position: absolute;
            top: 50%; /* Align vertically centered */
            left: 50%; /* Align horizontally centered */
            transform: translate(-50%, -50%); /* Center the icon */
            width: 100%;
            height: calc(100%); /* Height equal to parent minus icon height */
            background-color: rgba(0, 0, 0, 0.2); /* Transparent black background */
            border-radius: 50%; /* Rounded border */
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0.4;
        }

        .image-uploader__icon-overlay i {
            color: #ffffff; /* Icon color */
            font-size: 24px; /* Icon size */
        }

        /* Your existing styles */
        .image-uploader__preview {
            overflow: hidden;
        }

        .image-uploader__input {
            display: none;
        }


    </style>
    <div class="card std__form">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Edit HSC Applicant Info</h6>
            <div class="m-0 float-right">
                <a class="btn btn-sm btn-light-blue" href="{{ route('hsc-admission.index') }}">View All</a>
            </div>
        </div>
        <div class="card-body m-3">
            <form action="{{ route('hsc-admission.update',$applicant->id) }}" method="POST"
                  enctype="multipart/form-data">
                @csrf
                <div class="row py-2 px-3 mb-3 text-white form__head">
                    Applicant Info
                </div>
                <div class="row py-2 form__body">
                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="admissionRoll" class="form-label"> SSC Roll: <span
                                    class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="admissionRoll"
                                name="admission_roll" value="{{ old('admission_roll', $applicant->admission_roll) }}" aria-invalid="false">
                            @error('admission_roll')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror    
                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="sessionYear" class="form-label">HSC Session : <span
                                    class="text-danger">*</span></label>
                            <select class="form-select form-control required" id="sessionYear" name="session_year" aria-invalid="false">
                                <option value="">Select HSC Session</option>
                                <option value="9"  {{ $applicant->session_year == 9 ? 'selected' : '' }}>2023-2024</option>
                                <option value="10" {{ $applicant->session_year == 10 ? 'selected' : '' }}>2024-2025</option>
                                <option value="11" {{ $applicant->session_year == 11 ? 'selected' : '' }}>2025-2026</option>
                                <option value="12" {{ $applicant->session_year == 12 ? 'selected' : '' }}>2026-2027</option>
                                <option value="13" {{ $applicant->session_year == 13 ? 'selected' : '' }}>2027-2028</option>
                                <option value="14" {{ $applicant->session_year == 14 ? 'selected' : '' }}>2028-2029</option>
                                <option value="15" {{ $applicant->session_year == 15 ? 'selected' : '' }}>2029-2030</option>
                                <option value="16" {{ $applicant->session_year == 16 ? 'selected' : '' }}>2030-2031</option>
                                <option value="17" {{ $applicant->session_year == 17 ? 'selected' : '' }}>2031-2032</option>
                            </select>

                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="classRoll" class="form-label"> Class Roll: (To be filled by the college)
                            </label>
                            <input type="text" class="form-control" id="classRoll" name="class_roll"
                                readonly="">
                            <small id="classRoll-error-msg" class="form-text text-muted text-danger"></small>
                        </div>
                    </div>

                    <script>
                        function checkDuplicate() {
                            var classRoll = document.getElementById('classRoll').value;
                            var sessionYear = document.getElementById('sessionYear').value;
                            var errorElem = document.getElementById('classRoll-error-msg');

                            // Remove any previous error message
                            errorElem.textContent = '';

                            if (classRoll === '' || sessionYear === '') {
                                // If either input is empty, no need to check for duplicates
                                errorElem.textContent = '';
                                document.getElementById('classRoll').setCustomValidity('');
                                return;
                            }

                            // Create a new XMLHttpRequest object
                            var xhr = new XMLHttpRequest();
                            xhr.open('POST', 'check_duplicate.php', true);
                            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                            // Handle the response from the server
                            xhr.onreadystatechange = function() {
                                if (xhr.readyState == 4 && xhr.status == 200) {
                                    var response = JSON.parse(xhr.responseText);
                                    if (response.exists) {
                                        errorElem.textContent = 'Class Roll already exists for the selected HSC Session!';
                                        errorElem.style.color = 'red';
                                        document.getElementById('classRoll').setCustomValidity(
                                            'Class Roll already exists for the selected HSC Session!');
                                    } else {
                                        document.getElementById('classRoll').setCustomValidity('');
                                    }
                                }
                            };

                            // Send the request with the classRoll and sessionYear parameters
                            xhr.send('classRoll=' + encodeURIComponent(classRoll) + '&sessionYear=' + encodeURIComponent(sessionYear));
                        }

                        document.getElementById('classRoll').addEventListener('input', checkDuplicate);
                        document.getElementById('sessionYear').addEventListener('change', checkDuplicate);
                    </script>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const sessionYearSelect = document.getElementById('sessionYear');
                            const paymentAmountInput = document.getElementById('PaymentAmount');

                            sessionYearSelect.addEventListener('change', function() {
                                const id = this.value;
                                if (!id) {
                                    paymentAmountInput.value = ''; // Clear the input if no value is selected
                                    return;
                                }

                                fetch(`/session-price/${encodeURIComponent(id)}`)
                                    .then(response => {
                                        if (!response.ok) throw new Error('Network response was not ok');
                                        return response.json();
                                    })
                                    .then(data => {
                                        // assuming the returned JSON looks like { price: 123.45 }
                                        paymentAmountInput.value = data.price ?? ''; // Update paymentAmountInput
                                    })
                                    .catch(error => {
                                        console.error('Error fetching price:', error);
                                        paymentAmountInput.value = ''; // Clear the input if there’s an error
                                    });
                            });
                        });
                    </script>


                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="meritPosition" class="form-label"> Merit Position: </label>
                            <input type="text" class="form-control" id="meritPosition" name="merit_position" value="{{ old('merit_position', $applicant->merit_position) }}"
                                aria-invalid="false">
                        </div>
                    </div>



                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="wfirstName2" class="form-label"> Applicant's Name (English): <span
                                    class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="wfirstName2"
                                name="first_name"  value="{{ old('first_name', $applicant->first_name) }}" aria-invalid="false">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="wapplicantMobile2" class="form-label"> Applicant's Mobile Number: <span
                                    class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="wapplicantMobile2"
                                name="applicant_mobile" value="{{ old('applicant_mobile', $applicant->applicant_mobile) }}" aria-invalid="false"><label id="wapplicantMobile2-error"
                                class="text-danger" for="wapplicantMobile2" style="display: none;"></label>
                            <small class="text-danger" id="mobile-error-msg"></small>
                        </div>
                    </div>
                    <script>
                        document.getElementById('wapplicantMobile2').addEventListener('input', function(e) {
                            var mobileNumber = e.target.value;
                            var errorElem = document.getElementById('mobile-error-msg');

                            // Remove any previous error message
                            errorElem.textContent = '';

                            // Validate if input contains exactly 11 digits
                            if (!/^\d{11}$/.test(mobileNumber)) {
                                errorElem.textContent = 'Mobile number must be exactly 11 digits and contain only numbers (0-9).';
                                e.target.setCustomValidity('Invalid input');
                            } else {
                                e.target.setCustomValidity('');
                            }
                        });
                    </script>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="bloodGroup" class="form-label">Blood Group : </label>
                            <select class="form-select form-control" id="bloodGroup" name="blood_group" aria-invalid="false">
                                <option value="">Select Blood Group</option>
                                <option value="A+" {{ $applicant->blood_group == 'A+' ? 'selected' : '' }}>A+</option>
                                <option value="A-" {{ $applicant->blood_group == 'A-' ? 'selected' : '' }}>A-</option>
                                <option value="B+" {{ $applicant->blood_group == 'B+' ? 'selected' : '' }}>B+</option>
                                <option value="B-" {{ $applicant->blood_group == 'B-' ? 'selected' : '' }}>B-</option>
                                <option value="O+" {{ $applicant->blood_group == 'O+' ? 'selected' : '' }}>O+</option>
                                <option value="O-" {{ $applicant->blood_group == 'O-' ? 'selected' : '' }}>O-</option>
                                <option value="AB+" {{ $applicant->blood_group == 'AB+' ? 'selected' : '' }}>AB+</option>
                                <option value="AB-" {{ $applicant->blood_group == 'AB-' ? 'selected' : '' }}>AB-</option>
                            </select>

                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="nid" class="form-label"> Birth Certificate/NID Number: </label>
                            <input type="text" class="form-control" id="nid" name="nid" value="{{ old('nid', $applicant->nid) }}"
                                aria-invalid="false">
                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="wdate2" class="form-label">Date of Birth : <span
                                    class="text-danger">*</span></label>
                            <input type="date" class="form-control required" id="wdate2" name="dob" value="{{ old('dob', $applicant->dob) }}"
                                aria-invalid="false">
                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="maritalStatus" class="form-label">Marital Status : <span class="text-danger">*</span></label>
                            <select class="form-select form-control required" id="maritalStatus" name="maritals_status" aria-invalid="false">
                                <option value="">Select Marital Status </option>
                                <option value="Married" {{ $applicant->maritals_status == 'Married' ? 'selected' : '' }}>Married</option>
                                <option value="Unmarried" {{ $applicant->maritals_status == 'Unmarried' ? 'selected' : '' }}>Unmarried</option>
                                <option value="Divorced" {{ $applicant->maritals_status == 'Divorced' ? 'selected' : '' }}>Divorced</option>
                            </select>

                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="gender" class="form-label">Gender : <span
                                    class="text-danger">*</span></label>
                            <select class="form-select form-control required" id="gender" name="gender" aria-invalid="false">
                                <option value="">Select Gender</option>
                                <option value="Male" {{ $applicant->gender == 'Male' ? 'selected' : '' }}>Male</option>
                                <option value="Female" {{ $applicant->gender == 'Female' ? 'selected' : '' }}>Female</option>
                                <option value="Other" {{ $applicant->gender == 'Other' ? 'selected' : '' }}>Other</option>
                            </select>

                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="nationality" class="form-label">Nationality: </label>
                            <input type="text" class="form-control" id="nationality" name="nationality" value="Bangladeshi" readonly
                                aria-invalid="false">
                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group validate">
                            <label for="religion" class="form-label">Religion : <span
                                    class="text-danger">*</span></label>
                            <select class="form-select form-control required" id="religion" name="religion" aria-invalid="false">
                                <option value="">Select Religion</option>
                                <option value="Islam" {{ $applicant->religion == 'Islam' ? 'selected' : '' }}>Islam</option>
                                <option value="Hinduism" {{ $applicant->religion == 'Hinduism' ? 'selected' : '' }}>Hinduism</option>
                                <option value="Buddhism" {{ $applicant->religion == 'Buddhism' ? 'selected' : '' }}>Buddhism</option>
                                <option value="Christianity" {{ $applicant->religion == 'Christianity' ? 'selected' : '' }}>Christianity</option>
                                <option value="Other" {{ $applicant->religion == 'Other' ? 'selected' : '' }}>Other</option>
                            </select>

                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="image-uploader">
                            <label for="image" class="form-label">Applicant Passport Size Photo: <span class="text-danger">*</span></label>
                            <label for="imageFile" class="image-uploader__label">
                                <!-- Icon overlay with transparent background -->
                                <div class="image-uploader__icon-overlay">
                                    <i class="fas fa-cloud-upload-alt"></i>
                                </div>
                                <!-- Preview image --> 
                                <img src="{{ $applicant->profile_image != null ? asset($applicant->profile_image) : asset('assets/img/boy.png') }}" alt="Preview image" class="image-uploader__preview-image img-thumbnail rounded-circle p-1" style="width: 140px; height: 140px;">
                                <!-- File input -->
                                <input type="file" name="profile_image" class="image-uploader__input" id="imageFile" accept="image/*" >
                            </label>
                        </div>
                        <div id="imageError" class="text-danger text-center small d-none">Please select a photo.</div>

                        {{-- Laravel error display --}}
                        @error('profile_image')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                    
                <div class="row py-2 px-3 mb-3 text-white form__head">
                     Academic Info
                </div>
                <div class="row py-2 form__body">
                    <h4>SSC Educational Information</h4>
                    <div class="row">
                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="boardSelect" class="form-label">SSC Board : <span
                                        class="text-danger">*</span></label>
                                <select class="form-select form-control required" id="boardSelect" name="board_select" aria-invalid="false">
                                    <option value="">Select Board</option>
                                    <option value="Rajshahi" {{ $applicant->board_select == 'Rajshahi' ? 'selected' : '' }}>Rajshahi</option>
                                    <option value="Dhaka" {{ $applicant->board_select == 'Dhaka' ? 'selected' : '' }}>Dhaka</option>
                                    <option value="Cumilla" {{ $applicant->board_select == 'Cumilla' ? 'selected' : '' }}>Cumilla</option>
                                    <option value="Chittagong" {{ $applicant->board_select == 'Chittagong' ? 'selected' : '' }}>Chittagong</option>
                                    <option value="Barisal" {{ $applicant->board_select == 'Barisal' ? 'selected' : '' }}>Barisal</option>
                                    <option value="Dinajpur" {{ $applicant->board_select == 'Dinajpur' ? 'selected' : '' }}>Dinajpur</option>
                                    <option value="Jessore" {{ $applicant->board_select == 'Jessore' ? 'selected' : '' }}>Jessore</option>
                                    <option value="Mymensingh" {{ $applicant->board_select == 'Mymensingh' ? 'selected' : '' }}>Mymensingh</option>
                                    <option value="Sylhet" {{ $applicant->board_select == 'Sylhet' ? 'selected' : '' }}>Sylhet</option>
                                    <option value="Madrasah" {{ $applicant->board_select == 'Madrasah' ? 'selected' : '' }}>Madrasah</option>
                                    <option value="Technical" {{ $applicant->board_select == 'Technical' ? 'selected' : '' }}>Technical</option>
                                    <option value="Others" {{ $applicant->board_select == 'Others' ? 'selected' : '' }}>Others</option>
                                </select>

                                <label id="boardSelect-error" class="text-danger" for="boardSelect"
                                    style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="passingYear" class="form-label">SSC Passing Year : <span
                                        class="text-danger">*</span></label>
                                <select class="form-select form-control required" id="passingYear" name="passing_year" aria-invalid="false">
                                <option value="">Select Year</option>
                                <option value="2024" {{ $applicant->passing_year == '2024' ? 'selected' : '' }}>2024</option>
                                <option value="2023" {{ $applicant->passing_year == '2023' ? 'selected' : '' }}>2023</option>
                                <option value="2022" {{ $applicant->passing_year == '2022' ? 'selected' : '' }}>2022</option>
                            </select>
                            <label id="passingYear-error" class="text-danger" for="passingYear" style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-2">
                            <div class="form-group validate">
                                <label for="InstituteName" class="form-label"> Institute Name: <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="InstituteName" value="{{ old('institute_name', $applicant->institute_name) }}"
                                    name="institute_name" aria-invalid="false"><label id="InstituteName-error"
                                    class="text-danger" for="InstituteName" style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscRollNum" class="form-label">SSC Roll: <span
                                        class="text-danger">*</span> </label>
                                <input type="number" class="form-control required" id="sscRollNum"
                                    name="ssc_roll_num" value="{{ old('ssc_roll_num', $applicant->ssc_roll_num) }}" aria-invalid="false"><label id="sscRollNum-error"
                                    class="text-danger" for="sscRollNum" style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscRegNum" class="form-label">SSC Registration: <span
                                        class="text-danger">*</span> </label>
                                <input type="number" class="form-control required" id="sscRegNum" name="ssc_reg_num" value="{{ old('ssc_reg_num', $applicant->ssc_reg_num) }}"
                                    aria-invalid="false"><label id="sscRegNum-error" class="text-danger"
                                    for="sscRegNum" style="display: none;"></label>
                            </div>
                        </div>
                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscSession" class="form-label">SSC Session: <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="sscSession"
                                    name="ssc_session" value="{{ old('ssc_session', $applicant->ssc_session) }}"  aria-invalid="false"><label id="sscSession-error"
                                    class="text-danger" for="sscSession" style="display: none;"></label>
                            </div>
                        </div>
                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscGPA" class="form-label">SSC GPA: <span class="text-danger">*</span>
                                </label>
                                <input type="number" class="form-control required" id="sscGPA" name="ssc_gpa" value="{{ old('ssc_gpa', $applicant->ssc_gpa) }}"
                                    aria-invalid="false"><label id="sscGPA-error" class="text-danger" for="sscGPA"
                                    style="display: none;"></label>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-12 mt-3">
                        <h4>Subject Related Information</h4>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <h5>Main/Compulsory Subjects</h5>
                            <div class="controls">
                                @if (!empty($compulsory_subjects))
                                    @foreach ($compulsory_subjects as $key=>$compulsorySubject)
                                        <fieldset>
                                            <input type="checkbox" id="checkbox_{{$key}}" value="{{ $compulsorySubject->subject_id ?? '' }}" name="{{ $compulsorySubject->subject->subject_name ?? '' }}" checked="" disabled="">
                                            <label for="checkbox_{{$key}}">{{ $compulsorySubject->subject->subject_name ?? '' }}</label>
                                        </fieldset>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <h5>Elective/Optional Subjects</h5>
                            <div class="controls">
                                @if (!empty($group_common))
                                    @foreach ($group_common as $key=>$g_common)
                                        <fieldset>
                                            <input type="checkbox" id="checkbox_{{$key}}" value="{{ $g_common->subject_id ?? '' }}" name="elective_common" checked="" disabled="" >
                                            <label for="checkbox_{{$key}}">{{ $g_common->subject->subject_name ?? '' }}</label>
                                        </fieldset>
                                    @endforeach
                                @endif
                            </div>

                            <h5>Select One <span class="text-danger">*</span></h5>
                                <div class="controls" id="elective-section">
                                    @if (!empty($group_elective))
                                        @foreach ($group_elective as $key => $g_elective)
                                            <fieldset>
                                                <input 
                                                    type="radio" required
                                                    id="elective_{{ $key }}" 
                                                    name="elective_subject"
                                                    value="{{ $g_elective->subject_id }}" 
                                                    data-subject-name="{{ $g_elective->subject->subject_name }}"
                                                >
                                                <label for="elective_{{ $key }}">{{ $g_elective->subject->subject_name }}</label>
                                            </fieldset>
                                        @endforeach
                                    @endif
                                </div>
                        </div>

                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <h5>Additional/4th Subjects <span class="text-danger">*</span></h5>
                            <div class="controls" id="optional-section">
                                @if (!empty($group_optional))
                                    @foreach ($group_optional as $key => $g_optional)
                                        <fieldset>
                                            <input 
                                                type="radio" required
                                                id="radio_optional_{{ $key }}" 
                                                name="optional_subject"
                                                value="{{ $g_optional->subject_id }}"
                                                data-optional-subject-name="{{ $g_optional->subject->subject_name }}"
                                            >
                                            <label for="radio_optional_{{ $key }}">{{ $g_optional->subject->subject_name }}</label>
                                        </fieldset>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                </div>

                <div class="row py-2 px-3 mb-3 text-white form__head">
                    Guardian Info
                </div>
                <div class="row py-2 form__body">
                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="ftherName" class="form-label"> Father's Name (English): <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="ftherName" name="fther_name" 
                                value="{{ old('fther_name', $applicant->fther_name) }}" aria-invalid="false">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="ftherNID" class="form-label"> Father's NID Number: </label>
                                <input type="text" class="form-control" id="ftherNID" name="fther_nid" value="{{ old('fther_nid', $applicant->fther_nid) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherDOB" class="form-label">Father Date of Birth : </label>
                                <input type="date" class="form-control" id="fatherDOB" name="father_dob" value="{{ old('father_dob', $applicant->father_dob) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherMobile" class="form-label"> Father's Mobile Number: <span class="text-danger">*</span></label>
                                <input type="number" class="form-control required" id="fatherMobile" name="father_mobile" value="{{ old('father_mobile', $applicant->father_mobile) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherOccupation" class="form-label"> Father's Occupation: <span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" id="fatherOccupation" name="father_occupation" value="{{ old('father_occupation', $applicant->father_occupation) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherIncome" class="form-label"> Father's Monthly Income: <span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" id="fatherIncome" name="father_income" value="{{ old('father_income', $applicant->father_income) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherName" class="form-label"> Mother's Name (English): <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="motherName" name="mother_name" value="{{ old('mother_name', $applicant->mother_name) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherNID" class="form-label"> Mother's NID Number: </label>
                                <input type="text" class="form-control" id="motherNID" name="mother_nid"  value="{{ old('mother_nid', $applicant->mother_nid) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherDOB" class="form-label">Mother Date of Birth : </label>
                                <input type="date" class="form-control" id="motherDOB" name="mother_dob"  value="{{ old('mother_dob', $applicant->mother_dob) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherMobile" class="form-label"> Mother's Mobile Number: </label>
                                <input type="number" class="form-control" id="motherMobile" name="mother_mobile"  value="{{ old('mother_mobile', $applicant->mother_mobile) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherOccupation" class="form-label"> Mother's Occupation: </label>
                                <input type="text" class="form-control" id="motherOccupation" name="mother_occupation"  value="{{ old('mother_occupation', $applicant->mother_occupation) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherIncome" class="form-label"> Mother's Monthly Income: </label>
                                <input type="text" class="form-control" id="motherIncome" name="mother_income"  value="{{ old('mother_income', $applicant->mother_income) }}">
                            </div>
                        </div>
                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="GuardianSelection" class="form-label">
                                    Guardian : <span class="text-danger">*</span>
                                </label>
                                <select class="form-select form-control required" id="GuardianSelection" name="guardian_selection">
                                    <option value="">Select Guardian</option>
                                    <option value="Father" {{ $applicant->guardian_selection == 'Father' ? 'selected' : '' }}>Father</option>
                                    <option value="Mother" {{ $applicant->guardian_selection == 'Mother' ? 'selected' : '' }}>Mother</option>
                                    <option value="Other" {{ $applicant->guardian_selection == 'Other' ? 'selected' : '' }}>Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2 guardian-field">
                            <div class="form-group">
                                <label for="guardianName" class="form-label"> Guardian's Name (English): <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="guardianName" name="guardian_name" value="{{ old('guardian_name', $applicant->guardian_name) }}">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2 guardian-field">
                            <div class="form-group">
                                <label for="gardianNID" class="form-label"> Guardian's NID Number: </label>
                                <input type="text" class="form-control" id="gardianNID" name="gardian_nid" value="{{ old('gardian_nid', $applicant->gardian_nid) }}">
                            </div>
                        </div>
                        <div class="col-md-3 mb-2 guardian-field">
                            <div class="form-group">
                                <label for="guardianMobile" class="form-label"> Guardian's Mobile Number: <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="guardianMobile" name="guardian_mobile"  value="{{ old('guardian_mobile', $applicant->guardian_mobile) }}">
                            </div>
                        </div>

                    </div>


                <div class="row py-2 px-3 mb-3 text-white form__head">
                    Address
                </div>
                <div class="row py-2 form__body">
                    <div class="col-md-12 mb-2">
                        <h4>Present Address</h4>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="villagePresent" class="form-label"> Village/Mohalla/Ward No.: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="villagePresent" name="village_present" value="{{ old('village_present', $applicant->village_present) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="postPresent" class="form-label"> Post Office: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="postPresent" name="post_present" value="{{ old('post_present', $applicant->post_present) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="policePresent" class="form-label"> Police Station: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="policePresent" name="police_present" value="{{ old('police_present', $applicant->police_present) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="districtPresent" class="form-label"> District: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="districtPresent" name="district_present" value="{{ old('district_present', $applicant->district_present) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="postcodePresent" class="form-label"> Postal Code: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="postcodePresent" name="postcode_present" value="{{ old('postcode_present', $applicant->postcode_present) }}">
                        </div>
                    </div>
                    <div class="col-md-12 mb-2">
                        <h4>Permanent Address</h4>
                    </div>
                    <div class="col-md-12 mb-2">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="sameAsPresent" name="sameAsPresent" value="yes">
                            <label class="form-check-label" for="sameAsPresent">Same as Present Address</label>
                        </div>
                    </div>

                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="villagePermanent" class="form-label"> Village/Mohalla/Ward No.: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="villagePermanent" name="village_permanent" value="{{ old('village_permanent', $applicant->village_permanent) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="postPermanent" class="form-label"> Post Office: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="postPermanent" name="post_permanent" value="{{ old('post_permanent', $applicant->post_permanent) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="policePermanent" class="form-label"> Police Station: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="policePermanent" name="police_permanent" value="{{ old('police_permanent', $applicant->police_permanent) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="districtPermanent" class="form-label"> District: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="districtPermanent" name="district_permanent" value="{{ old('district_permanent', $applicant->district_permanent) }}">
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="form-group">
                            <label for="postcodePermanent" class="form-label"> Postal Code: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="postcodePermanent" name="postcode_permanent" value="{{ old('postcode_permanent', $applicant->postcode_permanent) }}">
                        </div>
                    </div>

                    <div class="col-md-12 mb-2">
                        <h4>Quota/Additional Information</h4>
                    </div>

                    <div class="col-md-6 mb-2">
                        <div class="form-group">
                            <h5>Special Quota: freedom fighters / pets / disabled: <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <fieldset>
                                    <input type="radio" name="QuotaSelection" id="QuotaYes" value="Yes" required="">
                                    <label for="QuotaYes">Yes</label>
                                </fieldset>
                                <fieldset>
                                    <input type="radio" name="QuotaSelection" id="QuotaNo" value="No" required="">
                                    <label for="QuotaNo">No</label>
                                </fieldset>
                                <div class="help-block"></div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 mb-2 quota-field" style="display: none;">
                        <div class="form-group">
                            <label for="specialQuata" class="form-label"> <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="specialQuata" name="specialQuata" placeholder="Type Your Quota">
                        </div>
                    </div>


                    <div class="col-md-6 mb-2">
                        <div class="form-group">
                            <h5>Whether the student belongs to any community: <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <fieldset>
                                    <input type="radio" name="communitySelection" id="CommunityYes" value="Yes" required="">
                                    <label for="CommunityYes">Yes</label>
                                </fieldset>
                                <fieldset>
                                    <input type="radio" name="communitySelection" id="CommunityNo" value="No" required="">
                                    <label for="CommunityNo">No</label>
                                </fieldset>
                                <div class="help-block"></div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 mb-2 community-field" style="display: none;">
                        <div class="form-group">
                            <label for="community" class="form-label"> <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="community" name="community" placeholder="Type Your Community">
                        </div>
                    </div>
                </div>

                <div class="row py-2 px-3 mb-3 text-white form__head">
                    Payment Info
                </div>
                <div class="row py-2 form__body">
                    <div class="col-md-3">
                        <div class="form-group validate">
                            <h5>Payment Method <span class="text-danger">*</span></h5>
                            <div class="controls">

                                <fieldset>
                                    <input name="group_payment" type="radio" id="radio_2" checked="" value="Rocket" aria-invalid="false">
                                    <label for="radio_2">Rocket</label>
                                </fieldset>
                                <div class="help-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="PaymentFromAccount" class="form-label"> Payment Bank/Slip/Account Mobile Number:</label>
                            <input type="text" class="form-control" id="PaymentFromAccount" name="payment_from_account" value="{{ old('payment_from_account', $applicant->payment_from_account) }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="PaymentAmount" class="form-label"> Payment Amount: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="PaymentAmount" name="payment_amount" value="3000" readonly="">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="paymentTNXid" class="form-label"> TnxID (Transaction ID): </label>
                            <input type="text" class="form-control" id="paymentTNXid" name="payment_tnxid" value="{{ old('payment_tnxid', $applicant->payment_tnxid) }}">
                        </div>
                    </div>
                    <div class="col-md-3" style="display:none">
                        <div class="form-group">
                            <label for="hscgruop" class="form-label"> HSC Group: <span class="text-danger">*</span> </label>
                            <input type="text" class="form-control required" id="hscgruop" name="hscgruop" value="{{ old('hscgruop', $applicant->hscgruop) }}">
                        </div>
                    </div>
                    <h4>বিশেষ দ্রষ্টব্য:
                        <br>* ফাইনাল সাবমিট এর আগে অবশ্যই নিজ দায়িত্বে সকল তথ্য সঠিক আছে কিনা, দেখে সাবমিট করতে হবে।
                    </h4>
                    <div class="col-md-12 text-center">
                        {{-- <img src="../payment-flow.png" alt="Payment Flow"> --}}
                    </div>
                </div>
                
                <div class="row mt-3 flex justify-content-end">
                    <button class="btn btn-submit submitBtn">Update</button>
                </div>
            </form>
        </div>
    </div>
    <script>
        const input = document.querySelector('.image-uploader__input');
        const previewImage = document.querySelector('.image-uploader__preview-image');

        input.addEventListener('change', () => {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = (event) => {
                previewImage.src = event.target.result;
            };

            reader.readAsDataURL(file);
        });
    </script>
@endsection

@section('scripts')
   <script>
    // Disable mouse wheel & arrow keys on all number inputs
    document.querySelectorAll('input[type="number"]').forEach(function(input) {
        input.addEventListener('wheel', function(e) {
            e.preventDefault();
        });
        input.addEventListener('keydown', function(e) {
            if (e.key === 'ArrowUp' || e.key === 'ArrowDown') {
                e.preventDefault();
            }
        });
    });
   </script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const electiveRadios = document.querySelectorAll('input[name="elective_subject"]');
        const optionalSection = document.getElementById('optional-section');
        // Store elective subject data so we can re-append as needed
        const electiveSubjects = Array.from(electiveRadios).map(radio => ({
            id: radio.value,
            name: radio.getAttribute('data-subject-name'),
        }));
        
        function appendOtherElective(unselectedId) {
            // First, remove any previously added elective subjects
            document.querySelectorAll('.appended-elective').forEach(el => el.remove());
            // Append unselected elective subject
            electiveSubjects.forEach(subject => {
                if (subject.id !== unselectedId) {
                    const fieldset = document.createElement('fieldset');
                    fieldset.classList.add('appended-elective');

                    const input = document.createElement('input');
                    input.type = 'radio';
                    input.id = 'radio_optional_' + subject.id;
                    input.name = 'optional_subject';
                    input.value = subject.id;

                    const label = document.createElement('label');
                    label.htmlFor = input.id;
                    label.textContent = subject.name;
                    label.style.paddingLeft = '4px';

                    fieldset.appendChild(input);
                    fieldset.appendChild(label);

                    optionalSection.appendChild(fieldset);
                }
            });
        }
        // Attach change listeners
        electiveRadios.forEach(radio => {
            radio.addEventListener('change', function () {
                appendOtherElective(this.value);
            });
        });
    });

    
</script>

   <script >
    document.addEventListener('DOMContentLoaded', function () {
        const electiveRadios = document.querySelectorAll('input[name="elective_subject"]');
        const optionalFields = document.querySelectorAll('#optional-section input[type="radio"]');

        function updateOptionalVisibility(selectedElectiveName) {
            optionalFields.forEach(function (optRadio) {
                const optionalName = optRadio.dataset.optionalSubjectName;

                // If elective is "Higher Math" and optional is "Agriculture", hide it
                if (selectedElectiveName === 'Higher Math' && optionalName === 'Agriculture') {
                    optRadio.closest('fieldset').style.display = 'none';
                    optRadio.checked = false; // Uncheck if it was selected
                } else {
                    optRadio.closest('fieldset').style.display = 'block';
                }
            });
        }

        // Initial run in case a radio is pre-selected
        electiveRadios.forEach(function (radio) {
            if (radio.checked) {
                updateOptionalVisibility(radio.dataset.subjectName);
            }
        });

        // Add event listeners to all elective radios
        electiveRadios.forEach(function (radio) {
            radio.addEventListener('change', function () {
                const selectedName = this.dataset.subjectName;
                updateOptionalVisibility(selectedName);
            });
        });
    });
</script>
@endsection
