<!DOCTYPE html>
<html lang="en">
<head>
    <title>HSC Admission Form</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    
    <link href="{{asset('assets/vendor/select2/dist/css/select2.min.css')}}" rel="stylesheet" type="text/css">
    <link href="{{asset('assets/vendor/datatables/dataTables.bootstrap4.min.css')}}" rel="stylesheet">
    <link href="{{asset('assets/vendor/jquery-ui/jquery-ui.min.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.16/css/bootstrap-multiselect.min.css">

    <!-- In your layout (e.g., app.blade.php) -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <style>
        /* Chrome, Safari, Edge, Opera */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }

        .nav-tabs .nav-link.active {
            background-color: #0d6efd;
            color: #fff;
            font-weight: bold;
        }
        .nav-tabs .nav-link {
            color: #0d6efd;
            border: none;
            transition: background-color 0.3s;
        }
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
        }

        .image-uploader {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative; /* Add position relative */
        }

        .image-uploader__label {
            display: flex;
            flex-direction: column;
            align-items: center;
            cursor: pointer;
            position: relative; /* Add position relative */
        }

        .image-uploader__icon-overlay {
            position: absolute;
            top: 50%; /* Align vertically centered */
            left: 50%; /* Align horizontally centered */
            transform: translate(-50%, -50%); /* Center the icon */
            width: 100%;
            height: calc(100%); /* Height equal to parent minus icon height */
            background-color: rgba(0, 0, 0, 0.2); /* Transparent black background */
            border-radius: 50%; /* Rounded border */
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0.3;
        }

        .image-uploader__icon-overlay i {
            color: #ffffff; /* Icon color */
            font-size: 24px; /* Icon size */
        }

        /* Your existing styles */
        .image-uploader__preview {
            overflow: hidden;
        }

        .image-uploader__input {
            display: none;
        }
    </style>

</head>

<body>


                    {{-- <div class="row">
                        <h4>Present Address</h4>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="villagePresent" class="form-label"> Village/Mohalla/Ward No.: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="villagePresent" name="village_present">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="postPresent" class="form-label"> Post Office: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="postPresent" name="post_present">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="policePresent" class="form-label"> Police Station: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="policePresent" name="police_present">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="districtPresent" class="form-label"> District: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="districtPresent" name="district_present">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="postcodePresent" class="form-label"> Postal Code: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="postcodePresent" name="postcode_present">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <h4>Permanent Address</h4>
                    </div>
                    <div class="row">
                        <div class="col-md-12 mb-2">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="sameAsPresent" name="sameAsPresent" value="yes">
                                <label class="form-check-label" for="sameAsPresent">Same as Present Address</label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="villagePermanent" class="form-label"> Village/Mohalla/Ward No.: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="villagePermanent" name="village_permanent">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="postPermanent" class="form-label"> Post Office: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="postPermanent" name="post_permanent">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="policePermanent" class="form-label"> Police Station: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="policePermanent" name="police_permanent">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="districtPermanent" class="form-label"> District: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="districtPermanent" name="district_permanent">
                            </div>
                        </div>
                        <div class="col-md-4 mb-2">
                            <div class="form-group">
                                <label for="postcodePermanent" class="form-label"> Postal Code: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="postcodePermanent" name="postcode_permanent">
                            </div>
                        </div>
                    </div>

                     --}}
    <div class="container mt-5">

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif



        <form class="needs-validation" id="multiStepForm" method="POST" action="{{ route('hsc-admission.store.science')}}" novalidate enctype="multipart/form-data">
            @csrf
            <!-- Tab Navigation -->

            <ul class="nav nav-tabs justify-content-between border-0 bg-light p-2 rounded shadow-sm mb-5" id="formTabs" role="tablist">
                <li class="nav-item flex-fill text-center" role="presentation">
                    <button class="nav-link active rounded-pill fw-semibold" id="step1-tab" data-bs-toggle="tab"
                        data-bs-target="#step1" type="button" role="tab">
                        <i class="bi bi-person-circle me-1"></i> Applicant Info
                    </button>
                </li>
                <li class="nav-item flex-fill text-center" role="presentation">
                    <button class="nav-link rounded-pill fw-semibold disabled" id="step2-tab" data-bs-toggle="tab"
                        data-bs-target="#step2" type="button" role="tab" tabindex="-1" aria-disabled="true">
                        <i class="bi bi-book-half me-1"></i> Academic Info
                    </button>
                </li>
                <li class="nav-item flex-fill text-center" role="presentation">
                    <button class="nav-link rounded-pill fw-semibold disabled" id="step3-tab" data-bs-toggle="tab"
                        data-bs-target="#step3" type="button" role="tab" tabindex="-1" aria-disabled="true">
                        <i class="bi bi-people-fill me-1"></i> Guardian Info
                    </button>
                </li>
                <li class="nav-item flex-fill text-center" role="presentation">
                    <button class="nav-link rounded-pill fw-semibold disabled" id="step4-tab" data-bs-toggle="tab"
                        data-bs-target="#step4" type="button" role="tab" tabindex="-1" aria-disabled="true">
                        <i class="bi bi-geo-alt-fill me-1"></i> Address
                    </button>
                </li>
                <li class="nav-item flex-fill text-center" role="presentation">
                    <button class="nav-link rounded-pill fw-semibold disabled" id="step5-tab" data-bs-toggle="tab"
                        data-bs-target="#step5" type="button" role="tab" tabindex="-1" aria-disabled="true">
                        <i class="bi bi-credit-card-2-front-fill me-1"></i> Payment Info
                    </button>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content">
                <!-- Step 1 -->
                <div class="tab-pane fade show active" id="step1" role="tabpanel">
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="admissionRoll" class="form-label"> SSC Roll: <span
                                        class="text-danger">*</span> </label>
                                <input type="number" class="form-control required" id="admissionRoll"
                                    name="admission_roll" aria-invalid="false">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="sessionYear" class="form-label">HSC Session : <span class="text-danger">*</span></label>
                                <select class="form-select required" id="sessionYear" name="session_year" aria-invalid="false">
                                    <option value="">Select HSC Session</option>
                                    <option value="9">2023-2024</option>
                                    <option value="10">2024-2025</option>
                                    <option value="11">2025-2026</option>
                                    <option value="12">2026-2027</option>
                                    <option value="13">2027-2028</option>
                                    <option value="14">2028-2029</option>
                                    <option value="15">2029-2030</option>
                                    <option value="16">2030-2031</option>
                                    <option value="17">2031-2032</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="classRoll" class="form-label"> Class Roll: (To be filled by the college)
                                </label>
                                <input type="text" class="form-control" id="classRoll" name="class_roll"
                                    readonly="">
                                <small id="classRoll-error-msg" class="form-text text-muted text-danger"></small>
                            </div>
                        </div>

                        <script>
                            function checkDuplicate() {
                                var classRoll = document.getElementById('classRoll').value;
                                var sessionYear = document.getElementById('sessionYear').value;
                                var errorElem = document.getElementById('classRoll-error-msg');

                                // Remove any previous error message
                                errorElem.textContent = '';

                                if (classRoll === '' || sessionYear === '') {
                                    // If either input is empty, no need to check for duplicates
                                    errorElem.textContent = '';
                                    document.getElementById('classRoll').setCustomValidity('');
                                    return;
                                }

                                // Create a new XMLHttpRequest object
                                var xhr = new XMLHttpRequest();
                                xhr.open('POST', 'check_duplicate.php', true);
                                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                                // Handle the response from the server
                                xhr.onreadystatechange = function() {
                                    if (xhr.readyState == 4 && xhr.status == 200) {
                                        var response = JSON.parse(xhr.responseText);
                                        if (response.exists) {
                                            errorElem.textContent = 'Class Roll already exists for the selected HSC Session!';
                                            errorElem.style.color = 'red';
                                            document.getElementById('classRoll').setCustomValidity(
                                                'Class Roll already exists for the selected HSC Session!');
                                        } else {
                                            document.getElementById('classRoll').setCustomValidity('');
                                        }
                                    }
                                };

                                // Send the request with the classRoll and sessionYear parameters
                                xhr.send('classRoll=' + encodeURIComponent(classRoll) + '&sessionYear=' + encodeURIComponent(sessionYear));
                            }

                            document.getElementById('classRoll').addEventListener('input', checkDuplicate);
                            document.getElementById('sessionYear').addEventListener('change', checkDuplicate);
                        </script>


                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="meritPosition" class="form-label"> Merit Position: </label>
                                <input type="text" class="form-control" id="meritPosition" name="merit_position"
                                    aria-invalid="false">
                            </div>
                        </div>



                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="first_name" class="form-label"> First Name (English): <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="first_name"
                                    name="first_name" aria-invalid="false">
                            </div>
                        </div>
                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="last_name" class="form-label"> Last Name (English): <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="last_name"
                                    name="last_name" aria-invalid="false">
                            </div>
                        </div>
                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="wapplicantMobile2" class="form-label"> Applicant's Mobile Number: <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="wapplicantMobile2"
                                    name="applicant_mobile" aria-invalid="false"><label id="wapplicantMobile2-error"
                                    class="text-danger" for="wapplicantMobile2" style="display: none;"></label>
                                <small class="text-danger" id="mobile-error-msg"></small>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group ">
                                <label for="email" class="form-label"> Email</label>
                                <input type="email" class="form-control " id="email"
                                    name="email" aria-invalid="false">
                            </div>
                        </div>

                        <script>
                            document.getElementById('wapplicantMobile2').addEventListener('input', function(e) {
                                var mobileNumber = e.target.value;
                                var errorElem = document.getElementById('mobile-error-msg');

                                // Remove any previous error message
                                errorElem.textContent = '';

                                // Validate if input contains exactly 11 digits
                                if (!/^\d{11}$/.test(mobileNumber)) {
                                    errorElem.textContent = 'Mobile number must be exactly 11 digits and contain only numbers (0-9).';
                                    e.target.setCustomValidity('Invalid input');
                                } else {
                                    e.target.setCustomValidity('');
                                }
                            });
                        </script>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="bloodGroup" class="form-label">Blood Group : </label>
                                <select class="form-select" id="bloodGroup" name="blood_group" aria-invalid="false">
                                    <option value="">Select Blood Group</option>
                                    <option value="A+">A+</option>
                                    <option value="A-">A-</option>
                                    <option value="B+">B+</option>
                                    <option value="B-">B-</option>
                                    <option value="O+">O+</option>
                                    <option value="O-">O-</option>
                                    <option value="AB+">AB+</option>
                                    <option value="AB-">AB-</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="nid" class="form-label"> Birth Certificate/NID Number: </label>
                                <input type="text" class="form-control" id="nid" name="nid"
                                    aria-invalid="false">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="wdate2" class="form-label">Date of Birth : <span
                                        class="text-danger">*</span></label>
                                <input type="date" class="form-control required" id="wdate2" name="dob"
                                    aria-invalid="false">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="maritalStatus" class="form-label">Marital Status : <span
                                        class="text-danger">*</span></label>
                                <select class="form-select required" id="maritalStatus" name="marital_status"
                                    aria-invalid="false">
                                    <option value="">Select Marital Status</option>
                                    <option value="Married">Married</option>
                                    <option value="Unmarried">Unmarried</option>
                                    <option value="Divorced">Divorced</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="gender" class="form-label">Gender : <span
                                        class="text-danger">*</span></label>
                                <select class="form-select required" id="gender" name="gender"
                                    aria-invalid="false">
                                    <option value="">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="nationality" class="form-label">Nationality: </label>
                                <input type="text" class="form-control" id="nationality" name="nationality" value="Bangladeshi" readonly
                                    aria-invalid="false">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="religion" class="form-label">Religion : <span class="text-danger">*</span></label>
                                <select class="form-select required" id="religion" name="religion"
                                    aria-invalid="false">
                                    <option value="">Select Religion</option>
                                    <option value="Islam">Islam</option>
                                    <option value="Hinduism">Hinduism</option>
                                    <option value="Buddhism">Buddhism</option>
                                    <option value="Christianity">Christianity</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group validate">
                                <label for="branch_id" class="form-label">Branch : <span class="text-danger">*</span></label>
                                <select class="form-select required" id="branch_id" name="branch_id" aria-invalid="false">
                                    <option value="">Select Branch</option>
                                    @if ($branches)
                                        @foreach ($branches as $branch)
                                            <option value="{{ $branch->id }}">
                                                {{ $branch->branch_name }} ({{ $branch->address }})
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="image-uploader">
                                <label for="image" class="form-label">Applicant Passport Size Photo: <span class="text-danger">*</span></label>
                                <label for="imageFile" class="image-uploader__label">
                                    <!-- Icon overlay with transparent background -->
                                    <div class="image-uploader__icon-overlay">
                                        <i class="fas fa-cloud-upload-alt"></i>
                                    </div>
                                    <!-- Preview image -->
                                    <img src="{{ asset('assets/img/boy.png') }}" alt="Preview image" class="image-uploader__preview-image img-thumbnail rounded-circle p-1" style="width: 140px; height: 140px;">
                                    <!-- File input -->
                                    <input type="file" name="profile_image" class="image-uploader__input" id="imageFile" accept="image/*" required>
                                </label>
                            </div>
                            <div id="imageError" class="text-danger text-center small d-none">Please select a photo.</div>

                            {{-- Laravel error display --}}
                            @error('profile_image')
                                <div class="text-danger small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <!-- tab next and prev -->
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary" disabled onclick="nextTab()">Previous</button>
                        <button type="button" class="btn btn-secondary" onclick="validateStep1()">Next</button>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="tab-pane fade" id="step2" role="tabpanel">
                    <h4>SSC Educational Information</h4>
                    <div class="row">
                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="boardSelect" class="form-label">SSC Board : <span
                                        class="text-danger">*</span></label>
                                <select class="form-select required" id="boardSelect" name="board_select"
                                    aria-invalid="false">
                                    <option value="">Select Board</option>
                                    <option value="Rajshahi">Rajshahi</option>
                                    <option value="Dhaka">Dhaka</option>
                                    <option value="Cumilla">Cumilla</option>
                                    <option value="Chittagong">Chittagong</option>
                                    <option value="Barisal">Barisal</option>
                                    <option value="Dinajpur">Dinajpur</option>
                                    <option value="Jessore">Jessore</option>
                                    <option value="Mymensingh">Mymensingh</option>
                                    <option value="Sylhet">Sylhet</option>
                                    <option value="Madrasah">Madrasah</option>
                                    <option value="Technical">Technical</option>
                                    <option value="Others">Others</option>

                                </select><label id="boardSelect-error" class="text-danger" for="boardSelect"
                                    style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="passingYear" class="form-label">SSC Passing Year : <span
                                        class="text-danger">*</span></label>
                                <select class="form-select required" id="passingYear" name="passing_year"
                                    aria-invalid="false">
                                    <option value="">Select Year</option>
                                    <option value="2024">2024</option>
                                    <option value="2023">2023</option>
                                    <option value="2022">2022</option>

                                </select><label id="passingYear-error" class="text-danger" for="passingYear"
                                    style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-2">
                            <div class="form-group validate">
                                <label for="InstituteName" class="form-label"> Institute Name: <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="InstituteName"
                                    name="institute_name" aria-invalid="false"><label id="InstituteName-error"
                                    class="text-danger" for="InstituteName" style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscRollNum" class="form-label">SSC Roll: <span
                                        class="text-danger">*</span> </label>
                                <input type="number" class="form-control required" id="sscRollNum"
                                    name="ssc_roll_num" aria-invalid="false"><label id="sscRollNum-error"
                                    class="text-danger" for="sscRollNum" style="display: none;"></label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscRegNum" class="form-label">SSC Registration: <span
                                        class="text-danger">*</span> </label>
                                <input type="number" class="form-control required" id="sscRegNum" name="ssc_reg_num"
                                    aria-invalid="false"><label id="sscRegNum-error" class="text-danger"
                                    for="sscRegNum" style="display: none;"></label>
                            </div>
                        </div>
                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscSession" class="form-label">SSC Session: <span
                                        class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="sscSession"
                                    name="ssc_session" aria-invalid="false"><label id="sscSession-error"
                                    class="text-danger" for="sscSession" style="display: none;"></label>
                            </div>
                        </div>
                        <div class="col-md-2 mb-2">
                            <div class="form-group validate">
                                <label for="sscGPA" class="form-label">SSC GPA: <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control required" id="sscGPA" name="ssc_gpa"
                                    aria-invalid="false"><label id="sscGPA-error" class="text-danger" for="sscGPA"
                                    style="display: none;"></label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 mt-3">
                            <h4>Subject Related Information</h4>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5>Main/Compulsory Subjects</h5>
                                <div class="controls">
                                    @if (!empty($compulsory_subjects))
                                        @foreach ($compulsory_subjects as $key=>$compulsorySubject)
                                            <fieldset>
                                                <input type="checkbox" id="checkbox_{{$key}}" value="{{ $compulsorySubject->subject_id ?? '' }}" name="{{ $compulsorySubject->subject->subject_name ?? '' }}" checked="" disabled="">
                                                <label for="checkbox_{{$key}}">{{ $compulsorySubject->subject->subject_name ?? '' }}</label>
                                            </fieldset>
                                        @endforeach
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5>Elective/Optional Subjects</h5>
                                <div class="controls">
                                    @if (!empty($group_common))
                                        @foreach ($group_common as $key=>$g_common)
                                            <fieldset>
                                                <input type="checkbox" id="checkbox_{{$key}}" value="{{ $g_common->subject_id ?? '' }}" name="elective_common" checked="" disabled="" >
                                                <label for="checkbox_{{$key}}">{{ $g_common->subject->subject_name ?? '' }}</label>
                                            </fieldset>
                                        @endforeach
                                    @endif
                                </div>

                                <h5>Select One <span class="text-danger">*</span></h5>
                                    <div class="controls" id="elective-section">
                                        @if (!empty($group_elective))
                                            @foreach ($group_elective as $key => $g_elective)
                                                <fieldset>
                                                    <input 
                                                        type="radio" required
                                                        id="elective_{{ $key }}" 
                                                        name="elective_subject"
                                                        value="{{ $g_elective->subject_id }}" 
                                                        data-subject-name="{{ $g_elective->subject->subject_name }}"
                                                    >
                                                    <label for="elective_{{ $key }}">{{ $g_elective->subject->subject_name }}</label>
                                                </fieldset>
                                            @endforeach
                                        @endif
                                    </div>
                            </div>

                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <h5>Additional/4th Subjects <span class="text-danger">*</span></h5>
                                <div class="controls" id="optional-section">
                                    @if (!empty($group_optional))
                                        @foreach ($group_optional as $key => $g_optional)
                                            <fieldset>
                                                <input 
                                                    type="radio" required
                                                    id="radio_optional_{{ $key }}" 
                                                    name="optional_subject"
                                                    value="{{ $g_optional->subject_id }}"
                                                    data-optional-subject-name="{{ $g_optional->subject->subject_name }}"
                                                >
                                                <label for="radio_optional_{{ $key }}">{{ $g_optional->subject->subject_name }}</label>
                                            </fieldset>
                                        @endforeach
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- tab next and prev -->
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary" onclick="nextTab('step1')">Previous</button>
                        <button type="button" class="btn btn-secondary" onclick="validateStep2()">Next</button>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="tab-pane fade" id="step3" role="tabpanel">
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherName" class="form-label"> Father's Name (English): <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="fatherName" name="father_name" aria-invalid="false">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherNID" class="form-label"> Father's NID Number: </label>
                                <input type="text" class="form-control" id="fatherNID" name="father_nid">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherDOB" class="form-label">Father Date of Birth : </label>
                                <input type="date" class="form-control" id="fatherDOB" name="father_dob">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherMobile" class="form-label"> Father's Mobile Number: <span class="text-danger">*</span></label>
                                <input type="number" class="form-control required" id="fatherMobile" name="father_mobile">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="father_occupation">Father's occupation </label>
                                {{ generateDropdown($occupations, 'class="form-control select2 father_occupation" id="father_occupation" name="father_occupation"', old('father_occupation'), 'Select Option') }}
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="fatherIncome" class="form-label"> Father's Monthly Income: <span class="text-danger">*</span></label>
                                <input type="text" class="form-control required" id="fatherIncome" name="father_income">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherName" class="form-label"> Mother's Name (English): <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="motherName" name="mother_name">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherNID" class="form-label"> Mother's NID Number: </label>
                                <input type="text" class="form-control" id="motherNID" name="mother_nid">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherDOB" class="form-label">Mother Date of Birth : </label>
                                <input type="date" class="form-control" id="motherDOB" name="mother_dob">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherMobile" class="form-label"> Mother's Mobile Number: </label>
                                <input type="number" class="form-control" id="motherMobile" name="mother_mobile">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherOccupation">Mother's  occupation </label>
                                {{ generateDropdown($occupations, 'class="form-control select2 father_occupation" id="motherOccupation" name="mother_occupation"', old('mother_occupation'), 'Select Option') }}
                            </div>

                            {{-- <div class="form-group">
                                <label for="motherOccupation" class="form-label"> Mother's Occupation: </label>
                                <input type="text" class="form-control" id="motherOccupation" name="mother_occupation">
                            </div> --}}
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="motherIncome" class="form-label"> Mother's Monthly Income: </label>
                                <input type="text" class="form-control" id="motherIncome" name="mother_income">
                            </div>
                        </div>
                    </div>

                 

                    <div class="row">
                        <div class="col-md-3 mb-2 guardian-field">
                            <div class="form-group">
                                <label for="guardian_name" class="form-label">Guardian's Name (English): <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="guardian_name"
                                       value="{{old('guardian_name')}}" placeholder="Enter Gurdian Name">
                            </div>
                        </div>


                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="guardian_occupation" class="form-label">Guardian occupation </label>
                                {{ generateDropdown($occupations, 'class="form-control select2" name="guardian_occupation"', old('guardian_occupation'), 'Select Option') }}
                            </div>
                        </div>
                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="guardian_mobile" class="form-label">Guardian mobile </label>
                                <input type="tel" class="form-control" name="guardian_mobile"
                                       value="{{old('guardian_mobile')}}" placeholder="Enter Gurdian Mobile">
                            </div>
                        </div>

                        <div class="col-md-3 mb-2">
                            <div class="form-group">
                                <label for="guardian_relation" class="form-label">Relation with guardian </label>
                                {{ generateDropdown($guardian_relations, 'class="form-control select2" name="guardian_relation"', old('guardian_relation'), 'Select Option') }}
                            </div>
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="guardian_address" class="form-label">Guardian address </label>
                            <input type="text" class="form-control" name="guardian_address"
                                   value="{{old('guardian_address')}}" placeholder="Enter Guardian Address">
                        </div>


                        {{-- <div class="col-md-3 mb-2 guardian-field">
                            <div class="form-group">
                                <label for="gardianNID" class="form-label"> Guardian's NID Number: </label>
                                <input type="text" class="form-control" id="gardianNID" name="gardian_nid">
                            </div>
                        </div>
                        <div class="col-md-3 mb-2 guardian-field">
                            <div class="form-group">
                                <label for="guardianMobile" class="form-label"> Guardian's Mobile Number: <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="guardianMobile" name="guardian_mobile">
                            </div>
                        </div> --}}
                    </div>
                    <!-- tab next and prev -->
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary" onclick="nextTab('step2')">Previous</button>
                        <button type="button" class="btn btn-secondary" onclick="validateStep3()">Next</button>
                    </div>
                </div>

                <!-- Step 4 address -->
                <div class="tab-pane fade" id="step4" role="tabpanel">
                    {{-- Address Start --}}
                        <div class="row">
                            <div class="col-md-12 mb-2">
                                <h4>Present Address</h4>
                            </div>
                            
                            <div class="form-group col-md-3 mb-2">
                                <label for="present_division_id" class="form-label">Division</label>
                                <select class="form-control select2" id="present_division_id" name="present_division_id">
                                    <option value="">Select Division</option>
                                    @foreach($divisions as $division)
                                        <option value="{{ $division->id }}" {{ $selectedDivision == $division->id ? 'selected' : '' }}>
                                            {{ $division->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-3 mb-2">
                                <label for="present_district_id" class="form-label">District</label>
                                <select class="form-control select2" id="present_district_id" name="present_district_id">
                                    <option value="">Select District</option>
                                </select>
                            </div>

                            <div class="form-group col-md-3 mb-2">
                                <label for="present_upazila_id" class="form-label">Upazila</label>
                                <select class="form-control select2" id="present_upazila_id" name="present_upazila_id">
                                    <option value="">Select Upazila</option>
                                </select>
                            </div>

                            <div class="form-group col-md-3 mb-2">
                                <label for="present_union_id" class="form-label">Union</label>
                                <select class="form-control select2" id="present_union_id" name="present_union_id">
                                    <option value="">Select Union</option>
                                </select>
                            </div>
                            <div class="col-md-12 mb-2">
                                <label for="present_address" class="form-label">Address</label>
                                <div class="form-group">
                                    <textarea class="form-control" name="present_address" id="present_address"
                                              placeholder="Enter Present Address">{{old('present_address')}}</textarea>
                                </div>
                            </div>

                            <div class="col-md-12 mb-2">
                                (<input class="mx-2" type="checkbox" id="copyAddress"/>
                                <label for="copyAddress" class="form-label">Same as present address</label>)
                            </div>

                            <div class="col-md-12 mb-2">
                                <h4>Permanent Address</h4>
                            </div>
                            
                            <div class="form-group col-md-3 mb-2">
                                <label for="permanent_division_id" class="form-label">Division</label>
                                <select class="form-control select2" id="permanent_division_id" name="permanent_division_id">
                                    <option value="">Select Division</option>
                                    @foreach($divisions as $division)
                                        <option value="{{ $division->id }}" {{ $selectedDivision == $division->id ? 'selected' : '' }}>
                                            {{ $division->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-3 mb-2">
                                <label for="permanent_district_id" class="form-label">District</label>
                                <select class="form-control select2" id="permanent_district_id" name="permanent_district_id">
                                    <option value="">Select District</option>
                                </select>
                            </div>

                            <div class="form-group col-md-3 mb-2">
                                <label for="permanent_upazila_id" class="form-label">Upazila</label>
                                <select class="form-control select2" id="permanent_upazila_id" name="permanent_upazila_id">
                                    <option value="">Select Upazila</option>
                                </select>
                            </div>

                            <div class="form-group col-md-3 mb-2">
                                <label for="permanent_union_id" class="form-label">Union</label>
                                <select class="form-control select2" id="permanent_union_id" name="permanent_union_id">
                                    <option value="">Select Union</option>
                                </select>
                            </div>
                            <div class="col-md-12 mb-2">
                                <label for="permanent_address" class="form-label">Address</label>
                                <div class="form-group">
                                    <textarea class="form-control" name="permanent_address" id="permanent_address"
                                              placeholder="Enter Present Address">{{old('permanent_address')}}</textarea>
                                </div>
                            </div>


                        </div>
                        {{--  Address End --}}

                    

{{-- 

                    <div class="row">
                        <h4>Quota/Additional Information</h4>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-2">
                            <div class="form-group">
                                <h5>Special Quota: freedom fighters / pets / disabled: <span class="text-danger">*</span></h5>
                                {{-- <div class="controls">
                                    <fieldset>
                                        <input type="radio" name="QuotaSelection" id="QuotaYes" value="Yes" required="">
                                        <label for="QuotaYes">Yes</label>
                                    </fieldset>
                                    <fieldset>
                                        <input type="radio" name="QuotaSelection" id="QuotaNo" value="No" required="">
                                        <label for="QuotaNo">No</label>
                                    </fieldset>
                                    <div class="help-block"></div>
                                </div> --}
                            </div>
                        </div>

                        <div class="col-md-6 mb-2 quota-field" style="display: none;">
                            <div class="form-group">
                                <label for="specialQuata" class="form-label"> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="specialQuata" name="specialQuata" placeholder="Type Your Quota">
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 mb-2">
                            <div class="form-group">
                                <h5>Whether the student belongs to any community: <span class="text-danger">*</span></h5>
                                {{-- <div class="controls">
                                    <fieldset>
                                        <input type="radio" name="communitySelection" id="CommunityYes" value="Yes" required="">
                                        <label for="CommunityYes">Yes</label>
                                    </fieldset>
                                    <fieldset>
                                        <input type="radio" name="communitySelection" id="CommunityNo" value="No" required="">
                                        <label for="CommunityNo">No</label>
                                    </fieldset>
                                    <div class="help-block"></div>
                                </div> --}
                            </div>
                        </div>

                        <div class="col-md-6 mb-2 community-field" style="display: none;">
                            <div class="form-group">
                                <label for="community" class="form-label"> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="community" name="community" placeholder="Type Your Community">
                            </div>
                        </div>
                    </div> --}}

                    <!-- tab next and prev -->
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary" onclick="nextTab('step3')">Previous</button>
                        <button type="button" class="btn btn-secondary" onclick="validateStep4()">Next</button>
                    </div>
                </div>

                <!-- Step 5 payment info -->
                <div class="tab-pane fade" id="step5" role="tabpanel">

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group validate">
                                <h5>Payment Method <span class="text-danger">*</span></h5>
                                <div class="controls">

                                    <fieldset>
                                        <input name="group_payment" type="radio" id="radio_2" checked="" value="Rocket" aria-invalid="false">
                                        <label for="radio_2" class="form-label">Rocket</label>
                                    </fieldset>
                                    <div class="help-block"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="PaymentFromAccount" class="form-label"> Payment Bank/Slip/Account Mobile Number:</label>
                                <input type="text" class="form-control" id="PaymentFromAccount" name="payment_from_account" aria-invalid="false">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="PaymentAmount" class="form-label"> Payment Amount: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="PaymentAmount" name="payment_amount" value="3000" readonly="">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="paymentTNXid" class="form-label"> TnxID (Transaction ID): </label>
                                <input type="text" class="form-control" id="paymentTNXid" name="payment_tnxid">
                            </div>
                        </div>
                        <div class="col-md-3" style="display:none">
                            <div class="form-group">
                                <label for="hscgruop" class="form-label"> HSC Group: <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control required" id="hscgruop" name="hscgruop" value="science">
                            </div>
                        </div>
                        <h4>বিশেষ দ্রষ্টব্য:
                            <br>* ফাইনাল সাবমিট এর আগে অবশ্যই নিজ দায়িত্বে সকল তথ্য সঠিক আছে কিনা, দেখে সাবমিট করতে হবে।
                        </h4>
                        <div class="col-md-12 text-center">
                            {{-- <img src="../payment-flow.png" alt="Payment Flow"> --}}
                        </div>
                    </div>
                    <!-- tab next and prev -->
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary" onclick="nextTab('step4')">Previous</button>
                        <button class="btn btn-success" type="submit">Final Submit</button>
                    </div>
                </div>
            </div>
        </form>
    </div>

    
<script src="{{asset('assets/vendor/jquery/jquery.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.16/js/bootstrap-multiselect.min.js"></script>
<script src="{{asset('assets/vendor/select2/dist/js/select2.min.js')}}"></script>
<script src="{{asset('assets/vendor/jquery-easing/jquery.easing.min.js')}}"></script>
<script src="{{asset('assets/vendor/jquery-ui/jquery-ui.min.js')}}"></script>



<script>
// Disable mouse wheel & arrow keys on all number inputs
    document.querySelectorAll('input[type="number"]').forEach(function(input) {
        input.addEventListener('wheel', function(e) {
            e.preventDefault();
        });
        input.addEventListener('keydown', function(e) {
            if (e.key === 'ArrowUp' || e.key === 'ArrowDown') {
                e.preventDefault();
            }
        });
    });

function validateStep1() {
    let isValid = true;

    // Collect all required fields inside Step 1
    document.querySelectorAll('#step1 .required').forEach(function (input) {
        if (input.value.trim() === '') {
            input.classList.add('is-invalid');
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });

    // Image validation
    const imageInput = document.getElementById('imageFile');
    const imageError = document.getElementById('imageError');

    if (!imageInput.files || imageInput.files.length === 0) {
        imageError.classList.remove('d-none');
        isValid = false;
    } else {
        imageError.classList.add('d-none');
    }


    // If valid, switch to Step 2
    if (isValid) {

        const step2Tab = document.querySelector('#step2-tab');
        step2Tab.classList.remove('disabled');
        step2Tab.removeAttribute('tabindex');
        step2Tab.removeAttribute('aria-disabled');
        const tabTrigger = new bootstrap.Tab(step2Tab);
        tabTrigger.show();


        // const tabTrigger = new bootstrap.Tab(document.querySelector('#step2-tab'));
        // tabTrigger.show();
    }
}

// Optional: remove error styling as user types
document.querySelectorAll('#step1 .required').forEach(function (input) {
    input.addEventListener('input', function () {
        if (this.value.trim() !== '') {
            this.classList.remove('is-invalid');
        }
    });
});


// step2
function validateStep2() {
    let isValid = true;

    // Collect all required fields inside Step 1
    document.querySelectorAll('#step2 .required').forEach(function (input) {
        if (input.value.trim() === '') {
            input.classList.add('is-invalid');
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });

    // Image validation
    const imageInput = document.getElementById('imageFile');
    const imageError = document.getElementById('imageError');

    if (!imageInput.files || imageInput.files.length === 0) {
        imageError.classList.remove('d-none');
        isValid = false;
    } else {
        imageError.classList.add('d-none');
    }

    // If valid, switch to Step 2
    if (isValid) {

        const step2Tab = document.querySelector('#step3-tab');
        step2Tab.classList.remove('disabled');
        step2Tab.removeAttribute('tabindex');
        step2Tab.removeAttribute('aria-disabled');
        const tabTrigger = new bootstrap.Tab(step2Tab);
        tabTrigger.show();

        // const tabTrigger = new bootstrap.Tab(document.querySelector('#step2-tab'));
        // tabTrigger.show();
    }
}

// Optional: remove error styling as user types
document.querySelectorAll('#step2 .required').forEach(function (input) {
    input.addEventListener('input', function () {
        if (this.value.trim() !== '') {
            this.classList.remove('is-invalid');
        }
    });
});


// step3
function validateStep3() {
    let isValid = true;

    // Collect all required fields inside Step 1
    document.querySelectorAll('#step3 .required').forEach(function (input) {
        if (input.value.trim() === '') {
            input.classList.add('is-invalid');
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });

    // Image validation
    const imageInput = document.getElementById('imageFile');
    const imageError = document.getElementById('imageError');

    if (!imageInput.files || imageInput.files.length === 0) {
        imageError.classList.remove('d-none');
        isValid = false;
    } else {
        imageError.classList.add('d-none');
    }

    // If valid, switch to Step 2
    if (isValid) {

        const step2Tab = document.querySelector('#step4-tab');
        step2Tab.classList.remove('disabled');
        step2Tab.removeAttribute('tabindex');
        step2Tab.removeAttribute('aria-disabled');
        const tabTrigger = new bootstrap.Tab(step2Tab);
        tabTrigger.show();

        // const tabTrigger = new bootstrap.Tab(document.querySelector('#step2-tab'));
        // tabTrigger.show();
    }
}

// Optional: remove error styling as user types
document.querySelectorAll('#step3 .required').forEach(function (input) {
    input.addEventListener('input', function () {
        if (this.value.trim() !== '') {
            this.classList.remove('is-invalid');
        }
    });
});


// step4
function validateStep4() {
    let isValid = true;

    // Collect all required fields inside Step 1
    document.querySelectorAll('#step4 .required').forEach(function (input) {
        if (input.value.trim() === '') {
            input.classList.add('is-invalid');
            isValid = false;
        } else {
            input.classList.remove('is-invalid');
        }
    });

    // Image validation
    const imageInput = document.getElementById('imageFile');
    const imageError = document.getElementById('imageError');

    if (!imageInput.files || imageInput.files.length === 0) {
        imageError.classList.remove('d-none');
        isValid = false;
    } else {
        imageError.classList.add('d-none');
    }

    // If valid, switch to Step 2
    if (isValid) {

        const step2Tab = document.querySelector('#step5-tab');
        step2Tab.classList.remove('disabled');
        step2Tab.removeAttribute('tabindex');
        step2Tab.removeAttribute('aria-disabled');
        const tabTrigger = new bootstrap.Tab(step2Tab);
        tabTrigger.show();

        // const tabTrigger = new bootstrap.Tab(document.querySelector('#step2-tab'));
        // tabTrigger.show();
    }
}

// Optional: remove error styling as user types
document.querySelectorAll('#step4 .required').forEach(function (input) {
    input.addEventListener('input', function () {
        if (this.value.trim() !== '') {
            this.classList.remove('is-invalid');
        }
    });
});

</script>



<script>
    document.addEventListener('DOMContentLoaded', function () {
        const electiveRadios = document.querySelectorAll('input[name="elective_subject"]');
        const optionalSection = document.getElementById('optional-section');
        // Store elective subject data so we can re-append as needed
        const electiveSubjects = Array.from(electiveRadios).map(radio => ({
            id: radio.value,
            name: radio.getAttribute('data-subject-name'),
        }));
        
        function appendOtherElective(unselectedId) {
            // First, remove any previously added elective subjects
            document.querySelectorAll('.appended-elective').forEach(el => el.remove());
            // Append unselected elective subject
            electiveSubjects.forEach(subject => {
                if (subject.id !== unselectedId) {
                    const fieldset = document.createElement('fieldset');
                    fieldset.classList.add('appended-elective');

                    const input = document.createElement('input');
                    input.type = 'radio';
                    input.id = 'radio_optional_' + subject.id;
                    input.name = 'optional_subject';
                    input.value = subject.id;

                    const label = document.createElement('label');
                    label.htmlFor = input.id;
                    label.textContent = subject.name;
                    label.style.paddingLeft = '4px';

                    fieldset.appendChild(input);
                    fieldset.appendChild(label);

                    optionalSection.appendChild(fieldset);
                }
            });
        }
        // Attach change listeners
        electiveRadios.forEach(radio => {
            radio.addEventListener('change', function () {
                appendOtherElective(this.value);
            });
        });
    });

    
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const electiveRadios = document.querySelectorAll('input[name="elective_subject"]');
        const optionalFields = document.querySelectorAll('#optional-section input[type="radio"]');

        function updateOptionalVisibility(selectedElectiveName) {
            optionalFields.forEach(function (optRadio) {
                const optionalName = optRadio.dataset.optionalSubjectName;

                // If elective is "Higher Math" and optional is "Agriculture", hide it
                if (selectedElectiveName === 'Higher Math' && optionalName === 'Agriculture') {
                    optRadio.closest('fieldset').style.display = 'none';
                    optRadio.checked = false; // Uncheck if it was selected
                } else {
                    optRadio.closest('fieldset').style.display = 'block';
                }
            });
        }

        // Initial run in case a radio is pre-selected
        electiveRadios.forEach(function (radio) {
            if (radio.checked) {
                updateOptionalVisibility(radio.dataset.subjectName);
            }
        });

        // Add event listeners to all elective radios
        electiveRadios.forEach(function (radio) {
            radio.addEventListener('change', function () {
                const selectedName = this.dataset.subjectName;
                updateOptionalVisibility(selectedName);
            });
        });
    });
</script>







    <script>

        // image show
        const input = document.querySelector('.image-uploader__input');
        const previewImage = document.querySelector('.image-uploader__preview-image');

        input.addEventListener('change', () => {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = (event) => {
                previewImage.src = event.target.result;
            };

            reader.readAsDataURL(file);
        });
        // image show
        
        // tab switch
        function nextTab(tabId) {
            const trigger = document.querySelector(`[data-bs-target="#${tabId}"]`);
            const tab = new bootstrap.Tab(trigger);
            tab.show();
        }

        //  function validateStep1() {
        //     const form = document.getElementById('multiStepForm');
        //     if (form.checkValidity()) {
        //         goToTab('step2'); // move to second tab
        //     } else {
        //         form.reportValidity(); // show browser error tooltips
        //     }
        // }

        function goToTab(targetId, currentId = null) {
            if (currentId) {
                const currentTab = document.querySelector(`#${currentId}`);
                const inputs = currentTab.querySelectorAll('input, textarea, select');
                for (let input of inputs) {
                    if (!input.checkValidity()) {
                        input.reportValidity();
                        return;
                    }
                }
            }

            // Switch tab
            document.querySelector(`.nav-link[href="#${targetId}"]`).click();
        }

        // Bootstrap validation
        (() => {
            'use strict';
            const forms = document.querySelectorAll('.needs-validation');
            Array.from(forms).forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        })();
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function() {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function(form) {
                    form.addEventListener('submit', function(event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }

                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script>
        $(".student-search").autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: "{{ route('students.search') }}",
                    data: {
                        query: request.term
                    },
                    success: function (data) {
                        response($.map(data, function (student) {
                            if (/^0/.test(request.term)) { // Check if mobile number starts with 0
                                return {
                                    label: `${student.first_name} ${student.last_name} (${student.guardian_mobile})`,
                                    value: student.student_id_no
                                };
                            } else { // Otherwise, assume it's an ID starting with 1-9
                                return {
                                    label: `${student.first_name} ${student.last_name} (${student.student_id_no})`,
                                    value: student.student_id_no
                                };
                            }
                        }));
                    }
                });
            },
            minLength: 3, // Trigger autocomplete after 3 characters
            select: function (event, ui) {
                // Set the selected sibling name and ID to the input
                $(this).val(ui.item.label); // Set the label (full name with ID/Mobile)
                $(this).siblings('.student-search-value').val(ui.item.value); // Optionally, store student ID in hidden field
                return false;
            },
            focus: function (event, ui) {
                $(this).val(ui.item.label); // Optionally, show full label when focused
                return false;
            }
        });

        $('#copyAddress').on('change', function () {
            if ($(this).is(':checked')) {
                // Copy division value and trigger change event
                const divisionId = $('#present_division_id').val();
                $('#permanent_division_id').val(divisionId).trigger('change');

                // Wait for districts to load before copying district
                setTimeout(() => {
                    const districtId = $('#present_district_id').val();
                    $('#permanent_district_id').val(districtId).trigger('change');

                    // Wait for upazilas to load before copying upazila
                    setTimeout(() => {
                        const upazilaId = $('#present_upazila_id').val();
                        $('#permanent_upazila_id').val(upazilaId).trigger('change');

                        // Wait for unions to load before copying union
                        setTimeout(() => {
                            const unionId = $('#present_union_id').val();
                            $('#permanent_union_id').val(unionId);

                            // Copy textarea content
                            const address = $('#present_address').val();
                            $('#permanent_address').val(address);
                        }, 500);
                    }, 500);
                }, 500);
            }
        });
    </script>
<script>
$(document).ready(function() {
    // Function to load dropdown options
    function loadDropdownOptions(url, targetDropdown, selectedId = null, params = {}) {
        $.ajax({
            url: url,
            type: 'GET',
            data: params,
            success: function(data) {
                let options = '<option value="">Select Option</option>';
                data.forEach(function(item) {
                    options += `<option value="${item.id}" ${selectedId == item.id ? 'selected' : ''}>${item.name}</option>`;
                });
                $(targetDropdown).html(options);
            }
        });
    }

   
    let divisionId = @json($selectedDivision);
    let districtId = @json($selectedDistrict);
    let upazilaId = @json($selectedUpazila);
    let unionId = @json($selectedUnion);

    if (divisionId) {
        loadDropdownOptions("{{ route('locations.districts') }}", '#present_district_id', districtId, {
            division_id: divisionId
        });
        loadDropdownOptions("{{ route('locations.districts') }}", '#permanent_district_id', districtId, {
            division_id: divisionId
        });
    }

    if (districtId) {
        loadDropdownOptions("{{ route('locations.upazilas') }}", '#present_upazila_id', upazilaId, {
            district_id: districtId
        });
        loadDropdownOptions("{{ route('locations.upazilas') }}", '#permanent_upazila_id', upazilaId, {
            district_id: districtId
        });
    }
    
    if (upazilaId) {
        loadDropdownOptions("{{ route('locations.unions') }}", '#present_union_id', unionId, {
            upazila_id: upazilaId
        });
        loadDropdownOptions("{{ route('locations.unions') }}", '#permanent_union_id', unionId, {
            upazila_id: upazilaId
        });
    }

    // Division change event

    $('#present_division_id').change(function() {
        const divisionId = $(this).val();
        if (divisionId) {
            loadDropdownOptions("{{ route('locations.districts') }}", '#present_district_id', districtId, {
                division_id: divisionId
            });
            $('#present_upazila_id').html('<option value="">Select Upazila</option>');
            $('#present_union_id').html('<option value="">Select Union</option>');
        }
    });

    // District change event
    $('#present_district_id').change(function() {
        const districtId = $(this).val();
        if (districtId) {
            loadDropdownOptions("{{ route('locations.upazilas') }}", '#present_upazila_id', upazilaId, {
                district_id: districtId
            });
            $('#present_union_id').html('<option value="">Select Union</option>');
        }
    });

    // Upazila change event
    $('#present_upazila_id').change(function() {
        const upazilaId = $(this).val();
        if (upazilaId) {
            loadDropdownOptions("{{ route('locations.unions') }}", '#present_union_id', unionId, {
                upazila_id: upazilaId
            });
        }
    });

  // Division change event
    $('#permanent_division_id').change(function() {
        const divisionId = $(this).val();
        if (divisionId) {
            loadDropdownOptions("{{ route('locations.districts') }}", '#permanent_district_id', districtId, {
                division_id: divisionId
            });
            $('#permanent_upazila_id').html('<option value="">Select Upazila</option>');
            $('#permanent_union_id').html('<option value="">Select Union</option>');
        }
    });

    // District change event
    $('#permanent_district_id').change(function() {
        const districtId = $(this).val();
        if (districtId) {
            loadDropdownOptions("{{ route('locations.upazilas') }}", '#permanent_upazila_id', upazilaId, {
                district_id: districtId
            });
            $('#permanent_union_id').html('<option value="">Select Union</option>');
        }
    });

    // Upazila change event
    $('#permanent_upazila_id').change(function() {
        const upazilaId = $(this).val();
        if (upazilaId) {
            loadDropdownOptions("{{ route('locations.unions') }}", '#permanent_union_id', unionId, {
                upazila_id: upazilaId
            });
        }
    });
});
</script>
    
</body>

</html>
